/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class LinkRelationOperator {
    private static final Set NULL_SET = new HashSet();
    private final IVirtualComponent component;
    private final PageModelProvider provider;
    private HashMap cacheForeNavLinks = new HashMap();
    private HashMap cacheInNavLinks = new HashMap();
    private ArrayList toHandle = new ArrayList();
    private HashMap fileToDescr = new HashMap();

    public LinkRelationOperator(Collection src, Collection dirty, IVirtualComponent component, PageModelProvider provider) {
        this.component = component;
        this.provider = provider;
        this.fillToHandle(src, dirty);
    }

    public Collection getRelatedFiles() {
        return (Collection)this.toHandle.clone();
    }

    public Map getDescriptionMap() {
        return this.fileToDescr;
    }

    public boolean existNavlink(Collection c) {
        if (c == null) {
            return false;
        }
        for (Map.Entry e : this.cacheForeNavLinks.entrySet()) {
            Collection links = (Collection)e.getValue();
            if (links == null || links.isEmpty() || !c.contains(e.getKey())) continue;
            return true;
        }
        return false;
    }

    private void fillToHandle(Collection src, Collection dirty) {
        HashSet diff = src;
        this.toHandle.addAll(diff);
        while (diff != null && diff.size() > 0) {
            HashSet oldDiff = diff;
            diff = new HashSet();
            for (IFile file : oldDiff) {
                HashSet fore = new HashSet(this.getForeNavLinks(file));
                fore.retainAll(dirty);
                this.addAsHandledItem(fore, file, true, diff);
                this.addAsHandledItem(this.getInNavLinks(file), file, false, diff);
            }
        }
    }

    private void addAsHandledItem(Set files, IFile from, boolean isForeLink, Collection diff) {
        for (Object object : files) {
            if (this.toHandle.contains(object)) continue;
            IFile file = (IFile)object;
            this.toHandle.add(file);
            if (isForeLink || this.component.getProject().equals((Object)file.getProject())) {
                diff.add(file);
            }
            String sep = isForeLink ? SiteNavMessages.INFO_REFERED_BY : SiteNavMessages.INFO_REFER_TO;
            this.fileToDescr.put(file, SiteNavMessages.format1(sep, from.getName()));
        }
    }

    protected Set getForeNavLinks(IFile file) {
        Object cached = this.cacheForeNavLinks.get(file);
        if (cached != null) {
            return (Set)cached;
        }
        HashSet<IFile> result = null;
        SitePageModel model = this.provider.createPageModel(file);
        if (model != null) {
            int i = 0;
            while (i < model.getCommentTagLength()) {
                NavElement elm = model.commentTagItem(i);
                IFile foreItem = elm.getNavspecFile(file, model.getBaseHref());
                if (foreItem != null && foreItem.exists()) {
                    if (result == null) {
                        result = new HashSet<IFile>();
                    }
                    result.add(foreItem);
                }
                ++i;
            }
            model.dispose();
        }
        if (result == null) {
            result = NULL_SET;
        }
        this.cacheForeNavLinks.put(file, result);
        return result;
    }

    protected Set getInNavLinks(IFile file) {
        Object cached = this.cacheInNavLinks.get(file);
        if (cached != null) {
            return (Set)cached;
        }
        Set result = null;
        if (result == null) {
            result = NULL_SET;
        }
        this.cacheInNavLinks.put(file, result);
        return result;
    }

    static interface PageModelProvider {
        public SitePageModel createPageModel(IFile var1);
    }
}

