/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.site.GSGroup;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.GSStructure;
import com.ibm.etools.siteedit.internal.builder.site.SiteModelProvider;
import com.ibm.etools.siteedit.internal.builder.util.GroupUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class GroupUtilImpl
extends GroupUtil {
    final IVirtualComponent component;

    public GroupUtilImpl(IVirtualComponent component) {
        this.component = component;
    }

    @Override
    public GroupUtil.GroupData[] getGroups() {
        return this.getGroupsRoot().getChildren();
    }

    @Override
    public GroupUtil.GroupData getGroupsRoot() {
        return this.process(this.component);
    }

    private GroupUtil.GroupData process(IVirtualComponent component) {
        GSStructure struc = new GSStructure(component, new SiteModelProvider(){

            @Override
            public SiteModel getSiteModel(IVirtualComponent comp) {
                return GroupUtilImpl.this.getSiteModelLocal(comp);
            }

            @Override
            public long getModificationStamp(IVirtualComponent comp) {
                return -1L;
            }
        });
        GroupDataImpl head = new GroupDataImpl(null, component);
        this.enumGroup(struc.getTop(), null, 0, head);
        return head;
    }

    private void enumGroup(GSPage[] children, GroupDataImpl parent, int parentDepth, GroupDataImpl head) {
        HashSet done = new HashSet(children.length);
        int i = 0;
        while (i < children.length) {
            if (!done.contains(children[i])) {
                if (children[i] instanceof GSGroup) {
                    this.enumGroupHandleGroup((GSGroup)children[i], parent, parentDepth, head, done);
                } else {
                    this.enumGroup(children[i].getChildren(), parent, parentDepth - 1, head);
                }
            }
            ++i;
        }
    }

    private void enumGroupHandleGroup(GSGroup group, GroupDataImpl parent, int parentDepth, GroupDataImpl head, HashSet done) {
        done.add(this);
        GroupDataImpl toAdd = head;
        if (parent != null && parentDepth > 0) {
            toAdd = parent;
        }
        GroupDataImpl data = new GroupDataImpl(group, this.component);
        toAdd.addChild(data);
        int depth = group.getGroupModel().getDepth();
        if (depth <= 0) {
            depth = Integer.MAX_VALUE;
        }
        GSPage[] children = group.getGroupContent();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof GSGroup) {
                GSGroup gsgroup = (GSGroup)children[i];
                this.enumGroupHandleGroup(gsgroup, data, depth, head, done);
            } else {
                done.add(children[i]);
                this.enumGroup(children[i].getChildren(), data, depth - 1, head);
            }
            ++i;
        }
    }

    protected SiteModel getSiteModelLocal(IVirtualComponent component) {
        SiteModelContainer smc = SiteCorePlugin.getDefault().getSiteModelManager().getModelContainerForRead(component);
        try {
            if (smc != null) {
                SiteModel siteModel = smc.getSiteModel();
                return siteModel;
            }
        }
        finally {
            if (smc != null) {
                smc.release();
            }
        }
        return null;
    }

    static class GroupDataImpl
    implements GroupUtil.GroupData {
        final IVirtualComponent component;
        final IVirtualComponent groupComponent;
        final String groupId;
        final String title;
        ArrayList children;
        GroupUtil.GroupData parent;

        GroupDataImpl(GSGroup group, IVirtualComponent component) {
            this.component = component;
            this.groupComponent = group == null ? null : group.getComponent();
            this.groupId = group == null ? null : group.getGroupModel().getGourpId();
            this.title = group == null ? null : group.getGroupModel().getTitle();
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public IVirtualComponent getComponent() {
            return this.groupComponent;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public GroupUtil.GroupData[] getChildren() {
            if (this.children == null) {
                return new GroupUtil.GroupData[0];
            }
            GroupUtil.GroupData[] result = this.children.toArray(new GroupUtil.GroupData[this.children.size()]);
            Arrays.sort(result, new Comparator(){
                private Collator collator = Collator.getInstance();

                public int compare(Object o1, Object o2) {
                    GroupUtil.GroupData g1 = (GroupUtil.GroupData)o1;
                    GroupUtil.GroupData g2 = (GroupUtil.GroupData)o2;
                    if (GroupDataImpl.this.component.equals(g1.getComponent())) {
                        if (GroupDataImpl.this.component.equals(g2.getComponent())) {
                            return this.compareTitle(g1, g2);
                        }
                        return -1;
                    }
                    if (GroupDataImpl.this.component.equals(g2.getComponent())) {
                        return 1;
                    }
                    int comp = WebComponentUtil.encodeComponentToText(g1.getComponent()).compareTo(WebComponentUtil.encodeComponentToText(g2.getComponent()));
                    return comp != 0 ? comp : this.compareTitle(g1, g2);
                }

                private int compareTitle(GroupUtil.GroupData g1, GroupUtil.GroupData g2) {
                    return this.collator.compare(g1.getTitle(), g2.getTitle());
                }
            });
            return result;
        }

        @Override
        public String getEncodedGroupIdFor() {
            if (this.component == null || this.groupComponent.equals(this.component)) {
                return this.groupId;
            }
            return String.valueOf(WebComponentUtil.encodeComponentToText(this.groupComponent)) + '/' + this.groupId;
        }

        public void addChild(GroupUtil.GroupData child) {
            if (this.children == null) {
                this.children = new ArrayList(3);
            }
            this.children.add(child);
            child.setParent(this);
        }

        @Override
        public GroupUtil.GroupData getParent() {
            return this.parent;
        }

        @Override
        public void setParent(GroupUtil.GroupData parent) {
            this.parent = parent;
        }

        @Override
        public void removeChildren() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        @Override
        public void addChildren(GroupUtil.GroupData[] children) {
            if (this.children == null) {
                this.children = new ArrayList(3);
            }
            this.children.addAll(Arrays.asList(children));
        }
    }
}

