/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelFactory;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecProvider;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import com.ibm.etools.siteedit.internal.builder.util.BuilderCacheManager;
import com.ibm.etools.siteedit.internal.builder.util.VirtualComponentMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class GlobalContext {
    private BuilderCacheManager cacheManager = SiteCorePlugin.getDefault().getBuilderCacheManager();
    private VirtualComponentMap allFilesInSiteCache = new VirtualComponentMap();
    private static GlobalContext _instance;

    public BuildContext getBuildContext(IVirtualComponent component) {
        return new BuildContext(component, this);
    }

    public NavspecProvider getNavspecProvider() {
        return this.getCacheMgr().getNavspecProvider();
    }

    public SitePageModelFactory getPageModelFactory() {
        return this.getCacheMgr().getSitePageModelFactory();
    }

    public void notifySiteConfigUpdatedBySiteUpdateBuilder(IVirtualComponent component, long prevStamp, long newStamp) {
        this.cacheManager.notifyUpdatedBySiteUpdateBuilder(component, prevStamp, newStamp);
    }

    BuilderCacheManager getCacheMgr() {
        return this.cacheManager;
    }

    public void clearCache(IProject project) {
        this.getNavspecProvider().clear(project);
        this.getPageModelFactory().clear(project);
    }

    Set getAllFilesInSiteCache(IVirtualComponent component, long ts) {
        AllFilesEntry entry = (AllFilesEntry)this.allFilesInSiteCache.get(component);
        if (entry != null) {
            if (entry.timeStamp == ts) {
                return entry.data;
            }
            this.allFilesInSiteCache.remove(component);
        }
        return null;
    }

    void putAllFilesInSiteCache(IVirtualComponent component, long ts, Set data) {
        this.allFilesInSiteCache.put(component, new AllFilesEntry(ts, data));
    }

    public static GlobalContext getInstance() {
        if (_instance == null) {
            _instance = new GlobalContext();
        }
        return _instance;
    }

    private static final class AllFilesEntry {
        public final long timeStamp;
        public final Set data;

        public AllFilesEntry(long timeStamp, Set data) {
            this.timeStamp = timeStamp;
            this.data = data;
        }
    }
}

