/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.ResourceHandler;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelFactory;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecProvider;
import com.ibm.etools.siteedit.internal.builder.util.BuildSiteStructureManager;
import com.ibm.etools.siteedit.internal.builder.util.VirtualComponentMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.equinox.memory.LowMemoryListener;
import org.eclipse.equinox.memory.MemoryManager;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class BuilderCacheManager
extends LowMemoryListener {
    private VirtualComponentMap strucMgr = new VirtualComponentMap();
    private NavspecProvider navspecProvider = new NavspecProvider();
    protected SitePageModelFactory sitePageModelFactory = new SitePageModelFactory();
    private Preferences.IPropertyChangeListener encodingChangeListener;
    private static final String PAGE_MODEL_CACHE_NAME = ".sitePageModel.dat";

    public void startup() {
        this.loadAll();
        this.addEncodingListener();
        MemoryManager.addLowMemoryListener((LowMemoryListener)this);
    }

    public void shutdown() {
        this.saveAll();
        this.removeEncodingListener();
        MemoryManager.removeListener((LowMemoryListener)this);
    }

    private void loadAll() {
        this.loadStrucManager();
        this.restorePageModelFactory();
    }

    private void saveAll() {
        this.saveStrucManager();
        this.savePageModelFactory();
    }

    public BuildSiteStructureManager getSiteStrucManager(IVirtualComponent component) {
        Object ssm = this.strucMgr.get(component);
        if (ssm == null) {
            ssm = new BuildSiteStructureManager();
            this.strucMgr.put(component, ssm);
        }
        return (BuildSiteStructureManager)ssm;
    }

    public void clearSiteStrucManager(IVirtualComponent component) {
        this.strucMgr.remove(component);
    }

    void notifyUpdatedBySiteUpdateBuilder(IVirtualComponent component, long prevStamp, long newStamp) {
        for (BuildSiteStructureManager ssm : this.strucMgr.values()) {
            ssm.notifyUpdatedBySiteUpdateBuilder(component, prevStamp, newStamp);
        }
    }

    private void loadStrucManager() {
        BuildSiteStructureManager.loadAll(this.strucMgr);
    }

    private void saveStrucManager() {
        BuildSiteStructureManager.saveAll(this.strucMgr);
    }

    public static File getStateFile(IVirtualComponent component, String filename) {
        return new Path(String.valueOf(SiteCorePlugin.getDefault().getStateLocation().toString()) + File.separator + component.getProject().getName() + filename).toFile();
    }

    private static String getStateFilename(String filenam) {
        SiteCorePlugin plugin = SiteCorePlugin.getDefault();
        if (plugin != null) {
            return String.valueOf(plugin.getStateLocation().toString()) + File.separator + filenam;
        }
        return null;
    }

    public NavspecProvider getNavspecProvider() {
        return this.navspecProvider;
    }

    public SitePageModelFactory getSitePageModelFactory() {
        return this.sitePageModelFactory;
    }

    private void addEncodingListener() {
        this.encodingChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent e) {
                if ("encoding".equals(e.getProperty())) {
                    BuilderCacheManager.this.sitePageModelFactory.clear();
                }
            }
        };
        Preferences p = ResourcesPlugin.getPlugin().getPluginPreferences();
        p.addPropertyChangeListener(this.encodingChangeListener);
    }

    private void removeEncodingListener() {
        Preferences p = ResourcesPlugin.getPlugin().getPluginPreferences();
        p.removePropertyChangeListener(this.encodingChangeListener);
        this.encodingChangeListener = null;
    }

    private void savePageModelFactory() {
        String filename = BuilderCacheManager.getStateFilename(PAGE_MODEL_CACHE_NAME);
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(filename));
            os.writeObject(this.getCurrentEncoding());
            this.sitePageModelFactory.refine();
            os.writeObject(this.sitePageModelFactory);
            os.close();
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private void restorePageModelFactory() {
        String filename = BuilderCacheManager.getStateFilename(PAGE_MODEL_CACHE_NAME);
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(file));
            try {
                if (!this.getCurrentEncoding().equals(is.readObject())) {
                    return;
                }
                this.sitePageModelFactory = (SitePageModelFactory)is.readObject();
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            Logger.log(e);
            file.delete();
        }
    }

    private String getCurrentEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public String getDescription() {
        return ResourceHandler._UI_BuilderCacheManager_0;
    }

    public int getCount() {
        return this.navspecProvider.getSize() + this.sitePageModelFactory.getSize();
    }

    public long getSize() {
        return this.navspecProvider.getSize() * 25 + this.sitePageModelFactory.getSize() * 125;
    }

    public void memoryIsLow(int serverity) {
        switch (serverity) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.sitePageModelFactory.clear();
                this.navspecProvider.clear();
            }
        }
    }
}

