/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.util.VirtualComponentMap;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildSiteStructureManager {
    private ArrayList status = new ArrayList();
    private static final String ELM_ROOT = "multisite-config";
    private static final String ELM_PROJECT = "project-data";
    private static final String ATTR_NAME = "name";
    private static final String ELM_DATA = "data";
    private static final String ELM_ITEM = "item";
    private static final String ATTR_STAMP = "stamp";

    public boolean isUpdated(Collection relatedProject) {
        VirtualComponentMap[] curStatus = this.status.toArray(new VirtualComponentMap[this.status.size()]);
        int i = 0;
        while (i < curStatus.length) {
            if (relatedProject.equals(curStatus[i].keySet())) {
                for (IVirtualComponent comp : relatedProject) {
                    Long stamp = (Long)curStatus[i].get(comp);
                    IFile siteXml = WebComponentUtil.getActiveWebSiteConfigFile(comp);
                    long newStamp = -1L;
                    if (siteXml != null) {
                        newStamp = siteXml.getModificationStamp();
                    }
                    if (stamp != null && stamp == newStamp) continue;
                    this.removeRelated(relatedProject);
                    return true;
                }
                return false;
            }
            ++i;
        }
        this.removeRelated(relatedProject);
        return true;
    }

    public void update(Collection relatedComponent) {
        this.removeRelated(relatedComponent);
        VirtualComponentMap newData = new VirtualComponentMap();
        for (IVirtualComponent comp : relatedComponent) {
            IFile siteXml = WebComponentUtil.getActiveWebSiteConfigFile(comp);
            long newStamp = -1L;
            if (siteXml != null) {
                newStamp = siteXml.getModificationStamp();
            }
            newData.put(comp, new Long(newStamp));
        }
        this.status.add(newData);
    }

    public void removeRelated(Collection projects) {
        VirtualComponentMap[] curStatus = this.status.toArray(new VirtualComponentMap[this.status.size()]);
        int i = 0;
        while (i < curStatus.length) {
            for (IVirtualComponent e : projects) {
                if (!curStatus[i].containsKey(e)) continue;
                this.status.remove(curStatus[i]);
            }
            ++i;
        }
    }

    void notifyUpdatedBySiteUpdateBuilder(IVirtualComponent component, long prevStamp, long newStamp) {
        for (VirtualComponentMap curStatus : this.status) {
            Long prev = (Long)curStatus.get(component);
            if (prev == null || prev != prevStamp) continue;
            curStatus.put(component, new Long(newStamp));
        }
    }

    public void appendDataToElement(Element parent, IVirtualComponent component) {
        if (!component.exists()) {
            return;
        }
        Document doc = parent.getOwnerDocument();
        Element e = doc.createElement(ELM_PROJECT);
        parent.appendChild(e);
        e.setAttribute(ATTR_NAME, WebComponentUtil.encodeComponentToText(component));
        int nArray = this.status.size();
        int i = 0;
        while (i < nArray) {
            Element dataElm = doc.createElement(ELM_DATA);
            e.appendChild(dataElm);
            VirtualComponentMap map = (VirtualComponentMap)this.status.get(i);
            for (IVirtualComponent comp : map.keySet()) {
                Element itemElm = doc.createElement(ELM_ITEM);
                dataElm.appendChild(itemElm);
                itemElm.setAttribute(ATTR_NAME, WebComponentUtil.encodeComponentToText(comp));
                itemElm.setAttribute(ATTR_STAMP, map.get(comp).toString());
            }
            ++i;
        }
    }

    public static BuildSiteStructureManager loadDataFromNode(Element e, IVirtualComponent[] rproject) {
        String pname = e.getAttribute(ATTR_NAME);
        IVirtualComponent component = WebComponentUtil.getFirstComponent(SiteResourceUtil.getProject(pname));
        if (component == null || !component.exists()) {
            return null;
        }
        rproject[0] = component;
        BuildSiteStructureManager ssm = new BuildSiteStructureManager();
        Node n = e.getFirstChild();
        while (n != null) {
            Element dataElm;
            if (n.getNodeType() == 1 && (dataElm = (Element)n).getTagName().equals(ELM_DATA)) {
                VirtualComponentMap map = new VirtualComponentMap();
                Node nn = dataElm.getFirstChild();
                while (nn != null) {
                    Element itemElm;
                    if (nn.getNodeType() == 1 && (itemElm = (Element)nn).getTagName().equals(ELM_ITEM)) {
                        IVirtualComponent comp;
                        String val;
                        block8: {
                            String name = itemElm.getAttribute(ATTR_NAME);
                            val = itemElm.getAttribute(ATTR_STAMP);
                            try {
                                comp = WebComponentUtil.getFirstComponent(SiteResourceUtil.getProject(name));
                                if (comp != null && comp.exists()) break block8;
                                return null;
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                        Long value = new Long(val);
                        map.put(comp, value);
                    }
                    nn = nn.getNextSibling();
                }
                ssm.status.add(map);
            }
            n = n.getNextSibling();
        }
        return ssm;
    }

    private static String getStateFilename() {
        SiteCorePlugin plugin = SiteCorePlugin.getDefault();
        if (plugin != null) {
            return String.valueOf(plugin.getStateLocation().toString()) + "/.multisiteinfo";
        }
        return null;
    }

    public static void saveAll(VirtualComponentMap map) {
        try {
            String filename = BuildSiteStructureManager.getStateFilename();
            if (filename == null) {
                return;
            }
            SiteXmlDocumentUtil docUtil = new SiteXmlDocumentUtil();
            docUtil.setRootElementName(ELM_ROOT);
            docUtil.loadBlank();
            Element root = docUtil.getRootElement();
            for (IVirtualComponent comp : map.keySet()) {
                BuildSiteStructureManager ssm = (BuildSiteStructureManager)map.get(comp);
                ssm.appendDataToElement(root, comp);
            }
            docUtil.save(filename);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public static void loadAll(VirtualComponentMap map) {
        try {
            map.clear();
            SiteXmlDocumentUtil docUtil = new SiteXmlDocumentUtil();
            docUtil.setRootElementName(ELM_ROOT);
            docUtil.load(BuildSiteStructureManager.getStateFilename());
            Element root = docUtil.getRootElement();
            if (root == null) {
                return;
            }
            Node n = root.getFirstChild();
            while (n != null) {
                IVirtualComponent[] p;
                Element ee;
                BuildSiteStructureManager ssm;
                if (n.getNodeType() == 1 && (ssm = BuildSiteStructureManager.loadDataFromNode(ee = (Element)n, p = new IVirtualComponent[1])) != null) {
                    map.put(p[0], ssm);
                }
                n = n.getNextSibling();
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }
}

