/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.site.handler;

import com.ibm.etools.siteedit.internal.builder.common.TagAttrImpl;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.NavTagHandler;
import com.ibm.etools.siteedit.internal.builder.model.SitePageContext;
import com.ibm.etools.siteedit.internal.builder.navmenuscript.NavMenuScriptMaker;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageWriterImpl;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.SiteNavMaker;
import com.ibm.etools.siteedit.internal.builder.site.bean.NavMenuId;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNav;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNavItem;
import com.ibm.etools.siteedit.internal.builder.site.handler.GSModelHandler;
import com.ibm.etools.siteedit.sitetags.model.NavModel;
import com.ibm.etools.siteedit.sitetags.model.SiteTagModelFactory;
import com.ibm.etools.siteedit.sitetags.model.SiteTagStrings;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class NavmenuTagHandler
extends NavTagHandler {
    public static String PAGEDATA_NAVMENU_ID_BEAN = "navmenuid";
    public static String NAVMENU_PREFIX = "sdnavmenu";
    private static String EMPTY = "";
    private static String LINE_DEL = "\n";
    private static String LINE_IND = "\t";
    private int menuDepth;
    private String styleClass;
    private boolean isVertical;
    private boolean isTab;
    private boolean keepSelection;
    private boolean includeTop;
    private NavMenuScriptMaker scriptMaker;

    NavmenuTagHandler(GSModelHandler gsModelHandler) {
        super(gsModelHandler);
    }

    @Override
    public String getResult(NavElement node, SitePageContext context) {
        IFile currentFile = context.getContextFile();
        GSPage gsPage = this.gsModelHandler.getGSPage(currentFile);
        NavModel navModel = (NavModel)SiteTagModelFactory.createModel(this.getModifiedNode(node));
        SiteNav bean = SiteNavMaker.createNav(this.gsModelHandler.getGSStructure(), gsPage, navModel, context.isTemplate());
        if (NavmenuTagHandler.isEmptyObject(bean.getItems())) {
            return EMPTY;
        }
        String navMenuId = this.getNavMenuId(context);
        this.scriptMaker = new NavMenuScriptMaker(node, navMenuId, bean, this.menuDepth);
        this.styleClass = node.getAttr("styleClass");
        this.isVertical = node.getAttr("type").equals("verticalMenu");
        this.isTab = node.getAttr("type").equals("tabbedMenu");
        this.keepSelection = node.getAttr("keepSelection").equals(SiteTagStrings.TRUE);
        this.includeTop = node.getAttr("includeTop").equals(SiteTagStrings.TRUE);
        String scriptTag = this.getScriptTag();
        String divTag = this.getDivTag(navMenuId);
        PageWriterImpl writer = new PageWriterImpl();
        writer.print(divTag);
        writer.print(scriptTag);
        return writer.getContent();
    }

    private NavElement getModifiedNode(NavElement node) {
        TagAttrImpl attrs = new TagAttrImpl();
        if (node.getAttr("includeTop").equals(SiteTagStrings.TRUE)) {
            attrs.put("target", "home");
        }
        if (!node.getAttr("startGroup").equals(EMPTY)) {
            attrs.put("group", node.getAttr("startGroup"));
        }
        try {
            this.menuDepth = Integer.parseInt(node.getAttr("depth"));
            try {
                String startLevel = node.getAttr("startLevel");
                int startLevelInt = Integer.parseInt(startLevel);
                attrs.put("targetlevel", String.valueOf(startLevel) + "-" + Integer.toString(startLevelInt + this.menuDepth - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (NumberFormatException numberFormatException) {
            this.menuDepth = 0;
        }
        attrs.putAll((TagAttrImpl)node.getAllAttr());
        NavElement modifiedNode = new NavElement(node.getType(), node.getTagName(), attrs, node.getErrorReporter(), node.isCustomTag());
        return modifiedNode;
    }

    private String getNavMenuId(SitePageContext context) {
        Object idBean = context.getPageData().get(PAGEDATA_NAVMENU_ID_BEAN);
        if (idBean == null) {
            idBean = new NavMenuId(NAVMENU_PREFIX);
            context.getPageData().put(PAGEDATA_NAVMENU_ID_BEAN, idBean);
        }
        return ((NavMenuId)idBean).getId();
    }

    private String getDivTag(String navMenuId) {
        StringBuffer menu = new StringBuffer();
        menu.append(LINE_DEL);
        if (this.menuDepth > 0 || this.includeTop) {
            menu.append(this.createMenu(1, navMenuId));
            if (this.isTab && this.keepSelection && this.menuDepth > 1) {
                menu.append(this.createMenu(2, navMenuId));
            }
        }
        return menu.toString();
    }

    private String createMenu(int l, String navMenuId) {
        String level = "_" + Integer.toString(l);
        StringBuffer divTable = new StringBuffer();
        TagAttrImpl attr = new TagAttrImpl();
        if (l == 1) {
            attr.put("id", navMenuId);
            if (!this.styleClass.equals(EMPTY)) {
                attr.put("class", String.valueOf(this.styleClass) + " " + this.styleClass + level + "_div");
            }
        } else if (l == 2) {
            attr.put("id", String.valueOf(navMenuId) + "_2");
            if (!this.styleClass.equals(EMPTY)) {
                attr.put("class", String.valueOf(this.styleClass) + level + "_div");
            }
        }
        if (this.isTab) {
            attr.put("align", "center");
        }
        divTable.append(this.getBeginTag("DIV", attr, 1));
        attr = new TagAttrImpl();
        if (!this.styleClass.equals(EMPTY)) {
            attr.put("class", String.valueOf(this.styleClass) + level + "_table");
        }
        attr.put("cellpadding", "0");
        attr.put("cellspacing", "0");
        attr.put("border", "0");
        divTable.append(this.getBeginTag("TABLE", attr, 2));
        divTable.append(this.getBeginTag("TBODY", null, 3));
        divTable.append(this.createMenuItems(l, level));
        divTable.append(this.getEndTag("TBODY", 3, true));
        divTable.append(this.getEndTag("TABLE", 2, true));
        divTable.append(this.getEndTag("DIV", 1, true));
        return divTable.toString();
    }

    private String createMenuItems(int l, String level) {
        List itemList;
        StringBuffer menuItems = new StringBuffer();
        if (l == 1) {
            menuItems.append(this.createItemLabel(null, "_separator_first", level));
        }
        if ((itemList = this.scriptMaker.getMenuItems(l)) != null) {
            int size = itemList.size();
            int mousedId = l == 1 ? Math.max(this.scriptMaker.getInitialIdx() - 1, 0) : 0;
            while (mousedId < size && ((SiteNavItem)itemList.get(mousedId)).isGroup()) {
                ++mousedId;
            }
            int begin = 0;
            while (begin < size && ((SiteNavItem)itemList.get(begin)).isGroup()) {
                menuItems.append(this.createItemLabel((SiteNavItem)itemList.get(begin), "_separator", level));
                ++begin;
            }
            int i = begin;
            while (i < size) {
                if (((SiteNavItem)itemList.get(i)).isGroup()) {
                    menuItems.append(this.createItemLabel((SiteNavItem)itemList.get(i), "_separator", level));
                } else if (i == mousedId) {
                    menuItems.append(this.createItemLabel((SiteNavItem)itemList.get(i), "_cell_moused", level));
                } else {
                    menuItems.append(this.createItemLabel((SiteNavItem)itemList.get(i), "_cell_normal", level));
                }
                ++i;
            }
        }
        if (l == 1) {
            menuItems.append(this.createItemLabel(null, "_separator_last", level));
        }
        if (this.isVertical) {
            return menuItems.toString();
        }
        StringBuffer horizontalItems = new StringBuffer();
        horizontalItems.append(this.getBeginTag("TR", null, 4));
        horizontalItems.append(menuItems);
        horizontalItems.append(this.getEndTag("TR", 4, true));
        return horizontalItems.toString();
    }

    private String createItemLabel(SiteNavItem item, String suffix, String level) {
        TagAttrImpl attr;
        StringBuffer menuItem = new StringBuffer();
        if (suffix == null) {
            suffix = EMPTY;
        }
        String itemClassSuffix = null;
        if (suffix.endsWith("normal")) {
            itemClassSuffix = "_item_normal";
        } else if (suffix.endsWith("moused")) {
            itemClassSuffix = "_item_moused";
        }
        if (this.styleClass.equals(EMPTY)) {
            attr = null;
        } else {
            attr = new TagAttrImpl();
            attr.put("class", String.valueOf(this.styleClass) + level + suffix);
        }
        menuItem.append(this.getBeginTag("TD", attr, 5, false));
        if (itemClassSuffix != null) {
            if (this.styleClass.equals(EMPTY)) {
                attr = null;
            } else {
                attr = new TagAttrImpl();
                attr.put("class", String.valueOf(this.styleClass) + level + itemClassSuffix);
            }
            menuItem.append(this.getBeginTag("A", attr, 0, false));
        }
        if (item != null) {
            menuItem.append(item.getLabel());
        }
        if (itemClassSuffix != null) {
            menuItem.append(this.getEndTag("A", 0, false));
        }
        menuItem.append(this.getEndTag("TD", 0, true));
        if (this.isVertical) {
            StringBuffer verticalItem = new StringBuffer();
            verticalItem.append(this.getBeginTag("TR", null, 4));
            verticalItem.append(menuItem);
            verticalItem.append(this.getEndTag("TR", 4, true));
            return verticalItem.toString();
        }
        return menuItem.toString();
    }

    private String getScriptTag() {
        if (this.scriptMaker == null) {
            return EMPTY;
        }
        StringBuffer script = new StringBuffer();
        script.append(this.getBeginTag("SCRIPT", null, 1));
        script.append(this.scriptMaker.eval());
        script.append(this.getEndTag("SCRIPT", 1, true));
        return script.toString();
    }

    private String getBeginTag(String tag, TagAttrImpl attr, int indent) {
        return this.getBeginTag(tag, attr, indent, true);
    }

    private String getBeginTag(String tag, TagAttrImpl attr, int indent, boolean lineBreak) {
        StringBuffer tagString = new StringBuffer();
        tagString.append(this.getIndent(indent));
        tagString.append("<" + tag.toLowerCase());
        if (attr != null) {
            Collection attrColl = attr.getNames();
            for (String key : attrColl) {
                String val = attr.get(key);
                tagString.append(" " + key + "=\"" + val + "\"");
            }
        }
        tagString.append(">");
        if (lineBreak) {
            tagString.append(LINE_DEL);
        }
        return tagString.toString();
    }

    private String getEndTag(String tag, int indent, boolean linebreak) {
        StringBuffer tagString = new StringBuffer();
        tagString.append(this.getIndent(indent));
        tagString.append("</" + tag.toLowerCase() + ">");
        if (linebreak) {
            tagString.append(LINE_DEL);
        }
        return tagString.toString();
    }

    private String getIndent(int indent) {
        String tab = EMPTY;
        int i = 0;
        while (i < indent) {
            tab = tab.concat(LINE_IND);
            ++i;
        }
        return tab;
    }
}

