/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.site;

import com.ibm.etools.siteedit.core.ResourceHandler;
import com.ibm.etools.siteedit.internal.builder.common.TagAttrImpl;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.site.GSGroup;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.GSStructure;
import com.ibm.etools.siteedit.internal.builder.site.GSUnmappedPage;
import com.ibm.etools.siteedit.internal.builder.site.SiteModelProvider;
import com.ibm.etools.siteedit.internal.builder.site.SiteNavGroupMapImpl;
import com.ibm.etools.siteedit.internal.builder.site.SiteNavImpl;
import com.ibm.etools.siteedit.internal.builder.site.SiteNavItemImpl;
import com.ibm.etools.siteedit.internal.builder.site.SiteNavTreeNodeImpl;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNav;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNavItem;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNavTreeNode;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.NavItemSiteComponent;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.sitetags.model.NavMenuModel;
import com.ibm.etools.siteedit.sitetags.model.NavModel;
import com.ibm.etools.siteedit.sitetags.model.NavSiteMapModel;
import com.ibm.etools.siteedit.sitetags.model.NavTrailModel;
import com.ibm.etools.siteedit.sitetags.model.SiteTagModel;
import com.ibm.etools.siteedit.sitetags.model.SiteTagModelFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class SiteNavMaker {
    private static final String LEVEL_GROUP_ID = "levelGroup";
    private static final String LEVEL_TITLE = ResourceHandler.SiteNavMaker_2;
    private static final String LEVEL_SRC = "Level ";
    private static final String ITEM_TITLE = ResourceHandler.SiteNavMaker_13;
    private static final String ITEM_SRC = "Level ";
    private static final String GROUP_TITLE = ResourceHandler.SiteNavMaker_11;
    private static final String TOPPAGE_TITLE = ResourceHandler.SiteNavMaker_26;
    private static final String TOPPAGE_SRC = "Top page";
    private static final SiteNavTreeNodeImpl[] NULL_TREE_NODES = new SiteNavTreeNodeImpl[0];
    private static ItemCollector[] itemCollectors;

    static {
        HashSet<ItemCollector> c = new HashSet<ItemCollector>();
        c.add(new HomeCollector());
        c.add(new ParentCollector());
        c.add(new AncestorCollector());
        c.add(new SelfCollector());
        c.add(new ChildrenCollector());
        c.add(new SiblingCollector());
        c.add(new TopChildrenCollector());
        c.add(new FirstChildCollector());
        c.add(new LevelCollector());
        itemCollectors = c.toArray(new ItemCollector[c.size()]);
    }

    private SiteNavMaker() {
    }

    public static SiteNav createNav(GSStructure model, GSPage self, NavModel nav, boolean isTemplate) {
        Set toShow;
        if (isTemplate) {
            IVirtualComponent component = self.getComponent();
            SiteComponent siteComp = self.getSiteComponent();
            if (self instanceof GSUnmappedPage) {
                siteComp = ((GSUnmappedPage)self).getPageComponent();
            }
            IFile file = SiteResourceUtil.fileForProjectRelative(component, ((PageModel)siteComp).getSRC());
            final SiteModel siteModel = new SiteModel();
            nav = SiteNavMaker.createDummySiteModel(siteModel, SiteResourceUtil.getProjectRelativePathString(component, (IResource)file), nav);
            SiteModelProvider modelProvider = new SiteModelProvider(){

                @Override
                public SiteModel getSiteModel(IVirtualComponent component) {
                    return siteModel;
                }

                @Override
                public long getModificationStamp(IVirtualComponent component) {
                    return 0L;
                }
            };
            GSStructure gsStructure = new GSStructure(component, modelProvider);
            GSPage page = gsStructure.getPage(file);
            model = gsStructure;
            self = page;
        }
        if (model.getTop().length < 1 || nav instanceof NavTrailModel && self instanceof GSUnmappedPage && !isTemplate) {
            return new SiteNavImpl(null, null, nav, null);
        }
        ArrayList arTree = new ArrayList();
        ArrayList arItems = new ArrayList();
        int baseDepth = SiteNavMaker.getDepth(self.getNavRoot());
        if (nav instanceof NavMenuModel) {
            if (nav.getTargetAttribute("home") && !(toShow = SiteNavMaker.collectTop(model, self, nav)).isEmpty()) {
                SiteNavMaker.removeNotIncludeInNavigation(toShow);
                if (toShow.isEmpty()) {
                    arItems.add(null);
                } else {
                    SiteNavMaker.createNavCore(toShow, baseDepth, model, self, nav, arTree, arItems, false);
                }
            }
            if (!(toShow = SiteNavMaker.collectLevelItem(model, self, nav)).isEmpty()) {
                SiteNavMaker.createNavCore(toShow, baseDepth, model, self, nav, arTree, arItems, false);
            }
        } else {
            toShow = SiteNavMaker.collectItem(model, self, nav);
            if (!toShow.isEmpty() || nav.getTargetAttribute("previous") || nav.getTargetAttribute("next")) {
                SiteNavMaker.createNavCore(toShow, baseDepth, model, self, nav, arTree, arItems, true);
            }
        }
        String[] groups = nav.getGroupAttribute();
        int i = 0;
        while (i < groups.length) {
            GSGroup group = model.getGroup(groups[i], self.getComponent());
            if (group != null) {
                Set toShow2;
                if (nav instanceof NavMenuModel) {
                    arItems.add(null);
                    toShow2 = SiteNavMaker.collectGroupAndDescItem(group, nav.getAttribute("depth"));
                } else {
                    toShow2 = SiteNavMaker.collectGroupItem(group);
                }
                if (!toShow2.isEmpty()) {
                    int baseDepth2 = SiteNavMaker.getDepth(group);
                    SiteNavMaker.createNavCore(toShow2, baseDepth2, model, self, nav, arTree, arItems, false);
                }
            }
            ++i;
        }
        SiteNavTreeNode[] tree = arTree.toArray(new SiteNavTreeNodeImpl[arTree.size()]);
        SiteNavItem[] items = arItems.toArray(new SiteNavItemImpl[arItems.size()]);
        SiteNavGroupMapImpl groupMap = new SiteNavGroupMapImpl(model, self.getComponent());
        return new SiteNavImpl(items, tree, nav, groupMap);
    }

    private static void createNavCore(Set toShow, int baseDepth, GSStructure model, GSPage self, NavModel nav, List arTree, List arItems, boolean needPrevNext) {
        if (nav instanceof NavSiteMapModel) {
            SiteNavMaker.removeNotIncludeInSiteMap(toShow);
        } else if (nav instanceof NavMenuModel) {
            SiteNavMaker.removeNotIncludeInNavigationAndChildren(toShow, nav.getAttribute("depth"));
        } else {
            SiteNavMaker.removeNotIncludeInNavigation(toShow);
        }
        if (!nav.getGroupNameAttribute()) {
            SiteNavMaker.removeGroups(toShow);
        }
        SiteNavTreeNodeImpl[] tree = SiteNavMaker.getNavTreeNode(model, self, toShow, nav);
        SiteNavItemImpl[] items = SiteNavMaker.getItemList(self, tree, nav, needPrevNext);
        if (baseDepth > 0) {
            SiteNavTreeNodeImpl n = SiteNavMaker.findRootTreeNode(tree);
            if (n != null) {
                tree = new SiteNavTreeNodeImpl[]{n};
            }
            int i = 0;
            while (i < items.length) {
                items[i].overrideBaseDepth(baseDepth);
                ++i;
            }
        }
        arTree.addAll(Arrays.asList(tree));
        arItems.addAll(Arrays.asList(items));
    }

    private static int getDepth(GSPage p) {
        if (p == null) {
            return 1;
        }
        GSPage parent = p.getParent();
        int i = 1;
        while (parent != null) {
            parent = parent.getParent();
            ++i;
        }
        return i;
    }

    private static void removeNotIncludeInNavigation(Set toShow) {
        HashSet<GSPage> toRemove = new HashSet<GSPage>();
        for (GSPage element : toShow) {
            NavItemSiteComponent pm;
            SiteComponent sc;
            if (element == null || element instanceof GSUnmappedPage || (sc = element.getSiteComponent()) == null || (pm = (NavItemSiteComponent)sc).getNavigation()) continue;
            toRemove.add(element);
        }
        toShow.removeAll(toRemove);
    }

    private static void removeNotIncludeInNavigationAndChildren(Set toShow, String depthString) {
        int menuDepth;
        try {
            menuDepth = Integer.parseInt(depthString);
        }
        catch (NumberFormatException numberFormatException) {
            menuDepth = 0;
        }
        HashSet<GSPage> toRemove = new HashSet<GSPage>();
        for (GSPage element : toShow) {
            SiteComponent[] children;
            NavItemSiteComponent pm;
            SiteComponent sc;
            if (element == null || element instanceof GSUnmappedPage || (sc = element.getSiteComponent()) == null || (pm = (NavItemSiteComponent)sc).getNavigation()) continue;
            toRemove.add(element);
            if (element instanceof GSGroup || (children = sc.getChildren()) == null) continue;
            int i = 0;
            while (i < children.length) {
                SiteNavMaker.removeDescendant(children[i], toShow, toRemove, menuDepth, 2);
                ++i;
            }
        }
        toShow.removeAll(toRemove);
    }

    private static void removeDescendant(SiteComponent sc, Set toShow, Set toRemove, int depth, int count) {
        if (sc == null || count > depth) {
            return;
        }
        for (GSPage element : toShow) {
            SiteComponent showedComponent;
            if (element == null || element instanceof GSUnmappedPage || !sc.equals(showedComponent = element.getSiteComponent())) continue;
            toRemove.add(element);
            if (element instanceof GSGroup) {
                --count;
            } else if (depth == count) {
                return;
            }
            SiteComponent[] children = sc.getChildren();
            if (children == null || children.length == 0) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                SiteNavMaker.removeDescendant(children[i], toShow, toRemove, depth, count + 1);
                ++i;
            }
            return;
        }
    }

    private static void removeNotIncludeInSiteMap(Set toShow) {
        HashSet<GSPage> toRemove = new HashSet<GSPage>();
        for (GSPage element : toShow) {
            NavItemSiteComponent pm;
            SiteComponent sc;
            if (element == null || element instanceof GSUnmappedPage || (sc = element.getSiteComponent()) == null || (pm = (NavItemSiteComponent)sc).getSiteMap()) continue;
            toRemove.add(element);
        }
        toShow.removeAll(toRemove);
    }

    private static void removeGroups(Set toShow) {
        HashSet<GSPage> toRemove = new HashSet<GSPage>();
        for (GSPage element : toShow) {
            if (!(element instanceof GSGroup)) continue;
            toRemove.add(element);
        }
        toShow.removeAll(toRemove);
    }

    private static SiteNavItemImpl[] getItemList(GSPage self, SiteNavTreeNodeImpl[] nodes, NavModel nav, boolean needPrevNext) {
        ArrayList result = new ArrayList();
        SiteNavMaker.getItemListCore(nodes, nav, result);
        if (needPrevNext) {
            SiteNavMaker.appendNextPrev(self, nav, result);
        }
        return result.toArray(new SiteNavItemImpl[result.size()]);
    }

    private static void getItemListCore(SiteNavTreeNodeImpl[] nodes, NavModel nav, List result) {
        int i = 0;
        while (i < nodes.length) {
            SiteNavTreeNodeImpl[] children;
            SiteNavTreeNodeImpl n = nodes[i];
            if (n.getItem() != null) {
                result.add(n.getItem());
            }
            if ((children = (SiteNavTreeNodeImpl[])n.getChildren()) != null) {
                SiteNavMaker.getItemListCore(children, nav, result);
            }
            ++i;
        }
    }

    private static void appendNextPrev(GSPage self, NavModel nav, List result) {
        String label;
        SiteNavItemImpl i;
        GSPage p;
        if (nav.getTargetAttribute("previous") && (p = Util.getPrevPage(self)) != null) {
            i = new SiteNavItemImpl(p, self, 0);
            label = nav.getLabelAttribute("previous");
            if (label != null && label.length() != 0) {
                i.overrideLabel(label);
            }
            result.add(i);
        }
        if (nav.getTargetAttribute("next") && (p = Util.getNextPage(self)) != null) {
            i = new SiteNavItemImpl(p, self, 0);
            label = nav.getLabelAttribute("next");
            if (label != null && label.length() != 0) {
                i.overrideLabel(label);
            }
            result.add(i);
        }
    }

    private static SiteNavTreeNodeImpl[] getNavTreeNode(GSStructure model, GSPage self, Set toShow, NavModel nav) {
        LinkedList<SiteNavTreeNodeImpl> result = new LinkedList<SiteNavTreeNodeImpl>();
        GSPage root = self.getNavRoot();
        GSPage[] tops = model.getTop();
        int i = 0;
        while (i < tops.length) {
            SiteNavTreeNodeImpl nn = SiteNavMaker.getNavTreeNodeCore(tops[i], self, root, toShow, 0);
            if (nn != null) {
                result.add(nn);
            }
            ++i;
        }
        SiteNavTreeNodeImpl[] nodes = result.toArray(new SiteNavTreeNodeImpl[result.size()]);
        if (nav.getTopSiblingAttribute()) {
            SiteNavTreeNodeImpl[] n = nodes;
            while (n != null) {
                SiteNavTreeNodeImpl ancestor = null;
                int i2 = 0;
                while (i2 < n.length) {
                    if (n[i2].isAncestor()) {
                        ancestor = n[i2];
                        System.arraycopy(n, 0, n, 1, i2);
                        n[0] = ancestor;
                        break;
                    }
                    ++i2;
                }
                n = (SiteNavTreeNodeImpl[])(ancestor != null ? ancestor.getChildren() : null);
            }
        }
        return nodes;
    }

    private static SiteNavTreeNodeImpl getNavTreeNodeCore(GSPage target, GSPage self, GSPage root, Set toShow, int depth) {
        GSPage[] children;
        SiteNavTreeNodeImpl result = null;
        if (toShow.contains(target)) {
            SiteNavItemImpl item = depth == 0 && target instanceof GSGroup ? new SiteNavItemImpl(target, self, 1) : new SiteNavItemImpl(target, self, depth);
            result = new SiteNavTreeNodeImpl(item, target == root);
        }
        if ((children = target.getChildren()).length == 0 && target instanceof GSGroup && target.getParent() == null) {
            children = ((GSGroup)target).getGroupContent();
        }
        LinkedList<SiteNavTreeNodeImpl> list = null;
        boolean fAncestor = false;
        int i = 0;
        while (i < children.length) {
            SiteNavTreeNodeImpl c = SiteNavMaker.getNavTreeNodeCore(children[i], self, root, toShow, depth + 1);
            if (c != null) {
                if (list == null) {
                    list = new LinkedList<SiteNavTreeNodeImpl>();
                }
                list.add(c);
                if (c.isAncestor()) {
                    fAncestor = true;
                }
            }
            ++i;
        }
        if (list != null) {
            if (result == null) {
                result = new SiteNavTreeNodeImpl(target == root);
            }
            result.setAncestor(fAncestor || target == self);
            result.setChildren(list.toArray(new SiteNavTreeNodeImpl[list.size()]));
        } else if (result != null) {
            result.setChildren(NULL_TREE_NODES);
            fAncestor = false;
            GSPage cur = self;
            while (cur != null) {
                if (target == cur) {
                    fAncestor = true;
                    break;
                }
                cur = cur.getParent();
            }
            result.setAncestor(fAncestor);
        }
        return result;
    }

    private static SiteNavTreeNodeImpl findRootTreeNode(SiteNavTreeNodeImpl[] t) {
        if (t == null || t.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < t.length) {
            if (t[i].isRoot()) {
                return t[i];
            }
            SiteNavTreeNodeImpl n = SiteNavMaker.findRootTreeNode((SiteNavTreeNodeImpl[])t[i].getChildren());
            if (n != null) {
                return n;
            }
            ++i;
        }
        return null;
    }

    private static Set collectGroupAndDescItem(GSGroup group, String menuDepthString) {
        int menuDepth;
        try {
            menuDepth = Integer.parseInt(menuDepthString);
        }
        catch (NumberFormatException numberFormatException) {
            menuDepth = 0;
        }
        ArrayList<GSGroup> result = new ArrayList<GSGroup>();
        int depth = group.getGroupModel().getDepth();
        if (depth <= 0) {
            depth = Integer.MAX_VALUE;
        }
        if (depth > 0 && menuDepth > 0) {
            result.add(group);
            ArrayList<GSPage> contentPage = new ArrayList<GSPage>();
            contentPage.addAll(Arrays.asList(group.getGroupContent()));
            int cur = 1;
            int i = 0;
            while (i < contentPage.size()) {
                GSPage contentRoot = (GSPage)contentPage.get(i);
                SiteNavMaker.collectDescItems(contentRoot, result, cur, menuDepth, contentRoot);
                ++i;
            }
        }
        return new HashSet(result);
    }

    private static void collectDescItems(GSPage node, ArrayList result, int cur, int depth, GSPage root) {
        result.add(node);
        GSPage next = node.getFirstChildNavItem();
        if (next != null && cur < depth) {
            SiteNavMaker.collectDescItems(next, result, cur + 1, depth, root);
            return;
        }
        if (node.equals(root)) {
            return;
        }
        next = node.getNextSiblingNavItem();
        if (next != null) {
            SiteNavMaker.collectDescItems(next, result, cur, depth, root);
            return;
        }
        node = node.getParent();
        while (node != null && !node.equals(root)) {
            --cur;
            next = node.getNextSiblingNavItem();
            if (next != null) {
                SiteNavMaker.collectDescItems(next, result, cur, depth, root);
                return;
            }
            node = node.getParent();
        }
    }

    private static Set collectGroupItem(GSGroup group) {
        ArrayList<GSPage> result = new ArrayList<GSPage>();
        int depth = group.getGroupModel().getDepth();
        if (depth <= 0) {
            depth = Integer.MAX_VALUE;
        }
        if (depth > 0) {
            result.add(group);
            result.addAll(Arrays.asList(group.getGroupContent()));
            int cur = 0;
            int i = 1;
            while (i < depth) {
                int last = result.size();
                while (cur < last) {
                    GSPage curPage = (GSPage)result.get(cur);
                    result.addAll(Arrays.asList(curPage.getChildren()));
                    ++cur;
                }
                if (last == result.size()) break;
                ++i;
            }
        }
        return new HashSet(result);
    }

    private static Set collectItem(GSStructure model, GSPage self, NavModel nav) {
        HashSet result = new HashSet();
        int itemSize = itemCollectors.length;
        int i = 0;
        while (i < itemSize) {
            ItemCollector c = itemCollectors[i];
            if (c.canHandle(nav)) {
                c.collect(model, self, nav, result);
            }
            ++i;
        }
        return result;
    }

    private static Set collectTop(GSStructure model, GSPage self, NavModel nav) {
        HashSet result = new HashSet();
        HomeCollector c = new HomeCollector();
        if (c.canHandle(nav)) {
            c.collect(model, self, nav, result);
        }
        return result;
    }

    private static Set collectLevelItem(GSStructure model, GSPage self, NavModel nav) {
        HashSet result = new HashSet();
        LevelCollector c = new LevelCollector();
        if (c.canHandle(nav)) {
            c.collect(model, self, nav, result);
        }
        return result;
    }

    private static NavModel createDummySiteModel(SiteModel siteModel, String self, NavModel navModel) {
        if (navModel instanceof NavSiteMapModel) {
            return SiteNavMaker.createDummy4SiteMap(siteModel, navModel);
        }
        if (navModel instanceof NavMenuModel) {
            return SiteNavMaker.createDummy4NavMenu(siteModel, navModel);
        }
        return SiteNavMaker.createDummy(siteModel, self, navModel);
    }

    private static NavModel createDummy4NavMenu(SiteModel siteModel, NavModel navModel) {
        PageModel right;
        PageModel middle;
        PageModel left;
        int i;
        String start = navModel.getAttribute("startLevel");
        String dep = navModel.getAttribute("depth");
        String[] startGroup = navModel.getStartGroupAttribute();
        boolean showGroup = startGroup.length > 0;
        boolean includeTop = navModel.getAttributeBoolean("includeTop");
        int startLevel = -1;
        int depth = -1;
        try {
            startLevel = Integer.parseInt(start);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            depth = Integer.parseInt(dep);
        }
        catch (NumberFormatException numberFormatException) {}
        if (includeTop) {
            GroupModel topGroup = siteModel.createGroupModel();
            topGroup.setNavigation(false);
            siteModel.appendChild(topGroup);
            PageModel topPage = siteModel.createPageModel();
            topPage.setTitle(TOPPAGE_TITLE);
            topPage.setSRC(TOPPAGE_SRC);
            topGroup.appendChild(topPage);
        }
        if (startLevel != -1 && depth != -1) {
            SiteComponent temp = null;
            int begin = 1;
            if (includeTop) {
                begin = startLevel;
            }
            i = begin;
            while (i < startLevel + depth) {
                if (i == begin) {
                    PageModel topLevel = siteModel.createPageModel();
                    topLevel.setTitle(String.valueOf(ResourceHandler.SiteNavMaker_2) + i);
                    topLevel.setSRC("Level " + i);
                    if (includeTop) {
                        GroupModel levelGroup = siteModel.createGroupModel();
                        levelGroup.setGroupId(LEVEL_GROUP_ID);
                        levelGroup.setTitle(LEVEL_TITLE);
                        levelGroup.setNavigation(false);
                        levelGroup.appendChild(topLevel);
                        siteModel.appendChild(levelGroup);
                        navModel = (NavModel)SiteTagModelFactory.createModel(SiteNavMaker.getModifiedNode4NavMenu(navModel.getTagNode(), startGroup, startLevel));
                    } else {
                        siteModel.appendChild(topLevel);
                    }
                    temp = topLevel;
                } else if (i == startLevel) {
                    PageModel startModel = siteModel.createPageModel();
                    startModel.setTitle(String.valueOf(LEVEL_TITLE) + i);
                    startModel.setSRC("Level " + i);
                    temp.appendChild(startModel);
                    temp = startModel;
                } else {
                    left = siteModel.createPageModel();
                    left.setTitle(String.valueOf(LEVEL_TITLE) + i + "-1");
                    left.setSRC("Level " + i + "-1");
                    temp.appendChild(left);
                    middle = siteModel.createPageModel();
                    middle.setTitle(String.valueOf(LEVEL_TITLE) + i + "-2");
                    middle.setSRC("Level " + i + "-2");
                    temp.appendChild(middle);
                    right = siteModel.createPageModel();
                    right.setTitle(String.valueOf(LEVEL_TITLE) + i + "-3");
                    right.setSRC("Level " + i + "-3");
                    temp.appendChild(right);
                    temp = middle;
                }
                ++i;
            }
        }
        if (showGroup && depth != -1) {
            GroupModel group = siteModel.createGroupModel();
            group.setTitle(GROUP_TITLE);
            group.setGroupId(startGroup[0]);
            siteModel.appendChild(group);
            PageModel temp = null;
            i = 1;
            while (i < depth + 1) {
                if (i == 1) {
                    PageModel item1 = siteModel.createPageModel();
                    item1.setTitle(String.valueOf(ITEM_TITLE) + i);
                    item1.setSRC("Level " + i);
                    group.appendChild(item1);
                    temp = item1;
                } else {
                    left = siteModel.createPageModel();
                    left.setTitle(String.valueOf(ResourceHandler.SiteNavMaker_13) + i + "-1");
                    left.setSRC("Level " + i + "-1");
                    temp.appendChild(left);
                    middle = siteModel.createPageModel();
                    middle.setTitle(String.valueOf(ITEM_TITLE) + i + "-2");
                    middle.setSRC("Level " + i + "-2");
                    temp.appendChild(middle);
                    right = siteModel.createPageModel();
                    right.setTitle(String.valueOf(ITEM_TITLE) + i + "-3");
                    right.setSRC("Level " + i + "-3");
                    temp.appendChild(right);
                    temp = middle;
                }
                ++i;
            }
        }
        return navModel;
    }

    private static NavModel createDummy4SiteMap(SiteModel siteModel, NavModel navModel) {
        int[] targetLevel = navModel.getTargetLevelAttributeInt();
        if (targetLevel == null || targetLevel.length < 2) {
            return navModel;
        }
        int step = Math.abs(targetLevel[0] - targetLevel[1]) + 1;
        PageModel page = siteModel.createPageModel();
        page.setTitle(String.valueOf(LEVEL_TITLE) + "1-1");
        page.setSRC("Level 1-1");
        siteModel.appendChild(page);
        PageModel temp = page;
        int i = 1;
        while (i < step) {
            page = siteModel.createPageModel();
            page.setTitle(String.valueOf(LEVEL_TITLE) + (i + 1) + "-1");
            page.setSRC("Level " + (i + 1) + "-1");
            temp.appendChild(page);
            PageModel middle = siteModel.createPageModel();
            middle.setTitle(String.valueOf(LEVEL_TITLE) + (i + 1) + "-2");
            middle.setSRC("Level " + (i + 1) + "-2");
            temp.appendChild(middle);
            page = siteModel.createPageModel();
            page.setTitle(String.valueOf(LEVEL_TITLE) + (i + 1) + "-3");
            page.setSRC("Level " + (i + 1) + "-3");
            temp.appendChild(page);
            temp = middle;
            ++i;
        }
        return navModel;
    }

    private static NavModel createDummy(SiteModel siteModel, String self, NavModel navModel) {
        String[] groups = navModel.getGroupAttribute();
        String prevLabel = null;
        String nextLabel = null;
        List labels = navModel.getAttributeListList("label", ",", "|");
        if (labels != null && labels.size() > 1) {
            List p = (List)labels.get(0);
            List n = (List)labels.get(1);
            if (p.size() > 1) {
                prevLabel = (String)p.get(1);
            }
            if (n.size() > 1) {
                nextLabel = (String)n.get(1);
            }
        }
        int[] targets = navModel.getTargetLevelAttributeInt();
        int start = 0;
        int end = 0;
        if (targets != null && targets.length > 1) {
            start = targets[0];
            end = targets[1];
        }
        PageModel top = siteModel.createPageModel();
        top.setTitle(TOPPAGE_TITLE);
        top.setSRC(TOPPAGE_SRC);
        if (!navModel.getTargetAttribute("home")) {
            top.setNavigation(false);
        }
        siteModel.appendChild(top);
        if (navModel.getTargetAttribute("topchildren")) {
            PageModel topChildren = siteModel.createPageModel();
            topChildren.setTitle(ResourceHandler.SiteNavMaker_27);
            topChildren.setSRC("Children of top page");
            top.appendChild(topChildren);
        }
        PageModel ancestor = siteModel.createPageModel();
        ancestor.setTitle(ResourceHandler.SiteNavMaker_28);
        ancestor.setSRC("Ancestor pages");
        if (!navModel.getTargetAttribute("ancestor")) {
            ancestor.setNavigation(false);
        }
        top.appendChild(ancestor);
        PageModel parent = siteModel.createPageModel();
        parent.setTitle(ResourceHandler.SiteNavMaker_29);
        parent.setSRC("Parent page");
        if (!navModel.getTargetAttribute("parent")) {
            parent.setNavigation(false);
        }
        ancestor.appendChild(parent);
        PageModel sibling = null;
        if (navModel.getTargetAttribute("sibling")) {
            sibling = siteModel.createPageModel();
            sibling.setTitle(ResourceHandler.SiteNavMaker_30);
            sibling.setSRC("Sibling pages");
            parent.appendChild(sibling);
        }
        if (navModel.getTargetAttribute("previous")) {
            PageModel prev = siteModel.createPageModel();
            if (prevLabel != null) {
                prev.setTitle(prevLabel);
            } else {
                prev.setTitle(ResourceHandler.SiteNavMaker_31);
            }
            prev.setSRC("Previous page");
            parent.appendChild(prev);
            if (sibling != null || start <= 4 && 4 <= end) {
                prev.setNavigation(false);
            }
        }
        PageModel current = siteModel.createPageModel();
        current.setTitle(ResourceHandler.SiteNavMaker_32);
        current.setSRC(self);
        if (!navModel.getTargetAttribute("self")) {
            current.setNavigation(false);
        }
        parent.appendChild(current);
        if (navModel.getTargetAttribute("next")) {
            PageModel next = siteModel.createPageModel();
            if (nextLabel != null) {
                next.setTitle(nextLabel);
            } else {
                next.setTitle(ResourceHandler.SiteNavMaker_33);
            }
            next.setSRC("Next page");
            parent.appendChild(next);
            if (sibling != null || start <= 4 && 4 <= end) {
                next.setNavigation(false);
            }
        }
        if (navModel.getTargetAttribute("firstchild")) {
            PageModel firstChild = siteModel.createPageModel();
            firstChild.setTitle(ResourceHandler.SiteNavMaker_34);
            firstChild.setSRC("First child page");
            current.appendChild(firstChild);
        }
        PageModel children = siteModel.createPageModel();
        children.setTitle(ResourceHandler.SiteNavMaker_35);
        children.setSRC("Children pages");
        if (!navModel.getTargetAttribute("children")) {
            children.setNavigation(false);
        }
        current.appendChild(children);
        if (start > 0 && end > 0) {
            SiteComponent temp = null;
            GroupModel levelGroup = siteModel.createGroupModel();
            levelGroup.setNavigation(false);
            int i = 1;
            while (i <= end + 1) {
                PageModel levelModel = siteModel.createPageModel();
                levelModel.setTitle(String.valueOf(LEVEL_TITLE) + i);
                levelModel.setSRC("Level " + i);
                if (i == 1) {
                    levelGroup.appendChild(levelModel);
                    top.appendChild(levelGroup);
                    temp = levelModel;
                } else {
                    temp.appendChild(levelModel);
                }
                if (start > i || i > end) {
                    levelModel.setNavigation(false);
                }
                ++i;
            }
            navModel = (NavModel)SiteTagModelFactory.createModel(SiteNavMaker.getModifiedNode(navModel.getTagNode(), start, end, groups));
        }
        GroupModel group = null;
        if (groups != null && groups.length > 0) {
            group = siteModel.createGroupModel();
            group.setTitle(GROUP_TITLE);
            group.setGroupId(groups[0]);
            siteModel.appendChild(group);
        }
        return navModel;
    }

    private static NavElement getModifiedNode(TagNode node, int startLevel, int endLevel, String[] groups) {
        if (startLevel > 0 && endLevel > 0) {
            TagAttrImpl attrs = new TagAttrImpl();
            attrs.putAll((TagAttrImpl)node.getAllAttr());
            ArrayList<String> newGroups = new ArrayList<String>();
            newGroups.add(LEVEL_GROUP_ID);
            if (groups.length > 0) {
                int i = 0;
                while (i < groups.length) {
                    newGroups.add(groups[i]);
                    ++i;
                }
            }
            String newValue = SiteTagModel.getStringFromList(newGroups, ",");
            attrs.put("group", newValue);
            NavElement modifiedNode = new NavElement(node.getType(), node.getTagName(), attrs, node.getErrorReporter(), ((NavElement)node).isCustomTag());
            return modifiedNode;
        }
        return (NavElement)node;
    }

    private static NavElement getModifiedNode4NavMenu(TagNode node, String[] startGroups, int startLevel) {
        TagAttrImpl attrs = new TagAttrImpl();
        attrs.putAll((TagAttrImpl)node.getAllAttr());
        ArrayList<String> newGroups = new ArrayList<String>();
        newGroups.add(LEVEL_GROUP_ID);
        if (startGroups.length > 0) {
            int i = 0;
            while (i < startGroups.length) {
                newGroups.add(startGroups[i]);
                ++i;
            }
        }
        String newValue = SiteTagModel.getStringFromList(newGroups, ",");
        attrs.put("startGroup", newValue);
        attrs.put("group", newValue);
        if (startLevel == 1) {
            attrs.put("includeTop", "false");
            attrs.put("target", "");
        }
        NavElement modifiedNode = new NavElement(node.getType(), node.getTagName(), attrs, node.getErrorReporter(), ((NavElement)node).isCustomTag());
        return modifiedNode;
    }

    protected static class AncestorCollector
    implements ItemCollector {
        protected AncestorCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("ancestor");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPages(self.getAncestor(), setToAddResult);
        }
    }

    protected static class ChildrenCollector
    implements ItemCollector {
        protected ChildrenCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("children");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPages(self.getChildren(), setToAddResult);
        }
    }

    protected static class FirstChildCollector
    implements ItemCollector {
        protected FirstChildCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("firstchild");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPage(self.getFirstChild(), setToAddResult);
        }
    }

    protected static class HomeCollector
    implements ItemCollector {
        protected HomeCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("home");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPage(self.getTop(), setToAddResult);
        }
    }

    protected static interface ItemCollector {
        public boolean canHandle(NavModel var1);

        public void collect(GSStructure var1, GSPage var2, NavModel var3, Set var4);
    }

    protected static class LevelCollector
    implements ItemCollector {
        protected LevelCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            int[] level = nav.getTargetLevelAttributeInt();
            return level != null && level.length > 0 && level[0] > 0;
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            GSPage navroot = self;
            LinkedList<GSPage> trail = new LinkedList<GSPage>();
            trail.add(navroot);
            if (self instanceof GSUnmappedPage) {
                navroot = ((GSUnmappedPage)self).getParent();
            } else {
                GSPage upper;
                PageModel pm;
                while (!(navroot.getSiteComponent().getType() == SiteComponentType.PAGE && (pm = (PageModel)navroot.getSiteComponent()).getNavroot() || (upper = navroot.getParent()) == null)) {
                    navroot = upper;
                    trail.add(0, navroot);
                }
            }
            int levelStart = 1;
            int levelEnd = 3;
            int[] level = nav.getTargetLevelAttributeInt();
            if (level.length > 0 && level[0] != Integer.MIN_VALUE) {
                levelStart = level[0];
            }
            if (level.length > 1 && level[1] != Integer.MIN_VALUE) {
                levelEnd = level[1];
            }
            if (levelStart < 1) {
                levelStart = 1;
            }
            if (levelEnd <= levelStart) {
                levelEnd = levelStart;
            }
            CollectorData data = new CollectorData();
            data.self = self;
            data.lvStart = levelStart - 1;
            data.lvEnd = levelEnd - 1;
            data.toAddResult = setToAddResult;
            data.onlyChildren = !(self instanceof GSUnmappedPage) ? false : nav.getOnlyChildrenAttribute();
            data.trail = trail;
            if (nav.getOnlyChildrenAttribute()) {
                LevelCollector.itemCollectorOnlyChilld(navroot, 0, data);
            } else {
                LevelCollector.itemCollector(navroot, 0, data);
            }
        }

        private static void itemCollector(GSPage cur, int lvCur, CollectorData data) {
            GSPage[] child;
            if (data.lvStart <= lvCur && lvCur <= data.lvEnd) {
                data.toAddResult.add(cur);
            }
            if (lvCur < data.lvEnd && cur != null && (child = cur.getChildren()) != null) {
                int i = 0;
                while (i < child.length) {
                    LevelCollector.itemCollector(child[i], lvCur + 1, data);
                    ++i;
                }
            }
        }

        private static void itemCollectorOnlyChilld(GSPage navroot, int lvCur, CollectorData data) {
            GSPage cur = (GSPage)data.trail.get(lvCur);
            if (cur instanceof GSUnmappedPage) {
                LevelCollector.itemCollector(navroot, lvCur, data);
                return;
            }
            if (data.lvStart <= lvCur && lvCur <= data.lvEnd && lvCur < data.trail.size()) {
                if (lvCur == 0) {
                    data.toAddResult.add(cur);
                } else {
                    GSPage parent = (GSPage)data.trail.get(lvCur - 1);
                    GSPage[] child = parent.getChildren();
                    int i = 0;
                    while (i < child.length) {
                        data.toAddResult.add(child[i]);
                        ++i;
                    }
                }
            }
            if (lvCur < data.lvEnd) {
                if (lvCur + 1 >= data.trail.size()) {
                    LevelCollector.itemCollector(cur, lvCur, data);
                } else {
                    LevelCollector.itemCollectorOnlyChilld(navroot, lvCur + 1, data);
                }
            }
        }

        private static class CollectorData {
            public GSPage self;
            public int lvStart;
            public int lvEnd;
            public Set toAddResult;
            public boolean onlyChildren;
            public List trail;

            private CollectorData() {
            }
        }
    }

    protected static class ParentCollector
    implements ItemCollector {
        protected ParentCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("parent");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPage(self.getParent(), setToAddResult);
        }
    }

    protected static class SelfCollector
    implements ItemCollector {
        protected SelfCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("self");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            if (self instanceof GSUnmappedPage) {
                return;
            }
            Util.addPage(self, setToAddResult);
        }
    }

    protected static class SiblingCollector
    implements ItemCollector {
        protected SiblingCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("sibling");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPages(self.getSibling(), setToAddResult);
        }
    }

    protected static class TopChildrenCollector
    implements ItemCollector {
        protected TopChildrenCollector() {
        }

        @Override
        public boolean canHandle(NavModel nav) {
            return nav.getTargetAttribute("topchildren");
        }

        @Override
        public void collect(GSStructure model, GSPage self, NavModel nav, Set setToAddResult) {
            Util.addPages(self.getTopChildren(), setToAddResult);
        }
    }

    protected static final class Util {
        protected Util() {
        }

        protected static void addPages(GSPage[] pages, Set set) {
            if (pages == null) {
                return;
            }
            int pageSize = pages.length;
            int i = 0;
            while (i < pageSize) {
                set.add(pages[i]);
                ++i;
            }
        }

        protected static void addPage(GSPage page, Set set) {
            if (page == null) {
                return;
            }
            set.add(page);
        }

        protected static int getIndex(GSPage self) {
            GSPage p = self.getParent();
            if (p == null) {
                return -1;
            }
            GSPage[] c = p.getChildren();
            int i = 0;
            while (i < c.length) {
                if (c[i] == self) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected static GSPage getAt(GSPage p, int index) {
            if (p == null) {
                return null;
            }
            if (index >= 0 && index < p.getChildren().length) {
                return p.getChildren()[index];
            }
            return null;
        }

        protected static GSPage getPrevPage(GSPage p) {
            int index = Util.getIndex(p);
            int i = index - 1;
            while (i >= 0) {
                GSPage current = Util.getAt(p.getParent(), i);
                if (!(current instanceof GSGroup)) {
                    return current;
                }
                --i;
            }
            return null;
        }

        protected static GSPage getNextPage(GSPage p) {
            GSPage current;
            int index = Util.getIndex(p);
            if (index < 0) {
                return null;
            }
            int i = index + 1;
            while ((current = Util.getAt(p.getParent(), i)) != null) {
                if (GSStructure.ST.hasDepth(current.getSiteComponent())) {
                    return current;
                }
                ++i;
            }
            return null;
        }
    }
}

