/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.site;

import com.ibm.etools.siteedit.internal.builder.site.GSGroup;
import com.ibm.etools.siteedit.internal.builder.site.GSItem;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.GSUnmappedPage;
import com.ibm.etools.siteedit.internal.builder.site.SiteModelProvider;
import com.ibm.etools.siteedit.internal.builder.util.VirtualComponentMap;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteSubProjectUtil2;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentIterator;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelUtil2;
import com.ibm.etools.siteedit.site.model.UnmappedPageModel;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class GSStructure {
    private final VirtualComponentMap component2siteModel = new VirtualComponentMap(2);
    private final Map component2gsitem = new HashMap();
    private final GSPage[] top;
    private final HashMap groups;

    public GSStructure(IVirtualComponent component, SiteModelProvider smp) {
        ArrayList<IVirtualComponent> ar = new ArrayList<IVirtualComponent>();
        ar.add(component);
        ArrayList<GSPage> tops = new ArrayList<GSPage>();
        HashMap<String, GSPage> groups = new HashMap<String, GSPage>();
        int i = 0;
        while (i < ar.size()) {
            IVirtualComponent comp = (IVirtualComponent)ar.get(i);
            SiteModel siteModel = smp.getSiteModel(comp);
            if (siteModel != null) {
                this.component2siteModel.put(comp, siteModel);
                this.component2gsitem.put(siteModel, new RootItem(comp));
                WebprojectModel[] wm = ST.findAllProject(siteModel);
                int j = 0;
                while (j < wm.length) {
                    IVirtualComponent c = SiteSubProjectUtil2.findComponent(wm[j]);
                    if (c != null && !ar.contains(c)) {
                        ar.add(c);
                    }
                    ++j;
                }
                SiteComponent[] toppages = ST.getTopWithGroup(siteModel);
                int j2 = 0;
                while (j2 < toppages.length) {
                    SiteComponent sc = toppages[j2];
                    if (this.isNavItemCandidate(sc)) {
                        GSPage pg = this.getPage(sc);
                        tops.add(pg);
                    }
                    ++j2;
                }
                String componentName = WebComponentUtil.encodeComponentToText(comp);
                GroupModel[] groupModels = ST.findGroups(siteModel);
                int j3 = 0;
                while (j3 < groupModels.length) {
                    GroupModel group = groupModels[j3];
                    groups.put(String.valueOf(componentName) + "/" + group.getGourpId(), this.getPage(group));
                    ++j3;
                }
            }
            ++i;
        }
        this.top = tops.toArray(new GSPage[tops.size()]);
        this.groups = groups;
    }

    private boolean isNavItemCandidate(SiteComponent c) {
        if (c == null) {
            return false;
        }
        SiteComponentType t = c.getType();
        return t == SiteComponentType.PAGE || t == SiteComponentType.SHAREDPAGE || t == SiteComponentType.GROUP || t == SiteComponentType.LINK;
    }

    protected final SiteModel getSiteModelFromComponent(IVirtualComponent component) {
        SiteModel result = (SiteModel)this.component2siteModel.get(component);
        if (result == null) {
            result = new SiteModel();
            this.component2siteModel.put(component, result);
        }
        return result;
    }

    private boolean containsComponent(IVirtualComponent component) {
        return this.component2siteModel.containsKey(component);
    }

    public GSGroup getGroup(String key, IVirtualComponent component) {
        return (GSGroup)this.groups.get(GSStructure.getFullQualifiedGroupName(key, component));
    }

    static String getFullQualifiedGroupName(String key, IVirtualComponent component) {
        String groupId = key;
        int sep = key.indexOf(47);
        if (sep < 0) {
            groupId = String.valueOf(WebComponentUtil.encodeComponentToText(component)) + "/" + key;
        }
        return groupId;
    }

    Map getGroupMap() {
        return Collections.unmodifiableMap(this.groups);
    }

    public GSPage[] getTop() {
        return this.top;
    }

    public GSPage getPage(IFile file) {
        IVirtualComponent component = WebComponentUtil.findComponent((IResource)file);
        if (!this.containsComponent(component)) {
            return null;
        }
        String name = SiteResourceUtil.getProjectRelativePathString(component, (IResource)file);
        return this.getPage(component, name);
    }

    private GSPage getPage(IVirtualComponent component, String src) {
        if (!this.containsComponent(component)) {
            return null;
        }
        GSPage result = null;
        int minDepth = Integer.MAX_VALUE;
        PageModel[] comps = ST.findPages(this.getSiteModelFromComponent(component), src);
        int i = 0;
        while (i < comps.length) {
            int depth;
            GSPage page = this.getPage(comps[i]);
            if (page != null && (depth = this.getDepth(page)) < minDepth) {
                minDepth = depth;
                result = page;
            }
            ++i;
        }
        if (result == null) {
            result = this.getUnmappedPage(component, src);
        }
        return result;
    }

    private GSPage getUnmappedPage(IVirtualComponent component, String src) {
        UnmappedPageModel unmappedPageModel = this.getSiteModelFromComponent(component).createUnmappedPageModel();
        unmappedPageModel.setSRC(src);
        return new GSUnmappedPage(unmappedPageModel, component, this);
    }

    public int getDepth(GSPage p) {
        int result = 0;
        GSPage pp;
        while ((pp = p.getParent()) != null) {
            p = pp;
            ++result;
        }
        return result;
    }

    private GSPage getPage(SiteComponent comp) {
        if (comp == null) {
            return null;
        }
        if (!this.isNavItemCandidate(comp)) {
            return null;
        }
        GSPage p = (GSPage)this.component2gsitem.get(comp);
        if (p != null) {
            return p;
        }
        p = comp.getType() == SiteComponentType.GROUP ? new GSGroup((GroupModel)comp, this.getComponentFromSiteComponent(comp), this) : new GSPage(comp, this.getComponentFromSiteComponent(comp), this);
        this.component2gsitem.put(comp, p);
        return p;
    }

    private IVirtualComponent getComponentFromSiteComponent(SiteComponent c) {
        while (c != null) {
            GSItem i = (GSItem)this.component2gsitem.get(c);
            if (i != null) {
                return i.getComponent();
            }
            c = c.getParent();
        }
        return null;
    }

    public GSPage getParentThroughProject(GSPage p) {
        return this.getParentThroughProjectCore(p.getSiteComponent(), p.getComponent());
    }

    private GSPage getParentThroughProjectCore(SiteComponent siteComponent, IVirtualComponent component) {
        SiteComponent sc = ST.getParentItem(siteComponent);
        if (sc == null) {
            return null;
        }
        if (sc.getType() == SiteComponentType.WEBPROJECT) {
            WebprojectModel leaf;
            WebprojectModel wm = (WebprojectModel)sc;
            IVirtualComponent comp = SiteSubProjectUtil2.findComponent(wm);
            if (comp != null && comp.exists() && (leaf = ST.findLeafProject(this.getSiteModelFromComponent(comp), WebComponentUtil.encodeComponentToText(component))) != null) {
                return this.getParentThroughProjectCore(leaf, comp);
            }
            return null;
        }
        if (this.isNavItemCandidate(sc)) {
            GSPage gp = this.getPage(sc);
            return gp;
        }
        throw new RuntimeException();
    }

    GSPage[] getChildThroughProject(GSPage p) {
        ArrayList result = new ArrayList();
        this.getChildThroughProjectCore(p.getSiteComponent(), p.getComponent(), result);
        return result.toArray(new GSPage[result.size()]);
    }

    private void getChildThroughProjectCore(SiteComponent siteComponent, IVirtualComponent component, List result) {
        SiteComponent[] child = ST.getChildItem(siteComponent);
        int i = 0;
        while (i < child.length) {
            if (child[i].getType() == SiteComponentType.WEBPROJECT) {
                WebprojectModel root;
                WebprojectModel wm = (WebprojectModel)child[i];
                IVirtualComponent comp = SiteSubProjectUtil2.findComponent(wm);
                if (comp != null && comp.exists() && (root = ST.getProjectSrc(this.getSiteModelFromComponent(comp), WebComponentUtil.encodeComponentToText(component))) != null) {
                    this.getChildThroughProjectCore(root, comp, result);
                }
            } else if (this.isNavItemCandidate(child[i])) {
                GSPage page = this.getPage(child[i]);
                result.add(page);
            } else {
                throw new RuntimeException();
            }
            ++i;
        }
    }

    static class RootItem
    implements GSItem {
        private IVirtualComponent component;

        public RootItem(IVirtualComponent component) {
            this.component = component;
        }

        @Override
        public IVirtualComponent getComponent() {
            return this.component;
        }

        @Override
        public SiteComponent getSiteComponent() {
            return null;
        }

        public SiteComponent[] getAllSiteComponent() {
            return null;
        }
    }

    static final class ST {
        ST() {
        }

        public static SiteComponent getParentItem(SiteComponent c) {
            while (c != null) {
                SiteComponent r = c.getParent();
                if (r == null) {
                    return null;
                }
                if (ST.hasDepth(r)) {
                    return r;
                }
                c = r;
            }
            return null;
        }

        public static SiteComponent[] getChildItem(SiteComponent c) {
            ArrayList result = new ArrayList(c.numberOfChildren());
            ST.getChildItemCore(c, result);
            return result.toArray(new SiteComponent[result.size()]);
        }

        private static void getChildItemCore(SiteComponent c, List result) {
            SiteComponentIterator it = (SiteComponentIterator)c.iterator();
            while (it.hasNext()) {
                SiteComponent comp = (SiteComponent)it.next();
                if (ST.hasDepth(comp)) {
                    result.add(comp);
                    continue;
                }
                if (comp.getType() == SiteComponentType.GROUP) {
                    result.add(comp);
                }
                ST.getChildItemCore(comp, result);
            }
        }

        public static boolean hasDepth(SiteComponent c) {
            SiteComponentType t = c.getType();
            return t == SiteComponentType.PAGE || t == SiteComponentType.LINK || t == SiteComponentType.SHAREDPAGE || t == SiteComponentType.WEBPROJECT;
        }

        public static boolean isNavItem(SiteComponent c) {
            if (c == null) {
                return false;
            }
            SiteComponentType t = c.getType();
            return t == SiteComponentType.PAGE || t == SiteComponentType.SHAREDPAGE || t == SiteComponentType.GROUP || t == SiteComponentType.LINK;
        }

        public static PageModel[] findPages(SiteModel c, String src) {
            ArrayList result = new ArrayList(1);
            ST.findPagesCore(c, src, result);
            return result.toArray(new PageModel[result.size()]);
        }

        private static void findPagesCore(SiteComponent c, String src, List result) {
            SiteComponentIterator it = (SiteComponentIterator)c.iterator();
            while (it.hasNext()) {
                PageModel pm;
                SiteComponent comp = (SiteComponent)it.next();
                if (comp.getType() == SiteComponentType.PAGE && src.equals((pm = (PageModel)comp).getSRC())) {
                    result.add(pm);
                }
                ST.findPagesCore(comp, src, result);
            }
        }

        public static SiteComponent[] getTop(SiteModel c) {
            ArrayList result = new ArrayList(c.numberOfChildren());
            ST.getTopCore(c, result, false);
            return result.toArray(new SiteComponent[result.size()]);
        }

        public static SiteComponent[] getTopWithGroup(SiteModel c) {
            ArrayList result = new ArrayList(c.numberOfChildren());
            ST.getTopCore(c, result, true);
            return result.toArray(new SiteComponent[result.size()]);
        }

        private static void getTopCore(SiteComponent c, Collection result, boolean withGroup) {
            SiteComponentIterator it = (SiteComponentIterator)c.iterator();
            while (it.hasNext()) {
                SiteComponent comp = (SiteComponent)it.next();
                if (ST.hasDepth(comp)) {
                    result.add(comp);
                    continue;
                }
                if (withGroup && comp.getType() == SiteComponentType.GROUP) {
                    result.add(comp);
                    continue;
                }
                ST.getTopCore(comp, result, withGroup);
            }
        }

        public static WebprojectModel getProjectSrc(SiteModel m, String pname) {
            SiteComponent[] itemsInSite = SiteModelUtil2.getAllItems(m);
            int itemSize = itemsInSite.length;
            int i = 0;
            while (i < itemSize) {
                WebprojectModel wm;
                if (itemsInSite[i].getType() == SiteComponentType.WEBPROJECT && pname.equals((wm = (WebprojectModel)itemsInSite[i]).getSRC())) {
                    return wm;
                }
                ++i;
            }
            return null;
        }

        public static WebprojectModel findLeafProject(SiteModel m, String pname) {
            SiteComponent[] top = ST.getTop(m);
            int i = 0;
            while (i < top.length) {
                WebprojectModel wm = ST.findLeafProjectCore(top[i], pname);
                if (wm != null) {
                    return wm;
                }
                ++i;
            }
            return null;
        }

        private static WebprojectModel findLeafProjectCore(SiteComponent c, String pname) {
            SiteComponentIterator it = (SiteComponentIterator)c.iterator();
            while (it.hasNext()) {
                SiteComponent comp = (SiteComponent)it.next();
                if (comp.getType() == SiteComponentType.WEBPROJECT && comp.numberOfChildren() == 0) {
                    WebprojectModel pm = (WebprojectModel)comp;
                    if (!pname.equals(pm.getSRC())) continue;
                    return pm;
                }
                WebprojectModel wm = ST.findLeafProjectCore(comp, pname);
                if (wm == null) continue;
                return wm;
            }
            return null;
        }

        public static WebprojectModel[] findAllProject(SiteModel m) {
            ArrayList result = new ArrayList();
            ST.findAllWebProjectCore(m, result);
            return result.toArray(new WebprojectModel[result.size()]);
        }

        private static void findAllWebProjectCore(SiteComponent c, Collection result) {
            SiteComponentIterator it = (SiteComponentIterator)c.iterator();
            while (it.hasNext()) {
                SiteComponent comp = (SiteComponent)it.next();
                if (comp.getType() == SiteComponentType.WEBPROJECT) {
                    result.add(comp);
                }
                ST.findAllWebProjectCore(comp, result);
            }
        }

        public static GroupModel[] findGroups(SiteModel m) {
            final ArrayList result = new ArrayList();
            m.accept(new SiteComponentVisitor(){

                @Override
                public boolean visit(SiteComponent c) {
                    if (c.getType() == SiteComponentType.GROUP) {
                        result.add(c);
                    }
                    return true;
                }
            });
            return result.toArray(new GroupModel[result.size()]);
        }
    }
}

