/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.tag;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.impl.ErrorTool;
import com.ibm.etools.siteedit.internal.builder.SiteNavConstants;
import com.ibm.etools.siteedit.internal.builder.common.StringUtil;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.navspec.Context;
import com.ibm.etools.siteedit.internal.builder.navspec.Tag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreEL;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreErrorTool;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.VariableResolverUtil;

public class CoreOutTag
implements Tag {
    private TagNode element;
    private CoreEL valueExp;
    private boolean escapeXml = true;

    public CoreOutTag(TagNode element) {
        this.element = element;
        if (!element.containsAttr("value")) {
            CoreErrorTool.reportNoAttr(element.getErrorReporter(), element.getTagName(), "value");
            this.valueExp = CoreEL.getNullEL();
        } else {
            String exp = element.getAttr("value");
            this.valueExp = new CoreEL(exp, element.getErrorReporterForAttr("value"));
        }
        if (SiteNavConstants.ATTR_VALUE_FALSE.equalsIgnoreCase(element.getAttr("escapeXml"))) {
            this.escapeXml = false;
        }
    }

    @Override
    public int doStartTag(Context context) {
        try {
            Object o = this.getValue().evaluate(VariableResolverUtil.getResolver(context.getPageAttr()));
            String s = CoreEL.toString(o);
            if (o != null) {
                if (this.escapeXml) {
                    s = StringUtil.escapeXml(s);
                }
                context.getPageWriter().print(s);
                return 1;
            }
        }
        catch (ELErrorException e) {
            ErrorTool.reportELRuntimeError(this.element.getErrorReporterForAttr("value"), e);
        }
        return 1;
    }

    @Override
    public int doEndTag(Context context) {
        return 2;
    }

    @Override
    public void doInitBody(Context context) {
    }

    @Override
    public int doAfterBody(Context context) {
        return 2;
    }

    private CoreEL getValue() {
        return this.valueExp;
    }
}

