/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.Expression;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecModel;
import com.ibm.etools.siteedit.internal.builder.navspec.PageAttr;
import com.ibm.etools.siteedit.internal.builder.navspec.Tag;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.ContextImpl;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageItem;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageWriterImpl;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.VariableResolverUtil;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PageInterpreter
implements NavspecModel {
    private final PageItem[] items;
    private final Map taglibPrefix2URI;
    private LinkedList tagStack;

    public PageInterpreter(PageItem[] items, Map taglibMappings) {
        this.items = items;
        this.taglibPrefix2URI = taglibMappings;
    }

    @Override
    public String eval(PageAttr attr, NavspecModel.TaglibPrefixResolver prefixResolver) {
        Map prefixMap = this.makePrefixMap(this.taglibPrefix2URI, prefixResolver);
        this.tagStack = new LinkedList();
        PageWriterImpl writer = new PageWriterImpl();
        ContextImpl context = new ContextImpl();
        context.setPageAttr(attr);
        context.setPageWriter(writer);
        Tag skipTag = null;
        int i = 0;
        while (i < this.items.length) {
            PageItem item = this.items[i];
            switch (item.getType()) {
                case 4: {
                    if (skipTag != null) break;
                    context.getPageWriter().print(item.getText());
                    break;
                }
                case 6: {
                    String prefix;
                    if (skipTag != null) break;
                    String string = prefix = prefixMap == null ? null : (String)prefixMap.get(item.getText());
                    if (prefix != null) {
                        context.getPageWriter().print(prefix);
                        break;
                    }
                    context.getPageWriter().print(item.getText());
                    break;
                }
                case 1: {
                    Tag current = item.getTag();
                    this.pushTag(current);
                    if (skipTag != null) break;
                    context.setParent(this.getParentTag());
                    int result = current.doStartTag(context);
                    switch (result) {
                        case 2: {
                            break;
                        }
                        case 1: {
                            skipTag = current;
                            break;
                        }
                        case 0: {
                            current.doInitBody(context);
                        }
                    }
                    break;
                }
                case 2: {
                    Tag current = this.getCurrentTag();
                    if (skipTag == null || current == skipTag) {
                        int result = current.doAfterBody(context);
                        switch (result) {
                            case 1: 
                            case 2: {
                                current.doEndTag(context);
                                this.popTag();
                                context.setParent(this.getParentTag());
                                break;
                            }
                            case 0: {
                                i = item.getStartPosition();
                                current.doInitBody(context);
                            }
                        }
                        skipTag = null;
                        break;
                    }
                    this.popTag();
                    break;
                }
                case 3: {
                    if (skipTag != null) break;
                    Tag current = item.getTag();
                    this.pushTag(current);
                    context.setParent(this.getParentTag());
                    current.doStartTag(context);
                    current.doEndTag(context);
                    this.popTag();
                    context.setParent(this.getParentTag());
                    break;
                }
                case 5: {
                    if (skipTag != null) break;
                    try {
                        Object o = item.getEl().evaluate(VariableResolverUtil.getResolver(context.getPageAttr()));
                        String s = Expression.toString(o);
                        context.getPageWriter().print(s);
                    }
                    catch (ELErrorException eLErrorException) {}
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++i;
        }
        return writer.getContent();
    }

    private Map makePrefixMap(Map taglibPrefix2URI, NavspecModel.TaglibPrefixResolver prefixResolver) {
        if (taglibPrefix2URI == null || taglibPrefix2URI.isEmpty() || prefixResolver == null) {
            return null;
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry entry : taglibPrefix2URI.entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            String dstPrefix = prefixResolver.getPrefix(uri);
            if (dstPrefix == null || dstPrefix.equals(prefix)) continue;
            result.put(prefix, dstPrefix);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    private Tag getCurrentTag() {
        return (Tag)this.tagStack.getFirst();
    }

    private Tag getParentTag() {
        return this.tagStack.size() < 2 ? null : (Tag)this.tagStack.get(1);
    }

    private void pushTag(Tag tag) {
        this.tagStack.addFirst(tag);
    }

    private void popTag() {
        this.tagStack.removeFirst();
    }

    @Override
    public Set getTaglibURIs() {
        throw new RuntimeException("not implemented yet");
    }
}

