/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.common.StringUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTaglibDirectiveReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class NavspecConverter {
    public static void convert(IStructuredDocument document) {
        String targetPrefix = NavspecConverter.getPrefixForJSTL(document);
        if (targetPrefix == null) {
            return;
        }
        StringWriter writer = new StringWriter();
        IStructuredDocumentRegion node = document.getFirstStructuredDocumentRegion();
        while (node != null) {
            IStructuredDocumentRegion nextNode = node.getNext();
            String text = node.getFullText();
            String type = node.getType();
            if (type == "XML_TAG_NAME") {
                String tagName = NavspecConverter.getTagName(node);
                String tagPrefix = NavspecConverter.getPrefix(tagName);
                String localName = NavspecConverter.getLocalName(tagName);
                StringValidater sv = new StringValidater(text);
                while (!sv.isCompleted()) {
                    if (nextNode == null) break;
                    sv.append(nextNode.getFullText());
                    nextNode = nextNode.getNext();
                }
                text = sv.getText();
                if (tagPrefix != null) {
                    if (tagPrefix.equals("jsp")) {
                        text = null;
                    } else if (tagPrefix.equals(targetPrefix)) {
                        if (localName.equals("out")) {
                            String value = NavspecConverter.getAttribute(node, "value");
                            boolean escapeXml = Boolean.valueOf(NavspecConverter.getAttribute(node, "escapeXml"));
                            if (escapeXml) {
                                value = StringUtil.escapeXml(value);
                            }
                            text = value;
                        } else {
                            StringBuffer sb = new StringBuffer(text);
                            sb.insert(1, "!-- ");
                            sb.insert(sb.length() - 1, " --");
                            text = sb.toString().replaceFirst(targetPrefix, "siteedit");
                        }
                    }
                }
            } else if (type == "JSP_DIRECTIVE_NAME") {
                text = null;
            }
            if (text != null) {
                writer.write(text);
            }
            node = nextNode;
        }
        try {
            writer.close();
            document.set(writer.toString());
        }
        catch (IOException e) {
            Logger.log(e);
        }
    }

    private static String getPrefixForJSTL(IStructuredDocument document) {
        Map map = SiteTaglibDirectiveReader.createURIToPrefixMap(document);
        String prefix = null;
        if (map != null) {
            String[] uriList = new String[]{"http://java.sun.com/jstl/core", "http://java.sun.com/jsp/jstl/core"};
            int i = 0;
            while (i < uriList.length) {
                Object o = map.get(uriList[i]);
                if (o != null && o instanceof String) {
                    prefix = (String)o;
                    break;
                }
                ++i;
            }
        }
        return prefix;
    }

    private static String getTagName(IStructuredDocumentRegion node) {
        ITextRegionList regions = node.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            String type = r.getType();
            if (type == "XML_TAG_NAME") {
                return node.getText().substring(r.getStart(), r.getTextEnd());
            }
            ++i;
        }
        return null;
    }

    private static String getPrefix(String tagName) {
        int pos = tagName.indexOf(58);
        return pos >= 0 ? tagName.substring(0, pos) : null;
    }

    private static String getLocalName(String tagName) {
        int pos = tagName.indexOf(58);
        return pos >= 0 ? tagName.substring(pos + 1) : tagName;
    }

    private static String getAttribute(IStructuredDocumentRegion node, String attrName) {
        StringValidater sv = new StringValidater();
        String name = null;
        boolean valueProcessing = false;
        do {
            ITextRegionList regions = node.getRegions();
            int i = 0;
            while (i < regions.size()) {
                ITextRegion r = regions.get(i);
                if (valueProcessing) {
                    sv.append(node.getText().substring(r.getStart(), r.getEnd()));
                    String value = sv.getNextCompleted();
                    boolean bl = valueProcessing = value == null;
                    if (!valueProcessing && attrName.equals(name)) {
                        return value;
                    }
                } else if (r.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                    name = node.getText().substring(r.getStart(), r.getEnd());
                } else if (r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && i > 0 && regions.get(i - 1).getType() == "XML_TAG_ATTRIBUTE_NAME") {
                    valueProcessing = true;
                    sv.reset();
                }
                ++i;
            }
            if (!sv.isCompleted()) continue;
            return "";
        } while ((node = node.getNext()) != null);
        return "";
    }

    private static class StringValidater {
        static final char SINGLE = '\'';
        static final char DOUBLE = '\"';
        static final char ESCAPE = '\\';
        StringBuffer text;
        StringBuffer completed;
        int pos = 0;
        boolean escaped = false;
        boolean quoted = false;
        char quote = '\u0000';

        StringValidater() {
            this.text = new StringBuffer();
        }

        StringValidater(String s) {
            this.text = new StringBuffer(s);
        }

        StringValidater(StringBuffer sb) {
            this.text = sb;
        }

        void reset() {
            this.text.setLength(0);
            this.pos = 0;
        }

        void append(String s) {
            this.text.append(s);
        }

        void append(StringBuffer sb) {
            this.text.append(sb);
        }

        String getText() {
            return this.text.toString();
        }

        boolean isCompleted() {
            while (this.pos < this.text.length()) {
                this.pos = this.next();
            }
            return !this.quoted;
        }

        String getNextCompleted() {
            this.next();
            return !this.quoted ? this.completed.toString() : null;
        }

        private int next() {
            while (this.pos < this.text.length()) {
                char c = this.text.charAt(this.pos);
                if (this.escaped) {
                    this.escaped = false;
                } else if (this.quoted) {
                    if (c == '\\') {
                        this.escaped = true;
                        c = '\u0000';
                    } else if (c == this.quote) {
                        this.quoted = false;
                        return this.pos + 1;
                    }
                } else if (c == '\'' || c == '\"') {
                    this.quoted = true;
                    this.quote = c;
                    if (this.completed == null) {
                        this.completed = new StringBuffer();
                    } else {
                        this.completed.setLength(0);
                    }
                    c = '\u0000';
                }
                if (c != '\u0000' && this.completed != null) {
                    this.completed.append(c);
                }
                ++this.pos;
            }
            return this.pos;
        }
    }
}

