/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavConstants;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeFactory;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.SiteNavReadOnlyException;
import com.ibm.etools.siteedit.internal.builder.model.SitePageCachedModelEntry;
import com.ibm.etools.siteedit.internal.builder.model.SitePageContext;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelFactory;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelTaglibSupport;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTemplateUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class SitePageFlatModel
extends SitePageModelTaglibSupport {
    private final SitePageModelFactory modelFactory;
    private IStructuredDocument flatModel;
    private boolean modelIsDirty;
    private boolean isJSP;
    private final IFile file;
    protected boolean hasNavbar;
    protected ArrayList tagReplacer;
    protected ArrayList customTagReplacer;
    protected String baseHref;
    protected String declaration;
    protected String publicId;
    protected SiteTemplateUtil.TemplateData pageTemplate;

    public SitePageFlatModel(IFile file) throws SiteNavException {
        this(file, (SitePageModelFactory)null);
    }

    public SitePageFlatModel(IFile file, SitePageModelFactory factory) throws SiteNavException {
        this.modelFactory = factory;
        this.file = file;
        this.isJSP = file.getFileExtension() == null ? false : file.getFileExtension().startsWith("j");
        try {
            IModelManager mm = SiteModelUtil.getModelManager();
            this.flatModel = mm.createStructuredDocumentFor(file);
        }
        catch (Exception e) {
            String message = SiteNavMessages.format1(SiteNavMessages.ERROR_CANNOT_OPEN_FILE1, file.getFullPath().toString());
            SiteNavBuilderLogger.log(message);
            SiteNavBuilderLogger.log(e);
            throw new SiteNavException(message);
        }
        this.load();
    }

    public SitePageFlatModel(IFile file, IStructuredDocument liveDocument) throws SiteNavException {
        this.modelFactory = null;
        this.file = file;
        this.isJSP = file.getFileExtension() == null ? false : file.getFileExtension().startsWith("j");
        this.flatModel = liveDocument;
        this.load();
    }

    private void load() {
        TagNodeFactory factory = TagNodeFactory.getDefFactory(this.file);
        NavElement.Factory navElementFactory = NavElement.getFactory(this.file);
        if (this.tagReplacer != null) {
            throw new IllegalStateException();
        }
        if (this.customTagReplacer != null) {
            throw new IllegalStateException();
        }
        this.tagReplacer = new ArrayList();
        this.customTagReplacer = new ArrayList();
        NavTagReplacer cur = null;
        NavTagReplacer curCustomReplacer = null;
        IStructuredDocumentRegion nodeStart = this.flatModel.getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion nodeLast = this.flatModel.getLastStructuredDocumentRegion();
        IStructuredDocumentRegion node = nodeStart;
        while (node != null) {
            if (!(this.declaration == null && this.loadDeclaration(node) || this.publicId == null && this.loadPublicId(node))) {
                NavElement customElm;
                TagNode baseTag;
                if (this.baseHref == null && (baseTag = TagParser.parseNormal(node, "BASE", true, factory)) != null) {
                    String a = baseTag.getAttr("href");
                    String b = baseTag.getAttr("target");
                    if (a.length() > 0) {
                        this.baseHref = a;
                    } else if (b.length() > 0) {
                        this.baseHref = b;
                    }
                } else if (this.isJSP && this.getJspnavPrefix() != null && (customElm = navElementFactory.createJspnave(node, this.getJspnavPrefix())) != null) {
                    if (customElm.isEmpty() || customElm.isStart()) {
                        if (curCustomReplacer != null) {
                            curCustomReplacer.setEndNode(node, customElm);
                            curCustomReplacer = null;
                        }
                        curCustomReplacer = new NavTagReplacer(node, customElm);
                        this.customTagReplacer.add(curCustomReplacer);
                        this.hasNavbar = true;
                    }
                    if ((customElm.isEmpty() || customElm.isEnd()) && curCustomReplacer != null) {
                        curCustomReplacer.setEndNode(node, customElm);
                        curCustomReplacer = null;
                    }
                } else {
                    NavElement elm;
                    String nodeType = node.getFirstRegion().getType();
                    if (nodeType == "XML_COMMENT_OPEN" && (elm = navElementFactory.create(node)) != null && SiteNavConstants.Util.isNavigationTagName(elm.getTagName())) {
                        if (elm.isEmpty() || elm.isStart()) {
                            if (cur != null) {
                                cur.setEndNode(node, elm);
                                cur = null;
                            }
                            cur = new NavTagReplacer(node, elm);
                            this.tagReplacer.add(cur);
                            this.hasNavbar = true;
                        }
                        if ((elm.isEmpty() || elm.isEnd()) && cur != null) {
                            cur.setEndNode(node, elm);
                            cur = null;
                        }
                    }
                }
            }
            IStructuredDocumentRegion iStructuredDocumentRegion = node = node == nodeLast ? null : node.getNext();
        }
    }

    private boolean loadDeclaration(IStructuredDocumentRegion node) {
        if (node.getType() == "XML_PI_OPEN") {
            int pStart = -1;
            int pEnd = -1;
            ITextRegionList regions = node.getRegions();
            for (ITextRegion r : regions) {
                String type = r.getType();
                if (type == "XML_TAG_NAME") {
                    if (!node.getText(r).equalsIgnoreCase("xml")) break;
                    pStart = node.getEndOffset(r);
                    continue;
                }
                if (type != "XML_PI_CLOSE") continue;
                pEnd = node.getStartOffset(r);
            }
            String pi = node.getText();
            if (pStart < 0 || pi.length() <= pEnd || pEnd <= pStart) {
                return false;
            }
            this.declaration = pi.substring(pStart, pEnd).trim();
            return true;
        }
        return false;
    }

    private boolean loadPublicId(IStructuredDocumentRegion node) {
        if (node.getType() == "XML_DOCTYPE_DECLARATION") {
            ITextRegionList regions = node.getRegions();
            for (ITextRegion r : regions) {
                String type = r.getType();
                if (type != "XML_DOCTYPE_EXTERNAL_ID_PUBREF") continue;
                this.publicId = node.getText(r);
                this.publicId = StringUtils.stripQuotes((String)this.publicId);
                return true;
            }
        }
        return false;
    }

    @Override
    public SitePageContext.Writer getWriter() {
        return new MyWriter(this.flatModel.getLineDelimiter());
    }

    @Override
    public int getCustomTagLength() {
        if (this.tagReplacer != null) {
            return this.customTagReplacer.size();
        }
        return 0;
    }

    @Override
    public int getCommentTagLength() {
        if (this.customTagReplacer != null) {
            return this.tagReplacer.size();
        }
        return 0;
    }

    @Override
    public NavElement commentTagItem(int i) throws IndexOutOfBoundsException {
        return this.getItem(this.tagReplacer, i);
    }

    @Override
    public NavElement customTagItem(int i) throws IndexOutOfBoundsException {
        return this.getItem(this.customTagReplacer, i);
    }

    private NavElement getItem(ArrayList list, int index) {
        NavTagReplacer replacer = (NavTagReplacer)list.get(index);
        NavElement ne = replacer.getNavTag();
        return ne;
    }

    @Override
    public boolean write() throws SiteNavException {
        IModelManager mm;
        block7: {
            mm = SiteModelUtil.getModelManager();
            SitePageFlatModel.execUpdate(this);
            if (this.modelIsDirty) break block7;
            return false;
        }
        try {
            if (this.file.isReadOnly()) {
                throw new SiteNavReadOnlyException();
            }
            mm.saveStructuredDocument(this.flatModel, this.file);
        }
        catch (SiteNavException e) {
            throw e;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception e) {
            if (this.file.isReadOnly()) {
                throw new SiteNavReadOnlyException();
            }
            SiteNavBuilderLogger.log(SiteNavMessages.format1(SiteNavMessages.ERROR_CONTENT_NOT_SET1, this.file.getFullPath().toString()));
            SiteNavBuilderLogger.log(e);
            SitePageModelUtil.recoverErrorInSavingModel(this.file, this.flatModel);
        }
        this.modelIsDirty = false;
        return true;
    }

    @Override
    public void dispose() {
        if (this.modelFactory == null) {
            return;
        }
        if (this.flatModel == null) {
            return;
        }
        if (this.modelIsDirty) {
            return;
        }
        SitePageCachedModelEntry.NavTagItem[] navTagItems = null;
        if (this.tagReplacer != null) {
            ArrayList<SitePageCachedModelEntry.NavTagItem> ar = new ArrayList<SitePageCachedModelEntry.NavTagItem>(this.tagReplacer.size());
            int i = 0;
            while (i < this.tagReplacer.size()) {
                NavTagReplacer repl = (NavTagReplacer)this.tagReplacer.get(i);
                ar.add(repl.getCacheItem());
                ++i;
            }
            navTagItems = ar.toArray(new SitePageCachedModelEntry.NavTagItem[ar.size()]);
        }
        SitePageCachedModelEntry.CustomNavTagItem[] customItems = null;
        if (this.customTagReplacer != null) {
            ArrayList<SitePageCachedModelEntry.CustomNavTagItem> arc = new ArrayList<SitePageCachedModelEntry.CustomNavTagItem>(this.customTagReplacer.size());
            int i = 0;
            while (i < this.customTagReplacer.size()) {
                NavTagReplacer repl = (NavTagReplacer)this.customTagReplacer.get(i);
                arc.add(repl.getCustomCacheItem());
                ++i;
            }
            customItems = arc.toArray(new SitePageCachedModelEntry.CustomNavTagItem[arc.size()]);
        }
        String charset = null;
        boolean useBOM = false;
        try {
            charset = this.file.getCharset();
            if (this.file.getContentDescription() != null) {
                useBOM = this.file.getContentDescription().getProperty(IContentDescription.BYTE_ORDER_MARK) == IContentDescription.BOM_UTF_8;
            }
        }
        catch (CoreException coreException) {}
        SitePageCachedModelEntry entry = new SitePageCachedModelEntry(this.file, new SitePageCachedModelEntry.TinyEncodingMemento(charset, useBOM), navTagItems, this.baseHref, this.declaration, this.publicId, this.flatModel.getLineDelimiter(), this.hasNavbar, this.getPageTemplate(), this.isTemplate(), customItems);
        this.modelFactory.setCache(entry);
    }

    private static void execUpdate(SitePageFlatModel model) {
        SitePageFlatModel mySiteModel = model;
        mySiteModel.update();
    }

    protected synchronized void update() {
        boolean modelIsDirty = false;
        int i = 0;
        while (i < this.getCommentTagLength()) {
            boolean fReplaced = ((NavTagReplacer)this.tagReplacer.get(i)).replace();
            if (fReplaced) {
                modelIsDirty = true;
            }
            ++i;
        }
        int j = 0;
        while (j < this.getCustomTagLength()) {
            boolean cReplaced = ((NavTagReplacer)this.customTagReplacer.get(j)).replace();
            if (cReplaced) {
                modelIsDirty = true;
            }
            ++j;
        }
        this.modelIsDirty = modelIsDirty;
    }

    @Override
    public String getBaseHref() {
        return this.baseHref;
    }

    @Override
    public String getDeclaration() {
        return this.declaration;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public boolean hasNavbar() {
        return this.hasNavbar;
    }

    @Override
    public String getPageTemplate() {
        if (this.pageTemplate == null) {
            this.pageTemplate = SiteTemplateUtil.getRawTemplate(this.flatModel, this.file.getLocation());
        }
        return this.pageTemplate.getTemplateString();
    }

    @Override
    public boolean isTemplate() {
        this.getPageTemplate();
        return this.pageTemplate.isTemplate();
    }

    @Override
    protected IStructuredDocument getFlatModelForTaglib() {
        return this.flatModel;
    }

    class MyWriter
    implements SitePageContext.Writer {
        private final String eol;
        private StringBuffer current;

        public MyWriter(String lineDelimiter) {
            this.eol = lineDelimiter;
        }

        @Override
        public void out(String string) {
            if (this.current == null) {
                this.current = new StringBuffer();
            }
            if (string != null) {
                this.current.append(string);
            }
        }

        @Override
        public void commit(int index) {
            String toSet = this.current == null ? "" : this.current.toString();
            String toSetAdjusted = StringUtils.convertLineDelimiters((String)toSet, (String)this.eol);
            ((NavTagReplacer)SitePageFlatModel.this.tagReplacer.get(index)).setReplaceText(toSetAdjusted);
            this.current = null;
        }

        @Override
        public void refresh() {
            this.current = null;
        }

        @Override
        public boolean isDirty() {
            return this.current != null;
        }
    }

    static class NavTagReplacer {
        private IStructuredDocumentRegion nodeStart;
        private IStructuredDocumentRegion nodeEnd;
        private boolean hasEndTag;
        private NavElement element;
        public String toReplace;

        public NavTagReplacer(IStructuredDocumentRegion start, NavElement navNode) {
            this(start, navNode, navNode.hasEnd());
        }

        public NavTagReplacer(IStructuredDocumentRegion start, NavElement navNode, boolean hasEndNode) {
            this.nodeStart = start;
            this.element = navNode;
            if (hasEndNode) {
                this.nodeEnd = start;
                this.hasEndTag = true;
            }
        }

        public void setEndNode(IStructuredDocumentRegion node, NavElement navNode) {
            this.nodeEnd = node;
            if (navNode.hasEnd()) {
                this.hasEndTag = true;
            }
        }

        public NavElement getNavTag() {
            return this.element;
        }

        public void setReplaceText(String s) {
            this.toReplace = s;
        }

        public boolean replace() {
            int pEnd;
            IStructuredDocument flatModel = this.nodeStart.getParentDocument();
            int pStart = this.nodeStart.getStart();
            int lineNum = flatModel.getLineOfOffset(pStart) + 1;
            this.element.updateErrorReporter(pStart, lineNum);
            if (this.toReplace == null || !this.hasEndTag) {
                return false;
            }
            pStart = this.nodeStart.getEnd();
            if (pStart <= (pEnd = this.nodeEnd.getStart())) {
                try {
                    String oldContent = flatModel.get(pStart, pEnd - pStart);
                    if (oldContent != null && oldContent.equals(this.toReplace)) {
                        return false;
                    }
                }
                catch (BadLocationException badLocationException) {}
                flatModel.replaceText((Object)this, pStart, pEnd - pStart, this.toReplace);
            }
            return true;
        }

        SitePageCachedModelEntry.NavTagItem getCacheItem() {
            SitePageCachedModelEntry.NavTagItem item = new SitePageCachedModelEntry.NavTagItem(this.nodeStart.getStart(), this.nodeStart.getEnd(), this.nodeEnd.getStart(), this.nodeEnd.getEnd(), this.nodeStart.getParentDocument().getLineOfOffset(this.nodeStart.getStart()) + 1, this.nodeStart.getFullText());
            return item;
        }

        SitePageCachedModelEntry.CustomNavTagItem getCustomCacheItem() {
            return new SitePageCachedModelEntry.CustomNavTagItem(this.nodeStart.getStart(), this.nodeStart.getEnd(), this.nodeStart.getParentDocument().getLineOfOffset(this.nodeStart.getStart()) + 1, this.nodeStart.getFullText());
        }
    }
}

