/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;

final class SitePageCachedModelEntry
implements Serializable {
    private static final long serialVersionUID = -8615879906853528263L;
    private final IFileHolder fileHolder;
    final long modificationStamp;
    final TinyEncodingMemento encoding;
    final NavTagItem[] navTags;
    final CustomNavTagItem[] customNavTags;
    final String baseHref;
    final String declaration;
    final String publicId;
    final String lineDelimiter;
    final boolean hasNav;
    final String pageTemplate;
    final boolean isTemplate;

    public IFile getFile() {
        return this.fileHolder.file;
    }

    SitePageCachedModelEntry(IFile file, TinyEncodingMemento encoding, NavTagItem[] navTags, String baseHref, String declareation, String publicId, String lineDelimiter, boolean hasNav, String pageTemplate, boolean isTemplate, CustomNavTagItem[] customNavTags) {
        this.fileHolder = new IFileHolder(file);
        this.modificationStamp = file.getModificationStamp();
        this.encoding = encoding;
        this.navTags = navTags;
        this.customNavTags = customNavTags;
        this.baseHref = StringCache.getObject(baseHref);
        this.declaration = StringCache.getObject(declareation);
        this.publicId = StringCache.getObject(publicId);
        this.lineDelimiter = StringCache.getObject(lineDelimiter);
        this.hasNav = hasNav;
        this.pageTemplate = StringCache.getObject(pageTemplate);
        this.isTemplate = isTemplate;
    }

    public boolean isValid() {
        return this.getFile().getModificationStamp() == this.modificationStamp;
    }

    public SitePageCachedModelEntry update(NavTagItem[] newNavTags, CustomNavTagItem[] newCNavTags) {
        return new SitePageCachedModelEntry(this.getFile(), this.encoding, newNavTags, this.baseHref, this.declaration, this.publicId, this.lineDelimiter, this.hasNav, this.pageTemplate, this.isTemplate, newCNavTags);
    }

    static final class CustomNavTagItem
    implements NavTag {
        private static final long serialVersionUID = 5453991026385458158L;
        final int startstart;
        final int startend;
        int lineNum;
        String innerText;

        public CustomNavTagItem(int startstart, int startend, int lineNum, String innerText) {
            this.startstart = startstart;
            this.startend = startend;
            this.lineNum = lineNum;
            this.innerText = innerText;
        }

        @Override
        public NavTag offsetBy(int offset, int addedLineNum) {
            int ss = this.startstart + offset;
            int se = this.startend + offset;
            return new CustomNavTagItem(ss, se, this.lineNum + addedLineNum, this.innerText);
        }

        @Override
        public NavTag offsetBy(int offsetOpen, int offsetClose, int addedLineNum) {
            int ss = this.startstart + offsetOpen;
            int se = this.startend + offsetClose;
            return new CustomNavTagItem(ss, se, this.lineNum + addedLineNum, this.innerText);
        }

        @Override
        public int getStartEndPosition() {
            return this.startstart;
        }

        @Override
        public int getEndStartPosition() {
            return this.startend;
        }

        @Override
        public int getLineNum() {
            return this.lineNum;
        }

        @Override
        public String getInnerText() {
            return this.innerText;
        }

        @Override
        public int getLength() {
            return this.startend - this.startstart;
        }

        @Override
        public int getStartStartPosition() {
            return this.startstart;
        }

        @Override
        public int getEndEndPosition() {
            return this.startend;
        }
    }

    private static final class IFileHolder
    implements Serializable {
        private static final long serialVersionUID = -3957459516794394558L;
        transient IFile file;

        public IFileHolder(IFile file) {
            this.file = file;
        }

        private void writeObject(ObjectOutputStream os) throws IOException {
            os.defaultWriteObject();
            os.writeObject(this.file.getProject().getName());
            os.writeObject(this.file.getProjectRelativePath().toString());
        }

        private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
            is.defaultReadObject();
            String proj = (String)is.readObject();
            String path = (String)is.readObject();
            this.file = SiteResourceUtil.getProject(proj).getFile(path);
        }
    }

    static interface NavTag
    extends Serializable {
        public int getStartEndPosition();

        public int getEndStartPosition();

        public int getLength();

        public int getLineNum();

        public String getInnerText();

        public NavTag offsetBy(int var1, int var2);

        public NavTag offsetBy(int var1, int var2, int var3);

        public int getStartStartPosition();

        public int getEndEndPosition();
    }

    static final class NavTagItem
    implements NavTag {
        private static final long serialVersionUID = 943178231155564912L;
        int startstart;
        int startend;
        int endstart;
        int endend;
        int lineNum;
        String innerText;

        public NavTagItem(int startstart, int startend, int endstart, int endend, int lineNum, String innerText) {
            this.startstart = startstart;
            this.startend = startend;
            this.endstart = endstart;
            this.endend = endend;
            this.lineNum = lineNum;
            this.innerText = innerText;
        }

        @Override
        public NavTag offsetBy(int offset, int addedLineNum) {
            if (offset == 0) {
                return this;
            }
            int ss = this.startstart + offset;
            int se = this.startend + offset;
            int es = this.endstart + offset;
            int ee = this.endend + offset;
            return new NavTagItem(ss, se, es, ee, this.lineNum + addedLineNum, this.innerText);
        }

        @Override
        public NavTag offsetBy(int offsetOpen, int offsetClose, int addedLineNum) {
            if (offsetOpen == 0 && offsetClose == 0) {
                return this;
            }
            int ss = this.startstart + offsetOpen;
            int se = this.startend + offsetOpen;
            int es = this.endstart + offsetClose;
            int ee = this.endend + offsetClose;
            return new NavTagItem(ss, se, es, ee, this.lineNum + addedLineNum, this.innerText);
        }

        @Override
        public int getStartEndPosition() {
            return this.startend;
        }

        @Override
        public int getEndStartPosition() {
            return this.endstart;
        }

        @Override
        public int getStartStartPosition() {
            return this.startstart;
        }

        @Override
        public int getEndEndPosition() {
            return this.endend;
        }

        @Override
        public int getLineNum() {
            return this.lineNum;
        }

        @Override
        public String getInnerText() {
            return this.innerText;
        }

        @Override
        public int getLength() {
            return this.startend - this.startstart;
        }

        public int getStartStart() {
            return this.startstart;
        }

        public int getEndEnd() {
            return this.endend;
        }
    }

    private static final class StringCache {
        private static final WeakHashMap map = new WeakHashMap();

        private StringCache() {
        }

        public static String getObject(String s) {
            String cachedInstance;
            if (s == null) {
                return null;
            }
            WeakReference w = (WeakReference)map.get(s);
            String string = cachedInstance = w == null ? null : (String)w.get();
            if (cachedInstance != null) {
                return cachedInstance;
            }
            WeakReference<String> wref = new WeakReference<String>(s);
            map.put(s, wref);
            return s;
        }
    }

    static final class TinyEncodingMemento
    implements Serializable {
        private static final long serialVersionUID = -8672028491412492310L;
        final String javaEncoding;
        final boolean useUTF83BytesBOM;

        public TinyEncodingMemento(String javaEncoding, boolean useUTF83BytesBOM) {
            this.javaEncoding = javaEncoding;
            this.useUTF83BytesBOM = useUTF83BytesBOM;
        }
    }
}

