/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.NavTagHandler;
import com.ibm.etools.siteedit.internal.builder.model.NavTagValidator;
import com.ibm.etools.siteedit.internal.builder.model.SiteNavReadOnlyException;
import com.ibm.etools.siteedit.internal.builder.model.SitePageContext;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import com.ibm.etools.siteedit.internal.builder.site.GSUnmappedPage;
import com.ibm.etools.siteedit.internal.builder.site.handler.NavTagHandlerFactory;
import com.ibm.etools.siteedit.internal.builder.util.FileContext;
import com.ibm.etools.siteedit.internal.builder.util.SpeculativeBuildUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SitePageBuildOperator {
    protected NavTagHandlerFactory tagHandlerFactory;

    public SitePageBuildOperator(NavTagHandlerFactory handlerFactory) {
        this.tagHandlerFactory = handlerFactory;
    }

    public boolean build(FileContext fc) throws SiteNavException {
        try {
            IFile file = fc.getFile();
            SpeculativeBuildUtil.removeMarker(file);
            NavTagValidator.removeMarker(file);
            SitePageModel model = fc.getSitePageModel();
            if (model == null) {
                return false;
            }
            PageContext context = new PageContext(file, model);
            SitePageContext.Writer writer = context.getWriter();
            this.generateCommentTags(model, context, writer);
            try {
                fc.waitForWritingFile();
                boolean fWrote = model.write();
                if (fWrote && fc.getBuildContext().isSpeculativeBuild()) {
                    SpeculativeBuildUtil.createMarker(file);
                }
                this.validateTags(model, context);
                boolean bl = fWrote;
                return bl;
            }
            catch (SiteNavReadOnlyException siteNavReadOnlyException) {
                fc.setCannotUpdated(true);
                fc.dispose();
                return false;
            }
        }
        finally {
            fc.dispose();
        }
    }

    private void validateTags(SitePageModel model, PageContext context) {
        IFile targetFile = context.getContextFile();
        this.addImarkerAtCommentTag(model, targetFile);
        this.addImarkerAtCustomTag(model, targetFile);
    }

    private void addImarkerAtCommentTag(SitePageModel model, IFile targetFile) {
        boolean isUnmapped = false;
        int nPlace = model.getCommentTagLength();
        int i = 0;
        while (i < nPlace) {
            NavElement node = model.commentTagItem(i);
            NavTagHandler handler = this.tagHandlerFactory.craete(node);
            if (handler == null) {
                return;
            }
            if (handler.gsModelHandler.getGSPage(targetFile) instanceof GSUnmappedPage) {
                isUnmapped = true;
            }
            NavTagValidator.addMarker(node, targetFile, isUnmapped, model.isTemplate());
            ++i;
        }
    }

    private void addImarkerAtCustomTag(SitePageModel model, IFile targetFile) {
        boolean isUnmapped = false;
        int nPlace = model.getCustomTagLength();
        int i = 0;
        while (i < nPlace) {
            NavElement node = model.customTagItem(i);
            NavTagHandler handler = this.tagHandlerFactory.craete(node);
            if (handler.gsModelHandler.getGSPage(targetFile) instanceof GSUnmappedPage) {
                isUnmapped = true;
            }
            NavTagValidator.addMarker(node, targetFile, isUnmapped, model.isTemplate());
            ++i;
        }
    }

    private void generateCommentTags(SitePageModel model, PageContext context, SitePageContext.Writer writer) {
        int nReplace = model.getCommentTagLength();
        int i = 0;
        while (i < nReplace) {
            NavTagHandler handler;
            NavElement node = model.commentTagItem(i);
            if (!node.getAllAttr().isEmpty() && (handler = this.tagHandlerFactory.craete(node)) != null) {
                String result = null;
                writer.refresh();
                if (handler.validate(context)) {
                    result = handler.getResult(node, context);
                }
                writer.out(result);
                if (writer.isDirty()) {
                    writer.commit(i);
                }
            }
            ++i;
        }
    }

    public String getVisual(FileContext fc, NavElement node, Map pagedata) {
        NavTagHandler handler;
        SitePageModel model = fc.getSitePageModel();
        if (model == null) {
            return null;
        }
        if (node == null) {
            return null;
        }
        PageContext pc = new PageContext(fc.getFile(), model);
        if (pagedata != null) {
            pc.getPageData().putAll(pagedata);
        }
        return (handler = this.tagHandlerFactory.craete(node)) != null ? handler.getResult(node, pc) : null;
    }

    static class PageContext
    implements SitePageContext {
        private SitePageContext.Writer writer;
        private IFile targetFile;
        private String baseHref;
        private String declaration;
        private String publicId;
        private Map pageData = new HashMap(1);
        private SitePageModel model;

        public PageContext(IFile file, SitePageModel model) {
            this.targetFile = file;
            this.model = model;
            this.setBaseHref(model.getBaseHref());
            this.setDeclaration(model.getDeclaration());
            this.setPublicId(model.getPublicId());
            this.setWriter(model.getWriter());
        }

        @Override
        public String getContextPath() {
            IPath webModulePath;
            int nMatch;
            IVirtualComponent component = WebComponentUtil.findComponent((IResource)this.targetFile);
            IPath projectRelativePath = this.targetFile.getFullPath();
            IPath webModuleRelativePath = projectRelativePath.removeFirstSegments(nMatch = projectRelativePath.matchingFirstSegments(webModulePath = WebComponentUtil.getWebModuleContainer(component).getFullPath()));
            return webModuleRelativePath == null ? "" : webModuleRelativePath.toString();
        }

        @Override
        public IFile getContextFile() {
            return this.targetFile;
        }

        @Override
        public SitePageContext.Writer getWriter() {
            return this.writer;
        }

        @Override
        public void setWriter(SitePageContext.Writer writer) {
            this.writer = writer;
        }

        @Override
        public String getBaseHref() {
            return this.baseHref;
        }

        @Override
        public void setBaseHref(String baseHref) {
            this.baseHref = baseHref;
        }

        @Override
        public String getDeclaration() {
            return this.declaration;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setDeclaration(String string) {
            this.declaration = string;
        }

        @Override
        public void setPublicId(String string) {
            this.publicId = string;
        }

        @Override
        public Map getPageData() {
            return this.pageData;
        }

        @Override
        public Map getTaglibMappings() {
            return this.model.getTaglibMappings();
        }

        @Override
        public boolean isTemplate() {
            return this.model.isTemplate();
        }
    }
}

