/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavConstants;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterTagNode;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.core.util.SitePageInfoUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTemplateUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.sitetags.model.NavTagAttributesConstants;
import com.ibm.etools.siteedit.util.FileUtil2;
import com.ibm.etools.siteedit.util.SiteTagValidation;
import com.ibm.etools.siteedit.util.SiteTagValidationMessagStrings;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class NavTagValidator
extends SiteTagValidation
implements SiteTagValidationMessagStrings,
SiteNavConstants,
NavTagAttributesConstants {
    private static final String[] SPEC_NAVTYPE = new String[]{"siteedit:navbar", "siteedit:navtab", "siteedit:navtrail", "siteedit:sitemap"};
    private static final String[] MAPPED_NAVTYPE = new String[]{"siteedit:navtrail"};

    public static boolean validate(IFile file) {
        if (SiteTemplateUtil.isTemplate(file)) {
            return true;
        }
        return SitePageInfoUtil.hasSiteStructure(WebComponentUtil.findComponent((IResource)file));
    }

    public static void removeMarker(IFile file) {
        try {
            IMarker[] markers = file.findMarkers("com.ibm.etools.siteedit.SiteNavBuilder.navtagmarker", true, 2);
            int i = 0;
            while (i < markers.length) {
                markers[i].delete();
                ++i;
            }
        }
        catch (CoreException e) {
            SiteNavBuilderLogger.log(e);
        }
    }

    public static void addMarker(NavElement node, IFile file, boolean isUnmappedPage, boolean isTemplate) {
        ErrorReporterTagNode reporter = node.getErrorReporter();
        IVirtualComponent component = WebComponentUtil.findComponent((IResource)file);
        try {
            if (SiteTemplateUtil.isDynamicTemplate(isTemplate, file) && !node.isCustomTag()) {
                String m = SiteNavMessages.ERROR_NO_HTML_NAV_IN_DYNAMIC_TEMPLATE;
                node.getErrorReporter().reportError(2, "com.ibm.etools.siteedit.SiteNavBuilder.navtagmarker", m);
                return;
            }
            if (!SitePageInfoUtil.hasSiteStructure(component)) {
                long markerID = reporter.reportError(1, "com.ibm.etools.siteedit.SiteNavBuilder.navtagmarker", WARNING_MESSAGE_NOLINKS);
                reporter.setAttribute("violation", 1, markerID);
            } else {
                NavTagValidator.addMarkerForUnmappedPage(node, file, isTemplate, isUnmappedPage);
            }
            if (NavTagValidator.isSpecNavType(node) && node.isStart() && !node.containsAttr("spec")) {
                String m = SiteNavMessages.format2(SiteNavMessages.WARRN_NOATTR_IN_TAG2, "spec", node.getTagName());
                node.getErrorReporter().reportError(2, "com.ibm.etools.siteedit.SiteNavBuilder.navtagmarker", m);
            }
        }
        catch (CoreException e) {
            SiteNavBuilderLogger.log(e);
        }
    }

    private static void addMarkerForUnmappedPage(NavElement node, IFile currentFile, boolean isTemplateFile, boolean isUnmappedPage) throws CoreException {
        if (!isUnmappedPage && !isTemplateFile || FileUtil2.isJSPFragmentFile(currentFile)) {
            return;
        }
        int severity = isTemplateFile ? 0 : 1;
        if (NavTagValidator.isMappedNavType(node)) {
            String msg = NavTagValidator.getValidationNavTypeMessage(isTemplateFile, isUnmappedPage);
            ErrorReporterTagNode typeerror = node.getErrorReporter();
            long markerId = typeerror.reportError(severity, "com.ibm.etools.siteedit.SiteNavBuilder.navtagmarker", msg);
            typeerror.setAttribute("violation", 2, markerId);
        } else {
            ErrorReporter attrError = node.getErrorReporterForAttr("target");
            String[] invalidTarget = NavTagValidator.getTargetKeys(node.getAttr("target"));
            if (invalidTarget.length > 0) {
                String msg2 = NavTagValidator.getValidationMappedMessage(invalidTarget[0], isTemplateFile, 2);
                long markerID = attrError.reportError(severity, "com.ibm.etools.siteedit.SiteNavBuilder.navtagmarker", msg2);
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < invalidTarget.length) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(invalidTarget[i]);
                    ++i;
                }
                attrError.setAttribute("key", buf.toString(), markerID);
                attrError.setAttribute("violation", 3, markerID);
            }
        }
    }

    private static boolean isMappedNavType(NavElement node) {
        return Arrays.asList(MAPPED_NAVTYPE).contains(node.getTagName());
    }

    private static boolean isSpecNavType(NavElement node) {
        return Arrays.asList(SPEC_NAVTYPE).contains(node.getTagName());
    }
}

