/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.model;

import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterTagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagAttr;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeFactory;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeLinkUtil;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import com.ibm.etools.siteedit.internal.builder.model.SitePageCachedModelEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.w3c.dom.Element;

public class NavElement
extends TagNode {
    private final boolean isCustomTag;

    public NavElement(int type, String tagName, TagAttr attr, ErrorReporterTagNode er, boolean isCustomTag) {
        super(type, tagName, attr, er);
        this.isCustomTag = isCustomTag;
    }

    public IFile getNavspecFile(IFile baseFile, String baseHref) {
        return TagNodeLinkUtil.getFileOfAttr(baseFile, this, "spec", baseHref);
    }

    public static Factory getFactory(IFile file) {
        return new Factory(file);
    }

    public boolean isCustomTag() {
        return this.isCustomTag;
    }

    public void updateErrorReporter(SitePageCachedModelEntry.NavTag item) {
        this.getErrorReporter().update(item.getStartStartPosition(), item.getLineNum());
    }

    public void updateErrorReporter(int newStartPosition, int newLineNum) {
        this.getErrorReporter().update(newStartPosition, newLineNum);
    }

    public static class Factory
    extends TagNodeFactory.DefFactory {
        public Factory(IFile file) {
            super(file);
        }

        public NavElement createJspnave(IStructuredDocumentRegion n, String jspNavTagPrefix) {
            TagNode tagnode = TagParser.parseNormal(n, jspNavTagPrefix, this);
            return this.castToNavElement(tagnode, true);
        }

        public NavElement createJspnav(String jspnavPrefix, String innerText, int startPosition, int lineNum, int length) {
            TagNode tagnode = TagParser.parseNormal(jspnavPrefix, this, innerText, true, startPosition, lineNum, length);
            return this.castToNavElement(tagnode, true);
        }

        public NavElement create(Element e) {
            TagNode tagnode = TagParser.parse(e, "siteedit:", false, this);
            return this.castToNavElement(tagnode, false);
        }

        public NavElement create(IStructuredDocumentRegion region) {
            TagNode tagnode = TagParser.parse("siteedit:", false, this, region);
            return this.castToNavElement(tagnode, false);
        }

        public NavElement create(String tagPrefix, IStructuredDocumentRegion region) {
            TagNode tagnode = TagParser.parse(tagPrefix, false, this, region);
            return this.castToNavElement(tagnode, false);
        }

        public NavElement create(String prefix, boolean ignoreCase, String contents, int startPos, int lineNum, int length) {
            TagNode tagnode = TagParser.parse(contents, prefix, ignoreCase, this, startPos, lineNum);
            return this.castToNavElement(tagnode, false);
        }

        private NavElement castToNavElement(TagNode tagnode, boolean isCustomTag) {
            if (tagnode == null) {
                return null;
            }
            return new NavElement(tagnode.getType(), tagnode.getTagName(), tagnode.getAllAttr(), tagnode.getErrorReporter(), isCustomTag);
        }

        public NavElement create(String innerText, int startPosition, int lineNumber, int length) {
            TagNode tagnode = TagParser.parse(innerText, "siteedit:", false, this, startPosition, lineNumber);
            return this.castToNavElement(tagnode, false);
        }
    }
}

