/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.common;

import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeFactory;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class FlatModelDifference {
    final Map dstToSrc;

    public FlatModelDifference(IStructuredDocument srcModel, IStructuredDocument dstModel, IFile file) {
        this.dstToSrc = FlatModelDifference.getMatch(srcModel, dstModel, file);
    }

    public IStructuredDocumentRegion getSrcNode(IStructuredDocumentRegion n) {
        IStructuredDocumentRegion a = (IStructuredDocumentRegion)this.dstToSrc.get(n);
        if (a != null) {
            return a;
        }
        a = (IStructuredDocumentRegion)this.dstToSrc.get(n.getPrevious());
        if (a != null) {
            return a.getNext();
        }
        return null;
    }

    static Map getMatch(IStructuredDocument src, IStructuredDocument dst, IFile file) {
        MatchFinder mf = new MatchFinder(src, dst, file);
        while (mf.hasMatch()) {
            mf.commitMatch();
        }
        return mf.getResult();
    }

    private static class Data {
        private final IStructuredDocumentRegion[] srcNodes;
        private final IStructuredDocumentRegion[] dstNodes;
        private final int srcLength;
        private final int dstLength;
        private static IFile file;
        int srcIndex = -1;
        int dstIndex = -1;
        final HashMap result = new HashMap();

        Data(IStructuredDocument src, IStructuredDocument dst, IFile file) {
            this.srcNodes = src.getStructuredDocumentRegions();
            this.srcLength = this.srcNodes.length;
            this.dstNodes = dst.getStructuredDocumentRegions();
            this.dstLength = this.dstNodes.length;
            Data.file = file;
        }

        IStructuredDocumentRegion getSrc(int offset) {
            int index = this.srcIndex + offset;
            return index >= 0 && index < this.srcLength ? this.srcNodes[index] : null;
        }

        IStructuredDocumentRegion getDst(int offset) {
            int index = this.dstIndex + offset;
            return index >= 0 && index < this.dstLength ? this.dstNodes[index] : null;
        }

        int getNextTagOffsetSrc() {
            int off = 1;
            while (this.getSrc(off) != null) {
                if (Data.isTag(this.getSrc(off))) {
                    return off;
                }
                ++off;
            }
            return -1;
        }

        int getNextTagOffsetDst() {
            int off = 1;
            while (this.getDst(off) != null) {
                if (Data.isTag(this.getDst(off))) {
                    return off;
                }
                ++off;
            }
            return -1;
        }

        void setSync(int aOffset, int bOffset) {
            this.srcIndex += aOffset;
            this.dstIndex += bOffset;
            this.result.put(this.getDst(0), this.getSrc(0));
        }

        Map getResult() {
            return Collections.unmodifiableMap(this.result);
        }

        static boolean isTag(IStructuredDocumentRegion node) {
            return new TagData(node, file).isValid();
        }

        static boolean isMatchTag(IStructuredDocumentRegion a, IStructuredDocumentRegion b) {
            if (!Data.isTag(a) || !Data.isTag(b)) {
                return false;
            }
            TagData ta = new TagData(a, file);
            TagData tb = new TagData(b, file);
            return ta.equals(tb);
        }

        private static class TagData {
            public final String tagName;
            public final boolean fStartOrEmpty;
            public final boolean fEnd;

            public TagData(IStructuredDocumentRegion a, IFile file) {
                TagNode tn;
                String tagName = null;
                boolean fStartOrEmpty = false;
                boolean fEnd = false;
                if (a != null && a.getType() == "XML_TAG_NAME") {
                    for (ITextRegion r : a.getRegions()) {
                        String type = r.getType();
                        if ("XML_TAG_NAME" == type) {
                            if (!fStartOrEmpty && !fEnd) continue;
                            tagName = a.getText(r);
                            continue;
                        }
                        if ("XML_TAG_OPEN" == type) {
                            fStartOrEmpty = true;
                            continue;
                        }
                        if ("XML_END_TAG_OPEN" != type) continue;
                        fEnd = true;
                    }
                } else if (a != null && TagParser.isXMLJSPCommentType(a.getType()) && (tn = TagParser.parseXMLJSPComment(a, "siteedit:", TagNodeFactory.getDefFactory(file))) != null) {
                    boolean isComment = a.getType() == "XML_COMMENT_TEXT";
                    tagName = String.valueOf(isComment ? "<!--" : "<%--") + tn.getTagName();
                    fStartOrEmpty = tn.isStart() || tn.isEmpty();
                    fEnd = tn.isEnd();
                }
                this.tagName = tagName != null ? tagName.toLowerCase(Locale.US) : null;
                this.fStartOrEmpty = fStartOrEmpty;
                this.fEnd = fEnd;
            }

            public boolean equals(Object oh) {
                if (!(oh instanceof TagData)) {
                    return false;
                }
                TagData o = (TagData)oh;
                return (this.tagName == null ? o.tagName == null : this.tagName.equals(o.tagName)) && this.fStartOrEmpty == o.fStartOrEmpty && this.fEnd == o.fEnd;
            }

            public boolean isValid() {
                return this.tagName != null && (this.fStartOrEmpty || this.fEnd);
            }
        }
    }

    private static class MatchFinder {
        static final int FUZZY_FACTOR = 5;
        final Data data;
        int srcOffset;
        int dstOffset;
        int resSrc;
        int resDst;

        public MatchFinder(IStructuredDocument src, IStructuredDocument dst, IFile file) {
            this.data = new Data(src, dst, file);
            this.findNextMatch();
        }

        private void findNextMatch() {
            this.srcOffset = this.data.getNextTagOffsetSrc();
            this.dstOffset = this.data.getNextTagOffsetDst();
            if (this.srcOffset <= 0 || this.dstOffset <= 0) {
                this.resDst = 0;
                this.resSrc = 0;
                return;
            }
            int i = 0;
            while (i < 5) {
                if (this.findByScale(i)) {
                    return;
                }
                ++i;
            }
        }

        private boolean findByScale(int i) {
            int dIndex = this.dstOffset + i;
            if (dIndex > 0 && Data.isMatchTag(this.data.getSrc(this.srcOffset), this.data.getDst(dIndex))) {
                this.resSrc = this.srcOffset;
                this.resDst = dIndex;
                return true;
            }
            int sIndex = this.srcOffset + i;
            if (sIndex > 0 && Data.isMatchTag(this.data.getDst(this.dstOffset), this.data.getSrc(sIndex))) {
                this.resSrc = sIndex;
                this.resDst = this.dstOffset;
                return true;
            }
            return false;
        }

        public boolean hasMatch() {
            return this.resSrc > 0 && this.resDst > 0;
        }

        public void commitMatch() {
            this.data.setSync(this.resSrc, this.resDst);
            this.findNextMatch();
        }

        public Map getResult() {
            return this.data.getResult();
        }
    }
}

