/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.common;

import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterAttrNode;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class ErrorReporterTagNode
implements ErrorReporter {
    private final IFile file;
    private int startPosition;
    private int lineNum;
    private String tagInnerText;
    private ArrayList markerIDs = new ArrayList();
    private Map attrMarkers = new HashMap();
    private IMarker marker;

    public ErrorReporterTagNode(IFile file, int startPosition, int lineNum, String tagInnerText) {
        this.file = file;
        this.startPosition = startPosition;
        this.lineNum = lineNum;
        this.tagInnerText = tagInnerText;
    }

    public ErrorReporterTagNode(IFile file, IStructuredDocumentRegion region) {
        this(file, region.getStart(), region.getParentDocument().getLineOfOffset(region.getStart()) + 1, region.getFullText());
    }

    @Override
    public void reportError(int sev, String type, String msg, boolean isMulti) throws CoreException {
        if (!isMulti && this.hasError(this.getFile(), this.markerIDs)) {
            return;
        }
        this.reportError(sev, type, msg);
    }

    @Override
    public long reportError(int sev, String type, String msg) throws CoreException {
        long markerId = this.createMarker(this.startPosition, this.startPosition + this.tagInnerText.length(), this.lineNum, sev, type, msg);
        this.markerIDs.add(String.valueOf(markerId));
        return markerId;
    }

    @Override
    public ErrorReporter getPart(int partPos, int length) {
        return new ErrorReporterPart(this, partPos, length);
    }

    public ErrorReporter getAttr(String attrName) {
        return new ErrorReporterAttrNode(this, attrName);
    }

    public void update(int startPosition, int lineNum) {
        this.startPosition = startPosition;
        this.lineNum = lineNum;
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public boolean setAttribute(String attributeName, String attributeValue, long markerID) {
        try {
            this.getFile().getMarker(markerID).setAttribute(attributeName, (Object)attributeValue);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public boolean setAttribute(String attributeName, int attributeValueI, long markerID) {
        try {
            this.getFile().getMarker(markerID).setAttribute(attributeName, attributeValueI);
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean hasError(IFile file, List markerList) {
        int i = 0;
        while (i < markerList.size()) {
            long markerID = Long.parseLong(markerList.get(i).toString());
            if (file.getMarker(markerID).exists()) {
                return true;
            }
            this.markerIDs.remove(i);
            ++i;
        }
        return false;
    }

    long createMarker(int startPos, int endPos, int lineNum, int sev, String type, String msg) throws CoreException {
        this.marker = this.getFile().createMarker(type);
        this.marker.setAttribute("charStart", startPos);
        this.marker.setAttribute("charEnd", endPos);
        this.marker.setAttribute("lineNumber", lineNum);
        this.marker.setAttribute("message", (Object)msg);
        this.marker.setAttribute("severity", sev);
        return this.marker.getId();
    }

    public void reportPartError(int startPos, int length, int sev, String type, String msg, boolean isMulti) throws CoreException {
        List attrMarkerIDs = this.getAttrMarkerIDList(startPos);
        if (this.hasError(this.file, attrMarkerIDs)) {
            return;
        }
        this.reportPartError(startPos, length, sev, type, msg);
    }

    public long reportPartError(int startPos, int length, int sev, String type, String msg) throws CoreException {
        int difLine = ErrorReporterPart.findLineDifference(this.getTagInnerText(), startPos);
        int startP = startPos + this.startPosition;
        long newMarkerID = this.createMarker(startP, startP + length, this.lineNum + difLine, sev, type, msg);
        this.updateAttrMarkers(startPos, newMarkerID);
        return newMarkerID;
    }

    private List getAttrMarkerIDList(int key) {
        String keyS = String.valueOf(key);
        ArrayList markerIDs = this.attrMarkers.containsKey(keyS) ? (ArrayList)this.attrMarkers.get(keyS) : new ArrayList();
        return markerIDs;
    }

    private void updateAttrMarkers(int keyValue, long markerID) {
        List attrMarkerIDs = this.getAttrMarkerIDList(keyValue);
        attrMarkerIDs.add(String.valueOf(markerID));
        this.attrMarkers.put(String.valueOf(keyValue), attrMarkerIDs);
    }

    public String getTagInnerText() {
        return this.tagInnerText;
    }
}

