/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.analysis.DepthFirstAdapter;
import com.ibm.etools.siteedit.core.internal.el.impl.ArithmeticOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.ContextOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.ELPartOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.EmptyOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.Evalable;
import com.ibm.etools.siteedit.core.internal.el.impl.LiteralOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.LogicalOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.PropertyOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.RelationalOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.StringConcatOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.StringOperator;
import com.ibm.etools.siteedit.core.internal.el.node.AAndBinaryExp5;
import com.ibm.etools.siteedit.core.internal.el.node.ABooleanLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.ADivBinaryExp1;
import com.ibm.etools.siteedit.core.internal.el.node.AElGrammerItem;
import com.ibm.etools.siteedit.core.internal.el.node.AEmptyUnaryExp;
import com.ibm.etools.siteedit.core.internal.el.node.AEqBinaryExp4;
import com.ibm.etools.siteedit.core.internal.el.node.AExpExp;
import com.ibm.etools.siteedit.core.internal.el.node.AExpValuePrefix;
import com.ibm.etools.siteedit.core.internal.el.node.AExpressionValueSuffix;
import com.ibm.etools.siteedit.core.internal.el.node.AFloatLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.AGeBinaryExp3;
import com.ibm.etools.siteedit.core.internal.el.node.AGrammer;
import com.ibm.etools.siteedit.core.internal.el.node.AGtBinaryExp3;
import com.ibm.etools.siteedit.core.internal.el.node.AIdValuePrefix;
import com.ibm.etools.siteedit.core.internal.el.node.AIdValueSuffix;
import com.ibm.etools.siteedit.core.internal.el.node.AIntegerLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.ALeBinaryExp3;
import com.ibm.etools.siteedit.core.internal.el.node.ALiteralValuePrefix;
import com.ibm.etools.siteedit.core.internal.el.node.ALtBinaryExp3;
import com.ibm.etools.siteedit.core.internal.el.node.AMinusBinaryExp2;
import com.ibm.etools.siteedit.core.internal.el.node.AMinusUnaryExp;
import com.ibm.etools.siteedit.core.internal.el.node.AModBinaryExp1;
import com.ibm.etools.siteedit.core.internal.el.node.AMultiBinaryExp1;
import com.ibm.etools.siteedit.core.internal.el.node.ANeBinaryExp4;
import com.ibm.etools.siteedit.core.internal.el.node.ANotUnaryExp;
import com.ibm.etools.siteedit.core.internal.el.node.ANullLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.AOrBinaryExp6;
import com.ibm.etools.siteedit.core.internal.el.node.APlusBinaryExp2;
import com.ibm.etools.siteedit.core.internal.el.node.APlusUnaryExp;
import com.ibm.etools.siteedit.core.internal.el.node.APredBinaryExp1;
import com.ibm.etools.siteedit.core.internal.el.node.APredBinaryExp2;
import com.ibm.etools.siteedit.core.internal.el.node.APredBinaryExp3;
import com.ibm.etools.siteedit.core.internal.el.node.APredBinaryExp4;
import com.ibm.etools.siteedit.core.internal.el.node.APredBinaryExp5;
import com.ibm.etools.siteedit.core.internal.el.node.APredBinaryExp6;
import com.ibm.etools.siteedit.core.internal.el.node.APredUnaryExp;
import com.ibm.etools.siteedit.core.internal.el.node.APrefixValue;
import com.ibm.etools.siteedit.core.internal.el.node.APropertyValue;
import com.ibm.etools.siteedit.core.internal.el.node.AStringGrammerItem;
import com.ibm.etools.siteedit.core.internal.el.node.AStringLiteral;
import com.ibm.etools.siteedit.core.internal.el.node.Node;
import com.ibm.etools.siteedit.core.internal.el.node.TElEnd;
import com.ibm.etools.siteedit.core.internal.el.node.TElStart;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterAttrNode;
import com.ibm.etools.siteedit.internal.builder.common.StringUtil;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import java.util.ArrayList;
import java.util.LinkedList;

public class SemanticTreeMaker
extends DepthFirstAdapter {
    private Evalable result;
    private String src;
    private boolean escapeExp;
    private ErrorReporter errorReporter;

    public SemanticTreeMaker(String src, boolean escapeExp, ErrorReporter r) {
        this.src = src;
        this.errorReporter = r;
        this.escapeExp = escapeExp;
    }

    public Evalable getResult() {
        return this.result;
    }

    private void set(Node node, Evalable out) {
        this.setOut(node, out);
    }

    private Evalable get(Node node) {
        return (Evalable)this.getOut(node);
    }

    @Override
    public void outAAndBinaryExp5(AAndBinaryExp5 node) {
        Evalable a = this.get(node.getBinaryExp5());
        Evalable b = this.get(node.getBinaryExp4());
        this.set(node, new LogicalOperator(a, 1, b));
    }

    @Override
    public void outABooleanLiteral(ABooleanLiteral node) {
        String s = node.getBooleanLiteral().getText();
        this.set(node, new LiteralOperator(Boolean.valueOf(s)));
    }

    @Override
    public void outADivBinaryExp1(ADivBinaryExp1 node) {
        Evalable a = this.get(node.getBinaryExp1());
        Evalable b = this.get(node.getUnaryExp());
        this.set(node, new ArithmeticOperator(a, 4, b));
    }

    @Override
    public void outAElGrammerItem(AElGrammerItem node) {
        TElStart start = node.getElStart();
        TElEnd end = node.getElEnd();
        int startPos = StringUtil.getIndexOfTextPos(this.src, start.getLine() - 1, start.getPos() - 1);
        int endPos = StringUtil.getIndexOfTextPos(this.src, end.getLine() - 1, end.getPos() - 1);
        String elSrc = this.src.substring(startPos, endPos + 1);
        if (this.errorReporter instanceof ErrorReporterAttrNode) {
            String attrName = ((ErrorReporterAttrNode)this.errorReporter).getAttrName();
            String tagInnerText = ((ErrorReporterAttrNode)this.errorReporter).getParentReporter().getTagInnerText();
            int attrValuePosFromStartTag = TagParser.getOffsetAttrValue(tagInnerText, attrName);
            startPos += attrValuePosFromStartTag;
        }
        ELPartOperator a = new ELPartOperator(elSrc, this.get(node.getExp()), startPos, this.errorReporter);
        this.set(node, a);
    }

    @Override
    public void outAEmptyUnaryExp(AEmptyUnaryExp node) {
        Evalable a = this.get(node.getValue());
        this.set(node, new EmptyOperator(a));
    }

    @Override
    public void outAEqBinaryExp4(AEqBinaryExp4 node) {
        Evalable a = this.get(node.getBinaryExp4());
        Evalable b = this.get(node.getBinaryExp3());
        this.set(node, new RelationalOperator(a, 2, b));
    }

    @Override
    public void outAExpExp(AExpExp node) {
        this.set(node, this.get(node.getBinaryExp6()));
    }

    @Override
    public void outAExpressionValueSuffix(AExpressionValueSuffix node) {
        this.set(node, this.get(node.getExp()));
    }

    @Override
    public void outAExpValuePrefix(AExpValuePrefix node) {
        this.set(node, this.get(node.getExp()));
    }

    @Override
    public void outAFloatLiteral(AFloatLiteral node) {
        double d = Double.parseDouble(node.getFloatLiteral().getText());
        this.set(node, new LiteralOperator(d));
    }

    @Override
    public void outAGeBinaryExp3(AGeBinaryExp3 node) {
        Evalable a = this.get(node.getBinaryExp3());
        Evalable b = this.get(node.getBinaryExp2());
        this.set(node, new RelationalOperator(a, 5, b));
    }

    @Override
    public void outAGrammer(AGrammer node) {
        LinkedList nodes = node.getGrammerItem();
        Evalable result = null;
        if (nodes == null || nodes.size() == 0) {
            result = new LiteralOperator("");
        } else if (nodes.size() == 1 && !this.escapeExp) {
            result = this.get((Node)nodes.get(0));
        } else {
            ArrayList<Evalable> r = new ArrayList<Evalable>(nodes.size());
            for (Node n : nodes) {
                r.add(this.get(n));
            }
            result = new StringConcatOperator(r, this.escapeExp);
        }
        this.result = result;
    }

    @Override
    public void outAGtBinaryExp3(AGtBinaryExp3 node) {
        Evalable a = this.get(node.getBinaryExp3());
        Evalable b = this.get(node.getBinaryExp2());
        this.set(node, new RelationalOperator(a, 7, b));
    }

    @Override
    public void outAIdValuePrefix(AIdValuePrefix node) {
        String id = node.getIdentifier().getText();
        this.set(node, new ContextOperator(id));
    }

    @Override
    public void outAIdValueSuffix(AIdValueSuffix node) {
        String id = node.getIdentifier().getText();
        this.set(node, new LiteralOperator(id));
    }

    @Override
    public void outAIntegerLiteral(AIntegerLiteral node) {
        long value = Long.parseLong(node.getIntegerLiteral().getText());
        this.set(node, new LiteralOperator(value));
    }

    @Override
    public void outALeBinaryExp3(ALeBinaryExp3 node) {
        Evalable a = this.get(node.getBinaryExp3());
        Evalable b = this.get(node.getBinaryExp2());
        this.set(node, new RelationalOperator(a, 3, b));
    }

    @Override
    public void outALiteralValuePrefix(ALiteralValuePrefix node) {
        this.set(node, this.get(node.getLiteral()));
    }

    @Override
    public void outALtBinaryExp3(ALtBinaryExp3 node) {
        Evalable a = this.get(node.getBinaryExp3());
        Evalable b = this.get(node.getBinaryExp2());
        this.set(node, new RelationalOperator(a, 1, b));
    }

    @Override
    public void outAMinusBinaryExp2(AMinusBinaryExp2 node) {
        Evalable a = this.get(node.getBinaryExp2());
        Evalable b = this.get(node.getBinaryExp1());
        this.set(node, new ArithmeticOperator(a, 2, b));
    }

    @Override
    public void outAMinusUnaryExp(AMinusUnaryExp node) {
        Evalable a = this.get(node.getValue());
        this.set(node, new ArithmeticOperator(6, a));
    }

    @Override
    public void outAModBinaryExp1(AModBinaryExp1 node) {
        Evalable a = this.get(node.getBinaryExp1());
        Evalable b = this.get(node.getUnaryExp());
        this.set(node, new ArithmeticOperator(a, 5, b));
    }

    @Override
    public void outAMultiBinaryExp1(AMultiBinaryExp1 node) {
        Evalable a = this.get(node.getBinaryExp1());
        Evalable b = this.get(node.getUnaryExp());
        this.set(node, new ArithmeticOperator(a, 3, b));
    }

    @Override
    public void outANeBinaryExp4(ANeBinaryExp4 node) {
        Evalable a = this.get(node.getBinaryExp4());
        Evalable b = this.get(node.getBinaryExp3());
        this.set(node, new RelationalOperator(a, 6, b));
    }

    @Override
    public void outANotUnaryExp(ANotUnaryExp node) {
        Evalable a = this.get(node.getValue());
        this.set(node, new LogicalOperator(3, a));
    }

    @Override
    public void outANullLiteral(ANullLiteral node) {
        this.set(node, new LiteralOperator());
    }

    @Override
    public void outAOrBinaryExp6(AOrBinaryExp6 node) {
        Evalable a = this.get(node.getBinaryExp6());
        Evalable b = this.get(node.getBinaryExp5());
        this.set(node, new LogicalOperator(a, 2, b));
    }

    @Override
    public void outAPlusBinaryExp2(APlusBinaryExp2 node) {
        Evalable a = this.get(node.getBinaryExp2());
        Evalable b = this.get(node.getBinaryExp1());
        this.set(node, new ArithmeticOperator(a, 1, b));
    }

    @Override
    public void outAPlusUnaryExp(APlusUnaryExp node) {
        this.set(node, this.get(node.getValue()));
    }

    @Override
    public void outAPredBinaryExp1(APredBinaryExp1 node) {
        this.set(node, this.get(node.getUnaryExp()));
    }

    @Override
    public void outAPredBinaryExp2(APredBinaryExp2 node) {
        this.set(node, this.get(node.getBinaryExp1()));
    }

    @Override
    public void outAPredBinaryExp3(APredBinaryExp3 node) {
        this.set(node, this.get(node.getBinaryExp2()));
    }

    @Override
    public void outAPredBinaryExp4(APredBinaryExp4 node) {
        this.set(node, this.get(node.getBinaryExp3()));
    }

    @Override
    public void outAPredBinaryExp5(APredBinaryExp5 node) {
        this.set(node, this.get(node.getBinaryExp4()));
    }

    @Override
    public void outAPredBinaryExp6(APredBinaryExp6 node) {
        this.set(node, this.get(node.getBinaryExp5()));
    }

    @Override
    public void outAPredUnaryExp(APredUnaryExp node) {
        this.set(node, this.get(node.getValue()));
    }

    @Override
    public void outAPrefixValue(APrefixValue node) {
        this.set(node, this.get(node.getValuePrefix()));
    }

    @Override
    public void outAPropertyValue(APropertyValue node) {
        Evalable a = this.get(node.getValue());
        Evalable b = this.get(node.getValueSuffix());
        this.set(node, new PropertyOperator(a, b));
    }

    @Override
    public void outAStringGrammerItem(AStringGrammerItem node) {
        String text = node.getString().getText();
        this.set(node, new StringOperator(text));
    }

    @Override
    public void outAStringLiteral(AStringLiteral node) {
        String text = node.getStringLiteral().getText();
        this.set(node, new LiteralOperator(text.substring(1, text.length() - 1)));
    }
}

