/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.VariableResolver;
import com.ibm.etools.siteedit.core.internal.el.error.CannotCompareException;
import com.ibm.etools.siteedit.core.internal.el.impl.CourseUtil;
import com.ibm.etools.siteedit.core.internal.el.impl.Evalable;

public class RelationalOperator
implements Evalable {
    private static final int OPF_COMPARE = 1;
    private static final int OPF_EQUAL = 2;
    private static final int OPF_NOT = 4;
    public static final int OP_EQUAL = 2;
    public static final int OP_NOT_EQUAL = 6;
    public static final int OP_LESS_THAN = 1;
    public static final int OP_LESS_EQUAL = 3;
    public static final int OP_GREATER_EQUAL = 5;
    public static final int OP_GREATER_THAN = 7;
    private Evalable expA;
    private Evalable expB;
    private int operator;

    public RelationalOperator(Evalable expA, int operator, Evalable expB) {
        this.expA = expA;
        this.expB = expB;
        this.operator = operator;
    }

    @Override
    public Object eval(VariableResolver env) throws ELErrorException {
        Object valueA = this.expA.eval(env);
        Object valueB = this.expB.eval(env);
        boolean result = false;
        result = (this.operator & 1) != 0 ? this.evalCoreCompare(valueA, valueB) : this.evalCoreEquals(valueA, valueB);
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean evalCoreCompare(Object valueA, Object valueB) throws ELErrorException {
        Object a;
        boolean fEqual;
        boolean bl = fEqual = (this.operator & 2) != 0;
        if ((this.operator & 4) != 0) {
            fEqual = !fEqual;
            Object tmp = valueA;
            valueA = valueB;
            valueB = tmp;
        }
        if (valueA == valueB) {
            return fEqual;
        }
        if (valueA == null || valueB == null) {
            return false;
        }
        if (this.isDouble(valueA) || this.isDouble(valueB)) {
            a = CourseUtil.toDouble(valueA);
            Double b = CourseUtil.toDouble(valueB);
            if (fEqual) {
                return (Double)a <= b;
            }
            return (Double)a < b;
        }
        if (valueA instanceof Number || valueB instanceof Number) {
            a = CourseUtil.toLong(valueA);
            Long b = CourseUtil.toLong(valueB);
            if (fEqual) {
                return (Long)a <= b;
            }
            return (Long)a < b;
        }
        if (valueA instanceof String || valueB instanceof String) {
            a = CourseUtil.toString(valueA);
            String b = CourseUtil.toString(valueB);
            if (fEqual) {
                return ((String)a).compareTo(b) <= 0;
            }
            return ((String)a).compareTo(b) < 0;
        }
        if (valueA instanceof Comparable) {
            a = (Comparable)valueA;
            if (fEqual) {
                return a.compareTo(valueB) <= 0;
            }
            return a.compareTo(valueB) < 0;
        }
        if (valueB instanceof Comparable) {
            Comparable b = (Comparable)valueB;
            if (fEqual) {
                return b.compareTo(valueA) > 0;
            }
            return b.compareTo(valueA) >= 0;
        }
        throw new CannotCompareException(CourseUtil.getClassName(valueA), CourseUtil.getClassName(valueB));
    }

    private boolean evalCoreEquals(Object valueA, Object valueB) throws ELErrorException {
        boolean fPositive;
        boolean bl = fPositive = (this.operator & 4) == 0;
        if (valueA == valueB) {
            return fPositive;
        }
        if (valueA == null || valueB == null) {
            return !fPositive;
        }
        if (this.isDouble(valueA) || this.isDouble(valueB)) {
            boolean result;
            Double a = CourseUtil.toDouble(valueA);
            Double b = CourseUtil.toDouble(valueB);
            boolean bl2 = result = a.doubleValue() == b.doubleValue();
            return fPositive ? result : !result;
        }
        if (valueA instanceof Number || valueB instanceof Number) {
            boolean result;
            Long a = CourseUtil.toLong(valueA);
            Long b = CourseUtil.toLong(valueB);
            boolean bl3 = result = a.longValue() == b.longValue();
            return fPositive ? result : !result;
        }
        if (valueA instanceof Boolean || valueB instanceof Boolean) {
            boolean result;
            Boolean a = CourseUtil.toBoolean(valueA);
            Boolean b = CourseUtil.toBoolean(valueB);
            boolean bl4 = result = a.booleanValue() == b.booleanValue();
            return fPositive ? result : !result;
        }
        if (valueA instanceof String || valueB instanceof String) {
            String a = CourseUtil.toString(valueA);
            String b = CourseUtil.toString(valueB);
            boolean result = a.equals(b);
            return fPositive ? result : !result;
        }
        try {
            boolean result = valueA.equals(valueB);
            return fPositive ? result : !result;
        }
        catch (Exception e) {
            throw new ELErrorException(e);
        }
    }

    private boolean isDouble(Object o) {
        return o instanceof Double || o instanceof Float;
    }
}

