/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.VariableResolver;
import com.ibm.etools.siteedit.core.internal.el.impl.CourseUtil;
import com.ibm.etools.siteedit.core.internal.el.impl.Evalable;

public class LogicalOperator
implements Evalable {
    public static final int OP_AND = 1;
    public static final int OP_OR = 2;
    public static final int OP_NOT = 3;
    private Evalable expA;
    private Evalable expB;
    private int operator;

    public LogicalOperator(Evalable expA, int operator, Evalable expB) {
        this.expA = expA;
        this.operator = operator;
        this.expB = expB;
    }

    public LogicalOperator(int operator, Evalable expA) {
        this.operator = operator;
        this.expA = expA;
    }

    @Override
    public Object eval(VariableResolver env) throws ELErrorException {
        if (this.expB == null) {
            return this.evalUnary(env);
        }
        return this.evalBinary(env);
    }

    private Boolean evalBinary(VariableResolver env) throws ELErrorException {
        Object valueA = this.expA.eval(env);
        Boolean a = CourseUtil.toBoolean(valueA);
        if (this.operator == 1 && !a.booleanValue()) {
            return a;
        }
        if (this.operator == 2 && a.booleanValue()) {
            return a;
        }
        Object valueB = this.expB.eval(env);
        return CourseUtil.toBoolean(valueB);
    }

    private Boolean evalUnary(VariableResolver env) throws ELErrorException {
        Object valueA = this.expA.eval(env);
        Boolean a = CourseUtil.toBoolean(valueA);
        return a != false ? Boolean.FALSE : Boolean.TRUE;
    }
}

