/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.error.CannotCompareException;
import com.ibm.etools.siteedit.core.internal.el.error.ELCannotEvalException;
import com.ibm.etools.siteedit.core.internal.el.error.PropertyNotFoundException;
import com.ibm.etools.siteedit.core.internal.el.error.TypeCannotConvertException;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import org.eclipse.core.runtime.CoreException;

public class ErrorTool {
    public static void reportELSyntax(ErrorReporter r) {
        if (r == null) {
            return;
        }
        String m = SiteNavMessages.WARRN_EL_SYNTAX;
        try {
            r.reportError(1, "com.ibm.etools.siteedit.SiteNavBuilder.navspecmarker", m, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void reportELRuntimeError(ErrorReporter r, ELErrorException e) {
        ELErrorException ee;
        if (r == null) {
            return;
        }
        String m = null;
        if (e instanceof PropertyNotFoundException) {
            ee = (PropertyNotFoundException)e;
            m = SiteNavMessages.format2(SiteNavMessages.WARRN_EL_NOPROP, ((PropertyNotFoundException)ee).getPropName(), ((PropertyNotFoundException)ee).getClassName());
        } else if (e instanceof ELCannotEvalException) {
            ee = (ELCannotEvalException)e;
            m = SiteNavMessages.format1(SiteNavMessages.WARRN_EL_NOOBJ, ((ELCannotEvalException)ee).getName());
        } else if (e instanceof TypeCannotConvertException) {
            ee = (TypeCannotConvertException)e;
            m = SiteNavMessages.format2(SiteNavMessages.WARRN_EL_CANNOTCONVERT, ((TypeCannotConvertException)ee).getSrc(), ((TypeCannotConvertException)ee).getDst());
        } else if (e instanceof CannotCompareException) {
            ee = (CannotCompareException)e;
            m = SiteNavMessages.format2(SiteNavMessages.WARRN_EL_CANNOT_COMP, ((CannotCompareException)ee).getSrc(), ((CannotCompareException)ee).getDst());
        } else {
            m = SiteNavMessages.WARRN_EL_CANNOTEVAL;
            SiteNavBuilderLogger.log(e);
        }
        try {
            r.reportError(1, "com.ibm.etools.siteedit.SiteNavBuilder.navspecmarker", m, false);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }
}

