/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el.impl;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.VariableResolver;
import com.ibm.etools.siteedit.core.internal.el.impl.CourseUtil;
import com.ibm.etools.siteedit.core.internal.el.impl.Evalable;

public class ArithmeticOperator
implements Evalable {
    public static final int OP_PLUS = 1;
    public static final int OP_MINUS = 2;
    public static final int OP_MULTI = 3;
    public static final int OP_DIV = 4;
    public static final int OP_MOD = 5;
    public static final int OP_UNARY_MINUS = 6;
    private Evalable expA;
    private Evalable expB;
    private int operator;

    public ArithmeticOperator(Evalable expA, int operator, Evalable expB) {
        this.expA = expA;
        this.operator = operator;
        this.expB = expB;
    }

    public ArithmeticOperator(int operator, Evalable expA) {
        this.expA = expA;
        this.operator = operator;
    }

    @Override
    public Object eval(VariableResolver env) throws ELErrorException {
        if (this.expB == null) {
            return this.evalUnary(env);
        }
        return this.evalBinary(env);
    }

    private Object evalBinary(VariableResolver env) throws ELErrorException {
        Object valueA = this.expA.eval(env);
        Object valueB = this.expB.eval(env);
        if (valueA == null && valueB == null) {
            return CourseUtil.LONG_ZERO;
        }
        if (this.isDouble(valueA) || this.isDouble(valueB) || this.operator == 4) {
            Double a = CourseUtil.toDouble(valueA);
            Double b = CourseUtil.toDouble(valueB);
            switch (this.operator) {
                case 1: {
                    return new Double(a + b);
                }
                case 2: {
                    return new Double(a - b);
                }
                case 3: {
                    return new Double(a * b);
                }
                case 4: {
                    return new Double(a / b);
                }
                case 5: {
                    return new Double(a % b);
                }
            }
        } else {
            Long a = CourseUtil.toLong(valueA);
            Long b = CourseUtil.toLong(valueB);
            switch (this.operator) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        }
        throw new RuntimeException("Unknown operator in EL Binary Expression:" + this.operator);
    }

    private Object evalUnary(VariableResolver env) throws ELErrorException {
        Object valueA = this.expA.eval(env);
        if (valueA == null) {
            return CourseUtil.LONG_ZERO;
        }
        if (this.isDouble(valueA)) {
            Double a = CourseUtil.toDouble(valueA);
            if (a == CourseUtil.DOUBLE_ZERO) {
                return a;
            }
            return new Double(-a.doubleValue());
        }
        if (valueA instanceof String || valueA instanceof Number) {
            Long a = CourseUtil.toLong(valueA);
            if (a == CourseUtil.LONG_ZERO) {
                return a;
            }
            return new Long(-a.longValue());
        }
        throw new ELErrorException();
    }

    protected boolean isDouble(Object o) {
        if (o instanceof Double) {
            return true;
        }
        if (o instanceof Float) {
            return true;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s.indexOf(46) != -1 || s.indexOf(101) != -1 || s.indexOf(69) != -1;
        }
        return false;
    }
}

