/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.core.internal.el;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.ELParserException;
import com.ibm.etools.siteedit.core.internal.el.VariableResolver;
import com.ibm.etools.siteedit.core.internal.el.impl.CourseUtil;
import com.ibm.etools.siteedit.core.internal.el.impl.ELPartOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.ErrorTool;
import com.ibm.etools.siteedit.core.internal.el.impl.Evalable;
import com.ibm.etools.siteedit.core.internal.el.impl.SemanticTreeMaker;
import com.ibm.etools.siteedit.core.internal.el.impl.StringConcatOperator;
import com.ibm.etools.siteedit.core.internal.el.impl.StringOperator;
import com.ibm.etools.siteedit.core.internal.el.lexer.Lexer;
import com.ibm.etools.siteedit.core.internal.el.node.Start;
import com.ibm.etools.siteedit.core.internal.el.parser.Parser;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterAttrNode;
import com.ibm.etools.siteedit.internal.builder.common.StringUtil;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class Expression {
    private Evalable expression;

    public Expression(String el, ErrorReporter er) {
        this(el, false, er);
    }

    public Expression(String el, boolean escapeExp, ErrorReporter er) {
        try {
            Parser p = new Parser(new Lexer(new PushbackReader(new StringReader(el), 1024)));
            Start tree = p.parse();
            SemanticTreeMaker tr = new SemanticTreeMaker(el, escapeExp, er);
            tree.apply(tr);
            this.expression = tr.getResult();
        }
        catch (ELParserException e) {
            int errorPosFromTagStart = 0;
            int errorLength = el.length();
            if (er instanceof ErrorReporterAttrNode) {
                String attrName = ((ErrorReporterAttrNode)er).getAttrName();
                String tagInnerText = ((ErrorReporterAttrNode)er).getParentReporter().getTagInnerText();
                int attrValuePosFromStartTag = TagParser.getOffsetAttrValue(tagInnerText, attrName);
                int errorPosFromValueStart = StringUtil.getIndexOfTextPos(el, e.getLine() - 1, e.getPos() - 1);
                errorPosFromTagStart = attrValuePosFromStartTag + errorPosFromValueStart;
                errorLength -= errorPosFromValueStart;
            }
            if (er != null) {
                ErrorTool.reportELSyntax(er.getPart(errorPosFromTagStart, errorLength));
            }
            this.expression = new StringOperator(el);
        }
        catch (IOException e) {
            SiteNavBuilderLogger.log("Unexpected IOException occures.");
            SiteNavBuilderLogger.log(e);
            this.expression = new StringOperator(el);
        }
    }

    public Object evaluate(VariableResolver env) throws ELErrorException {
        return this.expression == null ? null : this.expression.eval(env);
    }

    public static Long toLong(Object o) throws ELErrorException {
        return CourseUtil.toLong(o);
    }

    public static Boolean toBoolean(Object o) throws ELErrorException {
        return CourseUtil.toBoolean(o);
    }

    public static String toString(Object o) throws ELErrorException {
        return CourseUtil.toString(o);
    }

    public static boolean isComposed(Expression e) {
        return e.expression instanceof StringConcatOperator;
    }

    public static List getItems(Expression exp) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (Expression.isComposed(exp)) {
            StringConcatOperator o = (StringConcatOperator)exp.expression;
            for (Evalable e : o.exps) {
                result.add(Expression.getInnerObject(e));
            }
        } else {
            result.add(Expression.getInnerObject(exp.expression));
        }
        return result;
    }

    private static Object getInnerObject(Evalable e) {
        Object toAdd = null;
        toAdd = e instanceof StringOperator ? ((StringOperator)e).toString() : (e instanceof ELPartOperator ? ((ELPartOperator)e).exp : e);
        return toAdd;
    }
}

