/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class StringUtils {
    public static List split(String s, char sep) {
        ArrayList<String> a = new ArrayList<String>();
        if (s != null) {
            int p1;
            int p = 0;
            while ((p1 = s.indexOf(sep, p)) >= 0) {
                a.add(s.substring(p, p1).trim());
                p = p1 + 1;
            }
            a.add(s.substring(p));
        }
        return a;
    }

    public static List split(String s, char sep, char sep2) {
        ArrayList<List> a = new ArrayList<List>();
        List splitted = StringUtils.split(s, sep2);
        int i = 0;
        while (i < splitted.size()) {
            String t = (String)splitted.get(i);
            a.add(StringUtils.split(t, sep));
            ++i;
        }
        return a;
    }

    public static String removeBlankLines(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer smartText = new StringBuffer();
        char[] ca = text.toCharArray();
        boolean nonblank = false;
        int soln = 0;
        int i = 0;
        while (i < ca.length) {
            char c = ca[i];
            if (c == '\n') {
                if (nonblank && i >= soln) {
                    smartText.append(ca, soln, i - soln + 1);
                }
                soln = i + 1;
                nonblank = false;
            } else if (" \t\r\n".indexOf(c) < 0) {
                nonblank = true;
            }
            ++i;
        }
        if (nonblank && soln < ca.length) {
            smartText.append(ca, soln, ca.length - soln);
        }
        return smartText.toString();
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s)) {
            return false;
        }
        return defaultValue;
    }

    public static int getInteger(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static int getInteger(String s, int minValue, int maxValue, int defaultValue) {
        return Math.min(Math.max(minValue, StringUtils.getInteger(s, defaultValue)), maxValue);
    }

    public static int getArrayIndex(String s, String[] array, int defaultIndex) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return defaultIndex;
    }

    public static String getColor(String color, String defaultColor) {
        try {
            Color.decode(color);
            return color;
        }
        catch (Exception exception) {
            return defaultColor;
        }
    }
}

