/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.core;

import com.ibm.etools.siteedit.sitelib.core.Connector;
import com.ibm.etools.siteedit.sitelib.core.Fragment;
import com.ibm.etools.siteedit.sitelib.core.Group;
import com.ibm.etools.siteedit.sitelib.core.Link;
import com.ibm.etools.siteedit.sitelib.core.Page;
import com.ibm.etools.siteedit.sitelib.core.PageLink;
import com.ibm.etools.siteedit.sitelib.core.SiteItem;
import com.ibm.etools.siteedit.sitelib.core.SiteNode;
import com.ibm.etools.siteedit.sitelib.core.io.SiteFileReader;
import com.ibm.etools.siteedit.sitelib.core.io.SiteFileWriter;
import com.ibm.etools.siteedit.sitelib.util.SitelibConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Site
implements SitelibConstants {
    private SiteFileReader config;
    private List tree;
    private Map fragment;
    private Map connector;
    private Map group;

    public static Site loadSite(SiteFileReader config) {
        Document document = config.loadDocument();
        Site site = new Site(config);
        if (document == null) {
            return site;
        }
        Node node = document.getDocumentElement();
        while (node != null) {
            if (node.getNodeType() != 1) {
                node = node.getNextSibling();
                continue;
            }
            String nodeName = node.getNodeName();
            if ("website".equals(nodeName) || "structure".equals(nodeName)) {
                node = node.getFirstChild();
                continue;
            }
            if ("webproject".equals(nodeName)) {
                Element elm = (Element)node;
                Fragment f = new Fragment(elm);
                Node n = node.getFirstChild();
                while (n != null) {
                    SiteNode tree;
                    if (n.getNodeType() == 1 && (tree = Site.createPageTree(site, n)) != null) {
                        f.add(tree);
                    }
                    n = n.getNextSibling();
                }
                site.addFragment(elm.getAttribute("src"), f);
            } else {
                SiteNode tree = Site.createPageTree(site, node);
                if (tree != null) {
                    site.addTree(tree);
                }
            }
            node = node.getNextSibling();
        }
        if (!site.isEmpty()) {
            Site.fixupPageLink(site);
        }
        return site;
    }

    private static SiteNode createPageTree(Site site, Node node) {
        SiteNode tree = null;
        Element e = (Element)node;
        String nodeName = e.getNodeName();
        if ("page".equals(nodeName)) {
            e.setAttribute("src", site.config.convertSrc(e.getAttribute("src")));
            tree = new Page(e);
        } else if ("pagelink".equals(nodeName)) {
            tree = new PageLink(e);
        } else if ("link".equals(nodeName)) {
            tree = new Link(e);
        } else if ("group".equals(nodeName)) {
            Group g = new Group(e);
            site.addGroup(g);
            tree = g;
        } else {
            if ("webproject".equals(nodeName)) {
                Connector conn = new Connector(e);
                site.addConnector(conn);
                return conn;
            }
            return null;
        }
        if (node.hasChildNodes()) {
            Node n = node.getFirstChild();
            while (n != null) {
                SiteNode subtree;
                if (n.getNodeType() == 1 && (subtree = Site.createPageTree(site, n)) != null) {
                    tree.add(subtree);
                }
                n = n.getNextSibling();
            }
        }
        return tree;
    }

    private static void fixupPageLink(Site site) {
        HashMap<String, SiteNode> target = new HashMap<String, SiteNode>();
        HashSet<SiteNode> referer = new HashSet<SiteNode>();
        Iterator iter = site.tree.iterator();
        while (iter.hasNext()) {
            SiteNode tree = (SiteNode)iter.next();
            Enumeration<TreeNode> enumer = tree.depthFirstEnumeration();
            while (enumer.hasMoreElements()) {
                SiteNode node = (SiteNode)enumer.nextElement();
                String nid = node.nid;
                if (nid != null && nid.length() > 0) {
                    target.put(nid, node);
                }
                if (!(node instanceof PageLink)) continue;
                referer.add(node);
            }
        }
        iter = referer.iterator();
        while (iter.hasNext()) {
            Page p;
            PageLink pl = (PageLink)iter.next();
            String ref = pl.getRef();
            if (ref == null || (p = (Page)target.get(ref)) == null) continue;
            SiteItem pli = pl.getItem();
            SiteItem pi = p.getItem();
            pli.href = pi.href;
            if (!pl.isSynclabel()) continue;
            pli.label = pi.label;
        }
    }

    public boolean saveSite(SiteFileWriter config) {
        Document document = config.newDocument();
        if (document == null) {
            return false;
        }
        Element website = document.createElement("website");
        website.setAttribute("version", "700");
        document.appendChild(website);
        Element structure = document.createElement("structure");
        website.appendChild(structure);
        if (this.tree != null) {
            Iterator iter = this.tree.iterator();
            while (iter.hasNext()) {
                SiteNode page = (SiteNode)iter.next();
                if (this.isFragment(page)) continue;
                structure.appendChild(this.createDomTree(document, page));
            }
        }
        return config.saveDocument(document);
    }

    private Node createDomTree(Document document, SiteNode snode) {
        Element node = document.createElement(snode.name);
        Map attrs = snode.getAttributes();
        if (attrs != null) {
            Iterator iter = attrs.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)attrs.get(key);
                if ("title".equals(key)) {
                    Element title = document.createElement("title");
                    title.appendChild(document.createTextNode(value));
                    node.appendChild(title);
                    continue;
                }
                node.setAttribute(key, value);
            }
        }
        Enumeration<TreeNode> enumer = snode.children();
        while (enumer.hasMoreElements()) {
            SiteNode n = (SiteNode)enumer.nextElement();
            node.appendChild(this.createDomTree(document, n));
        }
        return node;
    }

    private Site(SiteFileReader config) {
        this.config = config;
    }

    void addTree(SiteNode root) {
        if (this.tree == null) {
            this.tree = new ArrayList();
        }
        this.tree.add(root);
    }

    public boolean isEmpty() {
        return this.tree == null || this.tree.size() == 0;
    }

    void addConnector(Connector conn) {
        if (this.connector == null) {
            this.connector = new HashMap();
        }
        this.connector.put(conn.getTarget(), conn);
    }

    Connector getConnector(String name) {
        if (this.connector == null) {
            return null;
        }
        return (Connector)this.connector.get(name);
    }

    void addGroup(Group g) {
        if (this.group == null) {
            this.group = new HashMap();
        }
        this.group.put(g.getGroupId(), g);
    }

    public Map getGroups() {
        return this.group;
    }

    public Group getGroup(String gid) {
        if (this.group == null) {
            return null;
        }
        return (Group)this.group.get(gid);
    }

    public void expand() {
        if (this.tree == null) {
            return;
        }
        int i = 0;
        while (i < this.tree.size()) {
            this.tree.set(i, this.expand((SiteNode)this.tree.get(i)));
            ++i;
        }
    }

    SiteNode expand(SiteNode p) {
        this.fixupConnector();
        if (this.isFragment(p)) {
            Site owner = Site.loadSite(this.config.newInstance(this.getFragmentOwner(p)));
            if (owner == null) {
                return p;
            }
            Connector c = owner.getConnector(this.config.getName());
            if (c == null || c.isRoot()) {
                return p;
            }
            this.fragment.remove(p.getItem().src);
            SiteNode parent = (SiteNode)c.getParent();
            this.setChildren(parent, parent.getIndex(c), p.children());
            c.removeFromParent();
            owner.connector.remove(c);
            this.fixupConnector();
            p = owner.expand((SiteNode)parent.getRoot());
        }
        return p;
    }

    void fixupConnector() {
        if (this.connector == null) {
            return;
        }
        Iterator iter = this.connector.values().iterator();
        while (iter.hasNext()) {
            SiteNode f;
            Connector c = (Connector)iter.next();
            SiteNode parent = (SiteNode)c.getParent();
            if (parent == null) continue;
            Site subsite = Site.loadSite(this.config.newInstance(c.getTarget()));
            if (subsite != null && (f = subsite.getFragment(this.config.getName())) != null) {
                subsite.fixupConnector();
                this.setChildren(parent, parent.getIndex(c), f.children());
            }
            c.removeFromParent();
        }
        this.connector.clear();
    }

    public void transform() {
        if (this.tree == null) {
            return;
        }
        int i = 0;
        while (i < this.tree.size()) {
            SiteNode top = (SiteNode)this.tree.get(i);
            this.tree.remove(i);
            List l = this.transform(top);
            this.tree.addAll(i, l);
            i += l.size();
        }
    }

    List transform(SiteNode p) {
        ArrayList<SiteNode> l = new ArrayList<SiteNode>();
        Enumeration<TreeNode> enumer = p.children();
        while (enumer.hasMoreElements()) {
            SiteNode c = (SiteNode)enumer.nextElement();
            l.addAll(this.transform(c));
        }
        if (p instanceof Group) {
            ((Group)p).notifyTransform();
            p.removeAllChildren();
            l.add(0, p);
        } else {
            this.setChildren(p, l);
            l.clear();
            l.add(p);
        }
        return l;
    }

    void setChildren(SiteNode p, Collection c) {
        p.removeAllChildren();
        this.setChildren(p, 0, c);
    }

    void setChildren(SiteNode p, int index, Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            p.insert((SiteNode)iter.next(), index++);
        }
    }

    void setChildren(SiteNode p, int index, Enumeration enumer) {
        ArrayList l = new ArrayList();
        while (enumer.hasMoreElements()) {
            l.add(enumer.nextElement());
        }
        this.setChildren(p, index, l);
    }

    public SiteNode findPage(String uri) {
        if (this.tree == null) {
            return null;
        }
        Iterator iter = this.tree.iterator();
        while (iter.hasNext()) {
            SiteNode tree = (SiteNode)iter.next();
            Enumeration<TreeNode> enumer = tree.preorderEnumeration();
            while (enumer.hasMoreElements()) {
                SiteNode p = (SiteNode)enumer.nextElement();
                if (!uri.equals(p.getItem().src)) continue;
                return p;
            }
        }
        return null;
    }

    public SiteNode findRoot(SiteNode node) {
        if (this.tree == null) {
            return null;
        }
        if (node != null) {
            return (SiteNode)node.getRoot();
        }
        int i = 0;
        while (i < this.tree.size()) {
            if (((SiteNode)this.tree.get(i)).isEntityNode()) {
                return (SiteNode)this.tree.get(i);
            }
            ++i;
        }
        return null;
    }

    public SiteNode findNavRoot(SiteNode node) {
        if (node != null) {
            while (!node.getItem().navroot && !node.isRoot()) {
                node = (SiteNode)node.getParent();
            }
            return node;
        }
        return this.findRoot(node);
    }

    void addFragment(String name, SiteNode p) {
        this.addTree(p);
        if (this.fragment == null) {
            this.fragment = new HashMap();
        }
        this.fragment.put(name, p);
    }

    SiteNode getFragment(String name) {
        if (this.fragment == null) {
            return null;
        }
        return (SiteNode)this.fragment.get(name);
    }

    boolean isFragment(SiteNode p) {
        if (this.fragment == null) {
            return false;
        }
        return this.fragment.containsValue(p);
    }

    String getFragmentOwner(SiteNode p) {
        if (this.fragment == null) {
            return null;
        }
        Iterator iter = this.fragment.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!this.fragment.get(key).equals(p)) continue;
            return key.toString();
        }
        return null;
    }
}

