/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.core;

import com.ibm.etools.siteedit.sitelib.core.SiteItem;
import com.ibm.etools.siteedit.sitelib.core.SiteNode;
import com.ibm.etools.siteedit.sitelib.util.StringUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class Group
extends SiteNode {
    private static final long serialVersionUID = -3951213292693060493L;
    private String gid;
    private int depth;
    private List gc = null;

    Group(Element elm) {
        super(elm);
        this.gid = elm.getAttribute("gid");
        this.depth = StringUtils.getInteger(elm.getAttribute("depth"), 0);
        SiteItem item = new SiteItem(elm, this);
        item.group = true;
        this.setItem(item);
    }

    public boolean isEntityNode() {
        return false;
    }

    String getGroupId() {
        return this.gid;
    }

    protected Map getAttributes() {
        Map attrs = super.getAttributes();
        if (this.gid != null && this.gid.length() > 0) {
            attrs.put("gid", this.gid);
        }
        if (this.depth > 0) {
            attrs.put("depth", String.valueOf(this.depth));
        }
        attrs.putAll(this.getItem().getAttributes());
        return attrs;
    }

    public List getMembers() {
        return this.getMembers(this.depth);
    }

    public List getMembers(int depth) {
        ArrayList list = new ArrayList();
        Members enumer = new Members(this, depth);
        while (enumer.hasMoreElements()) {
            list.add(enumer.nextElement());
        }
        return list;
    }

    void notifyTransform() {
        if (this.children != null) {
            if (this.gc == null) {
                this.gc = new ArrayList();
            }
            this.gc.addAll(this.children);
        }
    }

    private static class Members
    implements Enumeration {
        Group g;
        SiteNode current;
        int maxLevel;
        List gc;

        Members(Group g) {
            this(g, g.depth);
        }

        Members(Group g, int depth) {
            this.g = g;
            this.current = this.g;
            this.gc = null;
            this.maxLevel = depth == 0 ? Integer.MAX_VALUE : g.getLevel() + depth - 1;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            SiteNode n = this.current;
            if (this.current != null) {
                if (this.current.getLevel() == this.g.getLevel() && this.current instanceof Group && ((Group)this.current).gc != null) {
                    if (this.gc == null) {
                        this.gc = new ArrayList();
                    }
                    this.gc.addAll(0, ((Group)this.current).gc);
                }
                this.current = this.current.getChildCount() > 0 && this.current.getLevel() < this.maxLevel ? (SiteNode)this.current.getFirstChild() : (this.current.getLevel() > this.g.getLevel() && this.current.getNextSibling() != null ? (SiteNode)this.current.getNextSibling() : (this.current.getLevel() == this.g.getLevel() && this.gc != null && !this.gc.isEmpty() ? (SiteNode)this.gc.remove(0) : (this.current.getLevel() > this.g.getLevel() + 1 ? this.getNonNullRelative(this.current) : (this.current.getLevel() == this.g.getLevel() + 1 && this.gc != null && !this.gc.isEmpty() ? (SiteNode)this.gc.remove(0) : null))));
            }
            return n;
        }

        private SiteNode getNonNullRelative(SiteNode currentNode) {
            int currentLevel = currentNode.getLevel();
            int groupLevel = this.g.getLevel();
            SiteNode currentParent = (SiteNode)this.current.getParent();
            do {
                SiteNode node;
                if ((node = (SiteNode)currentParent.getNextSibling()) != null) {
                    return node;
                }
                currentParent = (SiteNode)currentParent.getParent();
                if (--currentLevel != groupLevel + 1 || this.gc == null || this.gc.isEmpty()) continue;
                node = (SiteNode)this.gc.remove(0);
                return node;
            } while (currentLevel != groupLevel);
            return null;
        }
    }
}

