/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.bean;

import com.ibm.etools.siteedit.sitelib.bean.SiteNavGroup;
import com.ibm.etools.siteedit.sitelib.bean.SiteNavItem;
import com.ibm.etools.siteedit.sitelib.core.Group;
import com.ibm.etools.siteedit.sitelib.core.Site;
import com.ibm.etools.siteedit.sitelib.core.SiteNode;
import com.ibm.etools.siteedit.sitelib.util.SitelibConstants;
import com.ibm.etools.siteedit.sitelib.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SiteNavBean
implements SitelibConstants {
    private final Site site;
    private final SiteNavItem[] items;
    private final Collection tops;
    private final String separator;
    private final String start;
    private final String end;
    private final List navtabImgs;
    private final List navtabSelImgs;
    private final List navtabImgSize;
    private final List navtabSelImgSize;
    private final String navClass;
    private final String navStyle;
    private final String userData;
    private final Map restore;

    public SiteNavBean(Site site, SiteNavItem[] items, Collection tops, Map nav, Map restore) {
        this.site = site;
        this.items = items;
        this.tops = tops;
        this.separator = (String)nav.get("separator");
        this.start = (String)nav.get("start");
        this.end = (String)nav.get("end");
        this.navtabImgs = StringUtils.split((String)nav.get("img"), '|');
        this.navtabImgSize = StringUtils.split((String)nav.get("imgsize"), ',', '|');
        this.navtabSelImgs = StringUtils.split((String)nav.get("imgsel"), '|');
        this.navtabSelImgSize = StringUtils.split((String)nav.get("imgselsize"), ',', '|');
        this.navStyle = (String)nav.get("navstyle");
        this.navClass = (String)nav.get("navclass");
        this.userData = (String)nav.get("uservalue");
        this.restore = restore;
    }

    public void dispose() {
        if (this.restore != null) {
            Iterator iter = this.restore.keySet().iterator();
            while (iter.hasNext()) {
                SiteNode node = (SiteNode)iter.next();
                SiteNode parent = (SiteNode)node.getParent();
                parent.insert(node, (Integer)this.restore.get(node));
            }
        }
    }

    public Object getItems() {
        return this.items;
    }

    public Object getTops() {
        return this.tops;
    }

    public int getTopcount() {
        return this.tops != null ? this.tops.size() : 0;
    }

    public Map getGroups() {
        HashMap map = new HashMap();
        Iterator iter = this.site.getGroups().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            map.put(e.getKey(), new SiteNavGroup((Group)e.getValue()));
        }
        return map;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public Object getNavtabImg() {
        return this.navtabImgs;
    }

    public Object getNavtabImgSize() {
        return this.navtabImgSize;
    }

    public Object getNavtabSelImg() {
        return this.navtabSelImgs;
    }

    public Object getNavtabSelImgSize() {
        return this.navtabSelImgSize;
    }

    public Object getUserData() {
        return this.userData;
    }

    public String getNavclass() {
        return this.navClass;
    }

    public String getNavstyle() {
        return this.navStyle;
    }
}

