/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.refactoring.processor;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.refactoring.processor.FileTextRange;
import com.ibm.etools.references.refactoring.processor.RenameTextRangeProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;

public final class UpdateTextRangeDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.ltk.core.refactoring.rename.actionMapping";
    private boolean fUpdateReferences;
    private String fNewName;
    private FileTextRange fTextRange;
    private IFile fFile;
    private String fOldText;
    private final RenameTextRangeProcessor renameProcessor;

    public UpdateTextRangeDescriptor(RenameTextRangeProcessor procesor) {
        super(ID, null, Messages.UpdateTextRangeDescriptor_UnnamedDescription, null, 6);
        this.renameProcessor = procesor;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        IFile file = this.getFile();
        if (file == null) {
            status.addFatalError(Messages.UpdateTextRangeDescriptor_FileNotSet);
            return null;
        }
        FileTextRange range = this.getTextRange();
        if (range == null) {
            status.addFatalError(Messages.UpdateTextRangeDescriptor_RangeNotSet);
            return null;
        }
        String name = this.getNewName();
        if (name == null || name.length() == 0) {
            status.addFatalError(Messages.UpdateTextRangeDescriptor_NewNameNotSet);
            return null;
        }
        this.renameProcessor.setOldText(this.fOldText);
        this.renameProcessor.setTextRange(this.fTextRange);
        this.renameProcessor.setNewName(name);
        this.renameProcessor.setUpdateReferences(this.isUpdateReferences());
        return new RenameRefactoring((RenameProcessor)this.renameProcessor);
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public void setNewName(String newName) {
        this.fNewName = newName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setFile(IFile file) {
        this.fFile = file;
    }

    public void setTextRange(FileTextRange range) {
        this.fTextRange = range;
    }

    public IFile getFile() {
        return this.fFile;
    }

    public FileTextRange getTextRange() {
        return this.fTextRange;
    }

    public void setOldText(String oldText) {
        this.fOldText = oldText;
    }
}

