/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.refactoring.processor;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.refactoring.processor.FileTextRange;
import com.ibm.etools.references.refactoring.processor.UpdateTextRangeDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class UpdateTextRangeChange
extends ResourceChange {
    private RefactoringChangeDescriptor refactoringChangeDescriptor;
    private final IFile fFile;
    private final String fNewResourceName;

    public UpdateTextRangeChange(String newResourceName, IFile file) {
        this.fNewResourceName = newResourceName;
        this.fFile = file;
    }

    protected IResource getModifiedResource() {
        return this.fFile;
    }

    public String getName() {
        return this.fNewResourceName;
    }

    private UpdateTextRangeDescriptor getUpdateDescriptor() {
        return (UpdateTextRangeDescriptor)this.refactoringChangeDescriptor.getRefactoringDescriptor();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        FileTextRange range = this.getUpdateDescriptor().getTextRange();
        TextFileChange change = new TextFileChange(Messages.update_file, this.fFile);
        ReplaceEdit edit = new ReplaceEdit(range.getOffset(), range.getLength(), this.fNewResourceName);
        change.setEdit((TextEdit)edit);
        return change.perform(pm);
    }

    public void setDescriptor(RefactoringChangeDescriptor refactoringChangeDescriptor) {
        this.refactoringChangeDescriptor = refactoringChangeDescriptor;
    }
}

