/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.refactoring.processor;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.refactoring.processor.FileTextRange;
import com.ibm.etools.references.refactoring.processor.UpdateTextRangeDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class RenameTextRangeProcessor
extends RenameProcessor {
    private FileTextRange fRange;
    private RenameArguments fRenameArgs;
    private String fNewName;
    private boolean fUpdateReferences;
    private String fOldText;

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            this.fRenameArgs = new RenameArguments(this.getNewName(), this.isUpdateReferences());
            IFile file = this.getFile();
            if (file != null) {
                ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
                IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
                deltaFactory.change(file);
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected String getNewName() {
        return this.fNewName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    protected UpdateTextRangeDescriptor createDescriptor() {
        IFile file = this.getFile();
        UpdateTextRangeDescriptor descriptor = new UpdateTextRangeDescriptor(this);
        descriptor.setProject(file.getProject().getName());
        descriptor.setFile(file);
        descriptor.setTextRange(this.fRange);
        descriptor.setOldText(this.fOldText);
        descriptor.setDescription(NLS.bind((String)Messages.renameLinkX, (Object)this.getOldText()));
        descriptor.setComment(NLS.bind((String)Messages.renameLinkFromXtoY, (Object[])new String[]{this.getOldText(), this.getNewName()}));
        descriptor.setFlags(7);
        descriptor.setNewName(this.getNewName());
        descriptor.setUpdateReferences(this.isUpdateReferences());
        return descriptor;
    }

    public String getOldText() {
        return this.fOldText;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            UpdateTextRangeDescriptor descriptor = this.createDescriptor();
            FileTextRange range = descriptor.getTextRange();
            MultiTextEdit edit = new MultiTextEdit();
            ReplaceEdit replaceEdit = new ReplaceEdit(range.getOffset(), range.getLength(), this.getNewName());
            edit.addChild((TextEdit)replaceEdit);
            TextFileChange change = new TextFileChange(descriptor.getDescription(), this.getFile());
            change.setEdit((TextEdit)edit);
            TextFileChange textFileChange = change;
            return textFileChange;
        }
        finally {
            pm.done();
        }
    }

    public FileTextRange getRange() {
        return this.fRange;
    }

    public Object[] getElements() {
        return new Object[]{this.getRange()};
    }

    public abstract String getIdentifier();

    public abstract String getProcessorName();

    public boolean isApplicable() throws CoreException {
        if (this.fRange.getFile() == null) {
            return false;
        }
        if (!this.fRange.getFile().exists()) {
            return false;
        }
        return this.fRange.getFile().isAccessible();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        String[] natures = new String[]{};
        IFile file = this.getFile();
        if (file != null) {
            natures = file.getProject().getDescription().getNatureIds();
        }
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.fRange, (RenameArguments)this.fRenameArgs, (String[])natures, (SharableParticipants)sharedParticipants);
    }

    public IFile getFile() {
        return this.fRange.getFile();
    }

    public void setNewName(String newName) {
        this.fNewName = newName;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public boolean isUpdateReferences() {
        return this.fUpdateReferences;
    }

    public RefactoringStatus validateNewElementName(String text) {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public void setOldText(String oldText) {
        this.fOldText = oldText;
    }

    public void setTextRange(FileTextRange textRange) {
        this.fRange = textRange;
    }
}

