/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.management;

import com.ibm.etools.references.internal.bplustree.db.Persistable;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import org.eclipse.core.runtime.Assert;

public final class TextRange
implements Persistable {
    public static final TextRange EMPTY = new TextRange(0, 0, 1);
    private int offset;
    private int length;
    private int linenumber;

    public TextRange(int offset, int length, int linenumber) {
        Assert.isLegal((offset >= 0 ? 1 : 0) != 0, (String)"Offset must be positive");
        Assert.isLegal((offset >= 0 ? 1 : 0) != 0, (String)"Offset must be positive");
        Assert.isLegal((offset >= 0 ? 1 : 0) != 0, (String)"Offset must be positive");
        this.offset = offset;
        this.length = length;
        this.linenumber = linenumber;
    }

    public boolean contains(int point) {
        return point >= this.offset && point <= this.offset + this.length;
    }

    public boolean contains(TextRange fragmentLocation) {
        return this.contains(fragmentLocation.getOffset()) && this.contains(fragmentLocation.getOffset() + fragmentLocation.getLength());
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getLinenumber() {
        return this.linenumber;
    }

    public TextRange copy() {
        return new TextRange(this.offset, this.length, this.linenumber);
    }

    static int storageSize() {
        return 6;
    }

    @Override
    public PooledByteBuffer writeRecord() {
        PooledByteBuffer bytes = PooledByteBuffer.INSTANCE.leaseByteBuffer(6);
        bytes.buffer.put(ByteUtils.unsignedShortToBytes(this.offset));
        bytes.buffer.put(ByteUtils.unsignedShortToBytes(this.length));
        bytes.buffer.put(ByteUtils.unsignedShortToBytes(this.linenumber));
        bytes.buffer.rewind();
        return bytes;
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        this.offset = ByteUtils.bytesToUnsignedShort(bytes.buffer);
        this.length = ByteUtils.bytesToUnsignedShort(bytes.buffer);
        this.linenumber = ByteUtils.bytesToUnsignedShort(bytes.buffer);
        bytes.returnBuffer();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.linenumber;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextRange other = (TextRange)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.linenumber != other.linenumber) {
            return false;
        }
        return this.offset == other.offset;
    }

    public String toString() {
        return "Range: [Offset: " + this.offset + ", Length: " + this.length + ", Line Number: " + this.linenumber + "]";
    }

    public boolean intersets(TextRange range) {
        if (range == null) {
            return false;
        }
        int end = this.offset + this.length;
        return range.contains(this.offset) || range.contains(end);
    }
}

