/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class SortedSetFromSortedList<T extends Comparable<? super T>>
extends AbstractSet<T>
implements SortedSet<T> {
    private final List<T> sortedList;
    private final Comparator<T> comparator;

    public SortedSetFromSortedList(List<T> sortedList) {
        this.sortedList = sortedList;
        this.comparator = null;
    }

    public SortedSetFromSortedList(List<T> sortedList, Comparator<T> comparator) {
        this.sortedList = sortedList;
        this.comparator = comparator;
    }

    @Override
    public Iterator<T> iterator() {
        return this.sortedList.iterator();
    }

    @Override
    public int size() {
        return this.sortedList.size();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    @Override
    public T first() {
        return (T)((Comparable)this.sortedList.get(0));
    }

    @Override
    public boolean contains(Object o) {
        try {
            Comparable o2 = (Comparable)o;
            if (this.comparator == null) {
                int location = Collections.binarySearch(this.sortedList, o2);
                return location >= 0;
            }
            int location = Collections.binarySearch(this.sortedList, o2, this.comparator);
            return location >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T last() {
        return (T)((Comparable)this.sortedList.get(this.sortedList.size() - 1));
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        throw new UnsupportedOperationException();
    }
}

