/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.InternalToken;
import com.ibm.etools.references.internal.services.Dependency;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.services.providers.CheckedReferenceRename;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider;
import com.ibm.etools.references.services.providers.IReferenceResolverProvider2;
import com.ibm.etools.references.services.providers.RefactoringResolverParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PerformanceStats;

public final class ReferenceResolverService
extends Service<IReferenceResolverProvider> {
    private static ReferenceResolverService service = null;

    public static final synchronized ReferenceResolverService getInstance() {
        if (service == null) {
            service = new ReferenceResolverService();
            service.configureProviders("com.ibm.etools.references", "referenceResolverProvider");
        }
        return service;
    }

    @Override
    protected Service.ProviderDescriptor<IReferenceResolverProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new ReferenceResolverProviderDescriptor(configurationElement);
    }

    @Override
    protected boolean hasUniqueIds() {
        return true;
    }

    private ReferenceResolverProviderDescriptor findApplicableProvider(Reference reference) {
        List descriptors = this.getAllProviders();
        for (ReferenceResolverProviderDescriptor referenceResolverProviderDescriptor : descriptors) {
            if (!referenceResolverProviderDescriptor.isApplicable(reference)) continue;
            return referenceResolverProviderDescriptor;
        }
        return null;
    }

    public int getApplicableProviderId(Reference reference) {
        ReferenceResolverProviderDescriptor desc = this.findApplicableProvider(reference);
        if (desc == null) {
            Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "No resolver found for reference of type: " + reference.getReferenceType());
            return -1;
        }
        return desc.getTypeId();
    }

    public IResolvedReference resolveReference(final Reference reference, final IResolvedReference previousResult, final IProgressMonitor monitor) throws ReferenceException {
        final ReferenceResolverProviderDescriptor desc = this.findApplicableProvider(reference);
        if (desc == null) {
            Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "No resolver found for reference of type: " + reference.getReferenceType());
            return null;
        }
        final IReferenceResolverProvider resolverProvider = (IReferenceResolverProvider)desc.getProvider();
        if (resolverProvider != null && desc.getId() != null) {
            final ReferenceElementFactory factory = new ReferenceElementFactory(-1, desc.getTypeId(), null, false, InternalToken.TOKEN);
            IResolvedReference r = SafeRun.run(resolverProvider, new SafeRun.IRunnableWithResult<IResolvedReference>(){

                @Override
                public IResolvedReference run() throws Exception {
                    PerformanceStats stats = null;
                    try {
                        String output;
                        if (Logger.PERF_RESOLVER_ENABLED) {
                            stats = PerformanceStats.getStats((String)"com.ibm.etools.references/perf/resolver", (Object)this);
                            stats.startRun("Source " + reference.getSource().getPath() + " " + reference.getSource().getLinkText() + " " + desc.getId().toString());
                        }
                        IResolvedReference r = null;
                        r = resolverProvider instanceof IReferenceResolverProvider2 ? ((IReferenceResolverProvider2)resolverProvider).resolveReference(factory, reference, previousResult, monitor) : resolverProvider.resolveReference(factory, reference, previousResult);
                        if (r == null) {
                            output = "Source=" + reference.getSource() + ", Reference=" + reference;
                            Assert.isNotNull((Object)r, (String)("API violation: Resolver provider contribution must return a value. [" + output + "]"));
                        }
                        if (r.getBrokenStatus() == BrokenStatus.NOTBROKEN) {
                            if (r.getModelInstanceIdReference() != null) {
                                output = "Source=" + reference.getSource() + ", Reference=" + reference;
                                Assert.isTrue((boolean)false, (String)("API violation: When a resolved reference is not broken, model instance ref must be null. [" + output + "]"));
                            }
                        } else if (r.getBrokenStatus() == BrokenStatus.BROKEN && r.getModelInstanceIdReference() == null) {
                            output = "Source=" + reference.getSource() + ", Reference=" + reference;
                            Assert.isTrue((boolean)false, (String)("API violation: When a resolved reference is broken, model instance ref must not be null. [" + output + "]"));
                        }
                        IResolvedReference iResolvedReference = r;
                        return iResolvedReference;
                    }
                    finally {
                        if (stats != null) {
                            stats.endRun();
                        }
                    }
                }
            });
            return r;
        }
        return null;
    }

    public Map<String, Object> renameReference(final RefactoringResolverParameters params) {
        final IReferenceResolverProvider provider = (IReferenceResolverProvider)params.resolvedReference.getAdapter(IReferenceResolverProvider.class);
        if (provider == null) {
            return null;
        }
        Map<String, Object> cr = SafeRun.run(provider, new SafeRun.IRunnableWithResult<Map<String, Object>>(){

            @Override
            public Map<String, Object> run() throws Exception {
                Map<String, Object> paramMap = provider.renameReference(params);
                Assert.isNotNull(paramMap);
                return paramMap;
            }
        });
        return cr;
    }

    public Map<Dependency, List<String>> getDependentReferenceType(String dependentLinkId) {
        HashMap<Dependency, List<String>> depTypes = new HashMap<Dependency, List<String>>();
        List descriptors = this.getAllProviders();
        for (ReferenceResolverProviderDescriptor referenceResolverProviderDescriptor : descriptors) {
            Map<Dependency, List<String>> deps = referenceResolverProviderDescriptor.getDependentReferenceType(dependentLinkId);
            depTypes.putAll(deps);
        }
        return depTypes;
    }

    public String getBrokenLinkInfo(final Reference reference) {
        String info = null;
        ReferenceResolverProviderDescriptor desc = this.findApplicableProvider(reference);
        if (desc != null) {
            final IReferenceResolverProvider resolverProvider = (IReferenceResolverProvider)desc.getProvider();
            info = SafeRun.run(resolverProvider, new SafeRun.IRunnableWithResult<String>(){

                @Override
                public String run() throws Exception {
                    String info = resolverProvider.getModelInstanceIdReference(reference);
                    Assert.isNotNull((Object)info, (String)"API violation: Broken link info can not be null");
                    return info;
                }
            });
        }
        return info;
    }

    public CheckedReferenceRename checkRenameReference(final RefactoringResolverParameters params) {
        final IReferenceResolverProvider provider = (IReferenceResolverProvider)params.resolvedReference.getAdapter(IReferenceResolverProvider.class);
        if (provider == null) {
            return null;
        }
        CheckedReferenceRename cr = SafeRun.run(provider, new SafeRun.IRunnableWithResult<CheckedReferenceRename>(){

            @Override
            public CheckedReferenceRename run() throws Exception {
                CheckedReferenceRename rr = provider.checkRenameReference(params);
                Assert.isNotNull((Object)rr);
                return rr;
            }
        });
        return cr;
    }

    public int getProviderId(String refResolverId) {
        List descriptors = this.getAllProviders();
        for (Service.ProviderDescriptor providerDescriptor : descriptors) {
            if (!providerDescriptor.getId().getLocalName().equals(refResolverId)) continue;
            return providerDescriptor.getTypeId();
        }
        return -1;
    }

    public String getRefResolverId(int refResolverId) {
        List descriptors = this.getAllProviders();
        for (Service.ProviderDescriptor providerDescriptor : descriptors) {
            if (providerDescriptor.getTypeId() != refResolverId) continue;
            return String.valueOf(providerDescriptor.getId().getQualifier()) + "." + providerDescriptor.getId().getLocalName();
        }
        return null;
    }

    public Set<String> getTriggeredReferenceTypes(String triggerPoint, Map<String, String> arguments) {
        HashSet<String> triggeredRefs = new HashSet<String>();
        List provs = this.getAllProviders();
        for (Service.ProviderDescriptor providerDescriptor : provs) {
            ReferenceResolverProviderDescriptor genDesc = (ReferenceResolverProviderDescriptor)providerDescriptor;
            triggeredRefs.addAll(genDesc.getTriggeredReferenceTypes(triggerPoint, arguments));
        }
        return triggeredRefs;
    }

    public class ReferenceResolverProviderDescriptor
    extends Service.ProviderDescriptor<IReferenceResolverProvider> {
        Map<String, Dependency> resolvableDeps;
        Map<String, Map<Dependency, List<String>>> reverseMap;

        public ReferenceResolverProviderDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        public List<String> getResolvableNodeTypes(Reference reference) {
            ArrayList<String> resolvableNodeTypes = new ArrayList<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "resolves");
            for (IConfigurationElement generates : elements) {
                List<IConfigurationElement> refTypes = this.getChildren(generates, "referenceTypeRef");
                for (IConfigurationElement refType : refTypes) {
                    IConfigurationElement nodeModelType;
                    String refTypeA = refType.getAttribute("ref");
                    if (refTypeA == null || !refTypeA.equals(reference.getReferenceType()) || (nodeModelType = this.getSingleChild(generates, "nodeModelRef")) == null) continue;
                    String referenceType = nodeModelType.getAttribute("ref");
                    resolvableNodeTypes.add(referenceType);
                }
            }
            return resolvableNodeTypes;
        }

        @Override
        public boolean isApplicable(Object context) {
            Reference reference = (Reference)context;
            if (reference == null) {
                return false;
            }
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "resolves");
            for (IConfigurationElement resolves : elements) {
                List<IConfigurationElement> refTypes = this.getChildren(resolves, "referenceTypeRef");
                for (IConfigurationElement refType : refTypes) {
                    String refTypeA = refType.getAttribute("ref");
                    if (refTypeA == null || !refTypeA.equals(reference.getReferenceType()) || !this.expressionEnabled(reference, resolves)) continue;
                    return true;
                }
            }
            return false;
        }

        public Map<String, Dependency> getResolvableDeps() {
            if (this.resolvableDeps == null) {
                this.resolvableDeps = new HashMap<String, Dependency>();
                List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "resolves");
                for (IConfigurationElement resolves : elements) {
                    List<IConfigurationElement> refTypes = this.getChildren(resolves, "referenceTypeRef");
                    for (IConfigurationElement refType : refTypes) {
                        String refTypeA = refType.getAttribute("ref");
                        if (refTypeA == null) continue;
                        Dependency dep = Dependency.parse(resolves);
                        this.resolvableDeps.put(refTypeA, dep);
                    }
                }
            }
            return this.resolvableDeps;
        }

        public Map<Dependency, List<String>> getDependentReferenceType(String dependentLinkId) {
            Map<Dependency, List<String>> depRefs;
            if (this.reverseMap == null) {
                Map<String, Dependency> rDeps = this.getResolvableDeps();
                this.reverseMap = new HashMap<String, Map<Dependency, List<String>>>();
                for (Map.Entry<String, Dependency> entry : rDeps.entrySet()) {
                    List<String> depRefs2;
                    String dependent = entry.getKey();
                    Dependency d = entry.getValue();
                    if (d == null) continue;
                    Map<Dependency, List<String>> ids = this.reverseMap.get(d.linkid);
                    if (ids == null) {
                        ids = new HashMap<Dependency, List<String>>();
                        this.reverseMap.put(d.linkid, ids);
                    }
                    if ((depRefs2 = ids.get(d)) == null) {
                        depRefs2 = new ArrayList<String>();
                        ids.put(d, depRefs2);
                    }
                    depRefs2.add(dependent);
                }
            }
            if ((depRefs = this.reverseMap.get(dependentLinkId)) == null) {
                return Collections.emptyMap();
            }
            return depRefs;
        }

        public Set<String> getTriggeredReferenceTypes(String triggerPoint, Map<String, String> arguments) {
            HashSet<String> triggeredRefs = new HashSet<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "resolves");
            for (IConfigurationElement generates : elements) {
                if (!this.isTriggered(generates, triggerPoint, arguments)) continue;
                List<IConfigurationElement> linkTypeRefs = this.getChildren(generates, "referenceTypeRef");
                for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    String applicableLinkType = linkTypeRef.getAttribute("ref");
                    if (applicableLinkType == null) continue;
                    triggeredRefs.add(applicableLinkType);
                }
            }
            return triggeredRefs;
        }

        public class DepRefInfo {
            List<String> depRefs;
            Dependency dep;

            public int hashCode() {
                int result = 1;
                result = 31 * result + (this.dep == null ? 0 : this.dep.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DepRefInfo other = (DepRefInfo)obj;
                return !(this.dep == null ? other.dep != null : !this.dep.equals(other.dep));
            }
        }
    }
}

