/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.services.Dependency;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceResolverService;
import com.ibm.etools.references.internal.services.SafeRun;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.services.providers.IReferenceGeneratorProvider;
import com.ibm.etools.references.services.providers.RefactoringGeneratorParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IVariableResolver;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ReferenceGeneratorService
extends Service<IReferenceGeneratorProvider> {
    private static ReferenceGeneratorService service = null;
    private final HashMap<String, Map<Dependency, List<SpecializedType>>> cache = new HashMap();
    List<String> refTypes = null;

    public static final synchronized ReferenceGeneratorService getInstance() {
        if (service == null) {
            service = new ReferenceGeneratorService();
            service.configureProviders("com.ibm.etools.references", "referenceGeneratorProvider");
        }
        return service;
    }

    @Override
    protected Service.ProviderDescriptor<IReferenceGeneratorProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new ReferenceGeneratorProviderDescriptor(configurationElement);
    }

    @Override
    protected boolean hasUniqueIds() {
        return true;
    }

    public List<GeneratedReferenceData> generateReferences(String referenceType, ILink link, String transformResult) {
        ArrayList<GeneratedReferenceData> providerReferences = new ArrayList<GeneratedReferenceData>();
        List descriptors = this.getAllProviders();
        for (ReferenceGeneratorProviderDescriptor referenceGeneratorProviderDescriptor : descriptors) {
            if (!referenceGeneratorProviderDescriptor.isApplicable(link)) continue;
            List<String> refTypes = referenceGeneratorProviderDescriptor.getGenerableReferenceTypes(link);
            if (referenceType != null) {
                GeneratedReferenceData set;
                if (!refTypes.contains(referenceType) || (set = this.genReferences(link, transformResult, referenceGeneratorProviderDescriptor, referenceType)) == null) continue;
                providerReferences.add(set);
                continue;
            }
            for (String refType : refTypes) {
                GeneratedReferenceData set = this.genReferences(link, transformResult, referenceGeneratorProviderDescriptor, refType);
                if (set == null) continue;
                providerReferences.add(set);
            }
        }
        return providerReferences;
    }

    private GeneratedReferenceData genReferences(final ILink link, final String transformResult, final ReferenceGeneratorProviderDescriptor desc, final String refType) {
        final IReferenceGeneratorProvider provider = (IReferenceGeneratorProvider)desc.getProvider();
        List<Reference> references = SafeRun.run(provider, new SafeRun.IRunnableWithResult<List<Reference>>(){

            @Override
            public List<Reference> run() throws Exception {
                List<Reference> result = provider.generateReferences(link, refType, transformResult);
                Assert.isNotNull(result, (String)"Generator cannot return null value. Please use emptyList");
                for (Reference reference : result) {
                    Assert.isNotNull((Object)reference, (String)"Returned List<Reference> cannot contain null values");
                    Assert.isNotNull((Object)reference.getFragmentLocation(), (String)"All List<Reference> elements must contain a fragment location");
                    reference.setProviderId(desc.getTypeId());
                    reference.freeze();
                }
                return result;
            }
        });
        if (references == null) {
            return null;
        }
        GeneratedReferenceData set = new GeneratedReferenceData(((IReferenceGeneratorProvider)desc.getProvider()).getClass().getName(), refType, references);
        return set;
    }

    public List<String> getGenerableTypes(ILink link) {
        ArrayList<String> referenceTypes = new ArrayList<String>();
        List descriptors = this.getAllProviders();
        for (ReferenceGeneratorProviderDescriptor referenceGeneratorProviderDescriptor : descriptors) {
            if (!referenceGeneratorProviderDescriptor.isApplicable(link)) continue;
            referenceTypes.addAll(referenceGeneratorProviderDescriptor.getGenerableReferenceTypes(link));
        }
        return referenceTypes;
    }

    public Map<Dependency, List<SpecializedType>> getDependentLinkTypes(String linkType) {
        Map<Dependency, List<SpecializedType>> result = this.cache.get(linkType);
        if (result == null) {
            result = new HashMap<Dependency, List<SpecializedType>>();
            List descriptors = this.getAllProviders();
            for (ReferenceGeneratorProviderDescriptor referenceGeneratorProviderDescriptor : descriptors) {
                Map<Dependency, List<SpecializedType>> linkTypes = referenceGeneratorProviderDescriptor.getDependentLinkTypes(linkType);
                for (Map.Entry<Dependency, List<SpecializedType>> entry : linkTypes.entrySet()) {
                    Dependency entryRefType = entry.getKey();
                    List<SpecializedType> mergedTypes = result.get(entryRefType);
                    if (mergedTypes == null) {
                        mergedTypes = new ArrayList<SpecializedType>();
                        result.put(entryRefType, mergedTypes);
                    }
                    mergedTypes.addAll((Collection<SpecializedType>)entry.getValue());
                }
            }
            Iterator<Object> iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (linkType.equals(((Dependency)entry.getKey()).linkid)) continue;
                iterator.remove();
            }
            this.cache.put(linkType, result);
        }
        return result;
    }

    public List<SpecializedType> getLinkTypesForRef(String refType) {
        HashMap merged = new HashMap();
        List descriptors = this.getAllProviders();
        for (ReferenceGeneratorProviderDescriptor referenceGeneratorProviderDescriptor : descriptors) {
            Map<String, List<SpecializedType>> linkTypes = referenceGeneratorProviderDescriptor.getLinkTypes();
            for (Map.Entry<String, List<SpecializedType>> entry : linkTypes.entrySet()) {
                String entryRefType = entry.getKey();
                ArrayList mergedTypes = (ArrayList)merged.get(entryRefType);
                if (mergedTypes == null) {
                    mergedTypes = new ArrayList();
                    merged.put(entryRefType, mergedTypes);
                }
                mergedTypes.addAll(entry.getValue());
            }
        }
        List result = (List)merged.get(refType);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public String renameReference(final RefactoringGeneratorParameters params) {
        final IReferenceGeneratorProvider provider = (IReferenceGeneratorProvider)params.reference.getAdapter(IReferenceGeneratorProvider.class);
        if (provider == null) {
            return null;
        }
        String renamedLink = SafeRun.run(provider, new SafeRun.IRunnableWithResult<String>(){

            @Override
            public String run() throws Exception {
                return provider.renameReference(params);
            }
        });
        return renamedLink;
    }

    public IStatus checkRenameReference(final RefactoringGeneratorParameters params) {
        final IReferenceGeneratorProvider provider = (IReferenceGeneratorProvider)params.reference.getAdapter(IReferenceGeneratorProvider.class);
        if (provider == null) {
            return Status.OK_STATUS;
        }
        IStatus renamedLink = SafeRun.run(provider, new SafeRun.IRunnableWithResult<IStatus>(){

            @Override
            public IStatus run() throws Exception {
                IStatus status = provider.checkRenameReference(params);
                Assert.isNotNull((Object)status);
                return status;
            }
        });
        return renamedLink;
    }

    public Collection<String> getReferenceTypesDependentOnIncomingReferenceDependency(IResolvedReference reference) {
        String referenceType = reference.getReferenceType();
        if (referenceType == null) {
            return Collections.emptySet();
        }
        ArrayList<IncomingDependency> merged = new ArrayList<IncomingDependency>();
        for (ReferenceGeneratorProviderDescriptor referenceGeneratorProviderDescriptor : this.getAllProviders()) {
            merged.addAll(referenceGeneratorProviderDescriptor.getRefTypesDependentOnIncomingRefTypes(referenceType));
        }
        ArrayList<String> refTypes = new ArrayList<String>();
        for (IncomingDependency incomingDependency : merged) {
            EvaluationContext context = new EvaluationContext(null, (Object)reference, new IVariableResolver[]{new VarResolver(reference)});
            try {
                EvaluationResult result = incomingDependency.expression.evaluate((IEvaluationContext)context);
                if (!EvaluationResult.TRUE.equals(result)) continue;
                refTypes.add(incomingDependency.depReferenceType);
            }
            catch (CoreException e) {
                Logger.log(e.getStatus());
            }
        }
        return refTypes;
    }

    private void buildRefTypes() {
        if (this.refTypes == null) {
            HashSet<String> allTypes = new HashSet<String>();
            List provs = this.getAllProviders();
            for (Service.ProviderDescriptor providerDescriptor : provs) {
                allTypes.addAll(((ReferenceGeneratorProviderDescriptor)providerDescriptor).getGenerableReferenceTypes(null));
            }
            provs = ReferenceResolverService.getInstance().getAllProviders();
            for (Service.ProviderDescriptor providerDescriptor : provs) {
                allTypes.addAll(((ReferenceResolverService.ReferenceResolverProviderDescriptor)providerDescriptor).getResolvableDeps().keySet());
            }
            this.refTypes = new ArrayList<String>(allTypes);
            Collections.sort(this.refTypes);
            this.refTypes = Collections.unmodifiableList(this.refTypes);
        }
    }

    public int getReferenceTypeId(String referenceType) {
        if (referenceType == null) {
            return -1;
        }
        this.buildRefTypes();
        int i = 0;
        while (i < this.refTypes.size()) {
            String r = this.refTypes.get(i);
            if (referenceType.equals(r)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getReferenceType(int id) {
        if (id < 0) {
            return null;
        }
        this.buildRefTypes();
        if (id > this.refTypes.size()) {
            return null;
        }
        return this.refTypes.get(id);
    }

    public Set<String> getTriggeredReferenceTypes(String triggerPoint, Map<String, String> arguments) {
        HashSet<String> triggeredRefs = new HashSet<String>();
        List provs = this.getAllProviders();
        for (Service.ProviderDescriptor providerDescriptor : provs) {
            ReferenceGeneratorProviderDescriptor genDesc = (ReferenceGeneratorProviderDescriptor)providerDescriptor;
            triggeredRefs.addAll(genDesc.getTriggeredReferenceTypes(triggerPoint, arguments));
        }
        return triggeredRefs;
    }

    public static final class GeneratedReferenceData {
        private final String generatorId;
        private final List<Reference> references;
        private final String referenceType;

        public GeneratedReferenceData(String generatorId, String referenceType, List<Reference> references) {
            this.generatorId = generatorId;
            this.referenceType = referenceType;
            this.references = references;
        }

        public String getReferenceType() {
            return this.referenceType;
        }

        public String getGeneratorId() {
            return this.generatorId;
        }

        public List<Reference> getReferences() {
            return this.references;
        }

        public String toString() {
            String s = "GENERATOR ID: " + this.generatorId + "\n";
            s = String.valueOf(s) + "REFERENCE TYPE: " + this.referenceType + "\n";
            s = String.valueOf(s) + "REFERENCES:\n";
            if (this.references != null) {
                for (Reference r : this.references) {
                    s = String.valueOf(s) + r + ", ";
                }
            }
            return s;
        }
    }

    private static class IncomingDependency {
        String depReferenceType;
        String incReferenceType;
        Expression expression;

        private IncomingDependency() {
        }

        public static IncomingDependency parse(IConfigurationElement generatesElement) {
            IConfigurationElement generates = generatesElement;
            IConfigurationElement refTypeElement = IncomingDependency.getSingleChild(generates, "referenceType");
            if (refTypeElement == null) {
                return null;
            }
            String refType = refTypeElement.getAttribute("id");
            if (refType == null) {
                return null;
            }
            IConfigurationElement incRefDepElement = IncomingDependency.getSingleChild(generates, "incomingReferenceDependency");
            if (incRefDepElement == null) {
                return null;
            }
            String incRefDep = incRefDepElement.getAttribute("ref");
            if (incRefDep == null) {
                return null;
            }
            IncomingDependency dep = new IncomingDependency();
            dep.incReferenceType = incRefDep;
            dep.depReferenceType = refType;
            IConfigurationElement enablement = IncomingDependency.getSingleChild(incRefDepElement, "enablement");
            if (enablement == null) {
                dep.expression = Expression.TRUE;
            } else {
                try {
                    dep.expression = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), enablement);
                }
                catch (CoreException coreException) {
                    dep.expression = Expression.FALSE;
                }
            }
            return dep;
        }

        private static IConfigurationElement getSingleChild(IConfigurationElement element, String childElementName) {
            IConfigurationElement[] elements = element.getChildren(childElementName);
            if (elements.length > 0) {
                return elements[0];
            }
            return null;
        }
    }

    public class ReferenceGeneratorProviderDescriptor
    extends Service.ProviderDescriptor<IReferenceGeneratorProvider> {
        private Map<String, List<SpecializedType>> refTypeToLinkTypes;
        private HashMap<Dependency, List<SpecializedType>> depToLinkTypes;
        private HashMap<String, List<IncomingDependency>> incTypeToRefType;

        public ReferenceGeneratorProviderDescriptor(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        public List<String> getGenerableReferenceTypes(ILink link) {
            ArrayList<String> refTypes = new ArrayList<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "generates");
            for (IConfigurationElement generates : elements) {
                List<IConfigurationElement> linkTypeRefs = this.getChildren(generates, "linkTypeRef");
                for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    List<IConfigurationElement> referenceTypes;
                    String applicableLinkType = linkTypeRef.getAttribute("ref");
                    if (applicableLinkType == null || link != null && !applicableLinkType.equals(link.getSpecializedType().getId()) || (referenceTypes = this.getChildren(generates, "referenceType")).isEmpty()) continue;
                    String referenceType = referenceTypes.iterator().next().getAttribute("id");
                    refTypes.add(referenceType);
                }
            }
            return refTypes;
        }

        public Map<String, List<SpecializedType>> getLinkTypes() {
            if (this.refTypeToLinkTypes == null) {
                this.refTypeToLinkTypes = new HashMap<String, List<SpecializedType>>();
                List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "generates");
                for (IConfigurationElement generates : elements) {
                    String refTypeVal;
                    IConfigurationElement linkTypeRef = this.getSingleChild(generates, "linkTypeRef");
                    IConfigurationElement refType = this.getSingleChild(generates, "referenceType");
                    if (refType == null || (refTypeVal = refType.getAttribute("id")) == null) continue;
                    ArrayList<SpecializedType> linkTypes = new ArrayList<SpecializedType>();
                    String applicableLinkType = linkTypeRef.getAttribute("ref");
                    if (applicableLinkType == null) continue;
                    linkTypes.add(LinkTypeRegistry.getInstance().getLinkType(applicableLinkType));
                    List<SpecializedType> types = this.refTypeToLinkTypes.get(refTypeVal);
                    if (types == null) {
                        types = new ArrayList<SpecializedType>();
                        this.refTypeToLinkTypes.put(refTypeVal, types);
                    }
                    types.addAll(linkTypes);
                }
            }
            return this.refTypeToLinkTypes;
        }

        public Map<Dependency, List<SpecializedType>> getDependentLinkTypes(String linkType) {
            if (this.depToLinkTypes == null) {
                this.depToLinkTypes = new HashMap();
                List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "generates");
                for (IConfigurationElement generates : elements) {
                    IConfigurationElement linkTypeRef = this.getSingleChild(generates, "linkTypeRef");
                    Dependency dependency = Dependency.parse(linkTypeRef);
                    if (dependency == null) continue;
                    ArrayList<SpecializedType> linkTypes = new ArrayList<SpecializedType>();
                    String applicableLinkType = linkTypeRef.getAttribute("ref");
                    if (applicableLinkType == null) continue;
                    linkTypes.add(LinkTypeRegistry.getInstance().getLinkType(applicableLinkType));
                    List<SpecializedType> types = this.depToLinkTypes.get(dependency);
                    if (types == null) {
                        types = new ArrayList<SpecializedType>();
                        this.depToLinkTypes.put(dependency, types);
                    }
                    types.addAll(linkTypes);
                }
            }
            return this.depToLinkTypes;
        }

        public List<IncomingDependency> getRefTypesDependentOnIncomingRefTypes(String referenceType) {
            List<IncomingDependency> result;
            if (this.incTypeToRefType == null) {
                this.incTypeToRefType = new HashMap();
                List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "generates");
                for (IConfigurationElement generates : elements) {
                    IncomingDependency incDep = IncomingDependency.parse(generates);
                    if (incDep == null) continue;
                    List<IncomingDependency> refTypes = this.incTypeToRefType.get(incDep.incReferenceType);
                    if (refTypes == null) {
                        refTypes = new ArrayList<IncomingDependency>();
                        this.incTypeToRefType.put(incDep.incReferenceType, refTypes);
                    }
                    refTypes.add(incDep);
                }
            }
            if ((result = this.incTypeToRefType.get(referenceType)) == null) {
                return Collections.emptyList();
            }
            return result;
        }

        @Override
        public boolean isApplicable(Object context) {
            ILink link = (ILink)context;
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "generates");
            for (IConfigurationElement generates : elements) {
                List<IConfigurationElement> linkTypeRefs = this.getChildren(generates, "linkTypeRef");
                for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    String applicableLinkType = linkTypeRef.getAttribute("ref");
                    if (applicableLinkType == null || link == null || link.getSpecializedType() == null || !applicableLinkType.equals(link.getSpecializedType().getId()) || !this.expressionEnabled(link, generates)) continue;
                    return true;
                }
            }
            return false;
        }

        public Set<String> getTriggeredReferenceTypes(String triggerPoint, Map<String, String> arguments) {
            HashSet<String> triggeredRefs = new HashSet<String>();
            List<IConfigurationElement> elements = this.getChildren(this.configurationElement, "generates");
            for (IConfigurationElement generates : elements) {
                if (!this.isTriggered(generates, triggerPoint, arguments)) continue;
                List<IConfigurationElement> linkTypeRefs = this.getChildren(generates, "referenceType");
                for (IConfigurationElement linkTypeRef : linkTypeRefs) {
                    String applicableLinkType = linkTypeRef.getAttribute("id");
                    if (applicableLinkType == null) continue;
                    triggeredRefs.add(applicableLinkType);
                }
            }
            return triggeredRefs;
        }
    }

    private static class VarResolver
    implements IVariableResolver {
        private final IResolvedReference reference;

        public VarResolver(IResolvedReference reference) {
            this.reference = reference;
        }

        public Object resolve(String name, Object[] args) throws CoreException {
            ILink target;
            String result = "";
            if ("targetLinkName".equals(name) && (target = this.reference.getTarget()) != null) {
                result = target.getName();
            }
            return result;
        }
    }
}

