/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.services;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.services.providers.IProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.QualifiedName;

public class LinkTypeRegistry
extends Service<IProvider> {
    private static LinkTypeRegistry service = null;
    private final Map<Integer, SpecializedType> specializedTypes = new HashMap<Integer, SpecializedType>();
    private final Map<String, Collection<SpecializedType>> matchingLinkCache = new HashMap<String, Collection<SpecializedType>>();

    /*
     * WARNING - void declaration
     */
    public static final synchronized LinkTypeRegistry getInstance() {
        if (service == null) {
            void var3_5;
            service = new LinkTypeRegistry();
            service.configureProviders("com.ibm.etools.references", "linkType");
            List providers = service.getAllProviders();
            HashSet<SpecializedType> unsortedSet = new HashSet<SpecializedType>();
            for (LinkDefinition linkDefinition : providers) {
                QualifiedName rawId;
                SpecializedType parent = null;
                if (linkDefinition.getParentLinkId() != null) {
                    parent = service.getLinkType(linkDefinition.getParentLinkId());
                }
                if ((rawId = linkDefinition.getId()) == null) {
                    Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Ignoring link type with no id from plugin: " + linkDefinition.getPluginName());
                    continue;
                }
                unsortedSet.add(new SpecializedType(rawId.getLocalName(), parent, linkDefinition.isPathDependent(), linkDefinition.isVisibleToSearch(), linkDefinition.getProperties()));
            }
            ArrayList list = new ArrayList(unsortedSet);
            Collections.sort(list);
            boolean bl = false;
            while (var3_5 < list.size()) {
                ((SpecializedType)list.get((int)var3_5)).setTypeid((int)var3_5);
                LinkTypeRegistry.service.specializedTypes.put((int)var3_5, (SpecializedType)list.get((int)var3_5));
                ++var3_5;
            }
        }
        return service;
    }

    @Override
    protected Service.ProviderDescriptor<IProvider> newProviderDescriptor(IConfigurationElement configurationElement) {
        return new LinkDefinition(configurationElement);
    }

    @Override
    protected boolean hasUniqueIds() {
        return true;
    }

    public SpecializedType getLinkType(String id) {
        Assert.isNotNull((Object)id);
        for (SpecializedType specializedType : this.specializedTypes.values()) {
            if (!id.equals(specializedType.getId())) continue;
            return specializedType;
        }
        throw new IllegalArgumentException("Link type id " + id + " does not exist");
    }

    public SpecializedType getLinkByTypeId(int typeId) {
        return this.specializedTypes.get(typeId);
    }

    public List<SpecializedType> getPathDependentLinks() {
        ArrayList<SpecializedType> results = new ArrayList<SpecializedType>();
        for (SpecializedType specialType : this.specializedTypes.values()) {
            if (!specialType.isPathDependent()) continue;
            results.add(specialType);
        }
        return results;
    }

    public Collection<SpecializedType> getMatchingLinks(String propertyKey, String propertyValue) {
        if (propertyKey == null || propertyValue == null) {
            return Collections.emptySet();
        }
        String cacheKey = String.valueOf(propertyKey) + propertyValue;
        Collection<SpecializedType> matches = this.matchingLinkCache.get(cacheKey);
        if (matches == null) {
            matches = new HashSet<SpecializedType>();
            for (SpecializedType specializedType : this.specializedTypes.values()) {
                if (!propertyValue.equals(specializedType.getProperties().get(propertyKey))) continue;
                matches.add(specializedType);
            }
            this.matchingLinkCache.put(cacheKey, matches);
        }
        return matches;
    }

    private static class LinkDefinition
    extends Service.ProviderDescriptor<IProvider> {
        public LinkDefinition(IConfigurationElement configurationElement) {
            super(configurationElement);
        }

        public String getParentLinkId() {
            return this.configurationElement.getAttribute("ref");
        }

        @Override
        public boolean isApplicable(Object context) {
            return true;
        }

        public boolean isPathDependent() {
            String pathDep = this.configurationElement.getAttribute("pathDependent");
            Boolean result = Boolean.parseBoolean(pathDep);
            return result;
        }

        public boolean isVisibleToSearch() {
            String internal = this.configurationElement.getAttribute("internal");
            Boolean result = Boolean.parseBoolean(internal);
            return result;
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> propMap = new HashMap<String, String>();
            List<IConfigurationElement> properties = this.getChildren(this.configurationElement, "property");
            for (IConfigurationElement property : properties) {
                String value;
                String key = property.getAttribute("key");
                if (key == null || (value = property.getAttribute("value")) == null) continue;
                propMap.put(key, value);
            }
            return propMap;
        }

        public String getPluginName() {
            return this.configurationElement.getContributor().getName();
        }
    }
}

