/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.internal.bplustree.db.IntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class SortUtil {
    public static final boolean ASSERT = true;

    public static <T> List<T> intersection(List<T> sortedList1, List<T> sortedList2, Comparator<T> compare) {
        ArrayList<T> info = new ArrayList<T>();
        Cursor<T> list1 = new Cursor<T>(sortedList1);
        Cursor<T> list2 = new Cursor<T>(sortedList2);
        while (!list1.isDone() && !list2.isDone()) {
            T pos2;
            T pos1 = list1.current();
            int c = compare.compare(pos1, pos2 = list2.current());
            if (c == 0) {
                info.add(pos1);
                list1.advance();
                list2.advance();
                continue;
            }
            if (c < 0) {
                list1.advance();
                continue;
            }
            list2.advance();
        }
        return info;
    }

    public static int[] intersection(int[] int1, int[] int2) {
        IntArray results = new IntArray();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < int1.length && pos2 < int2.length) {
            int val1 = int1[pos1];
            int val2 = int2[pos2];
            if (val1 == val2) {
                results.add(val1);
                ++pos1;
                ++pos2;
                continue;
            }
            if (val1 < val2) {
                ++pos1;
                continue;
            }
            ++pos2;
        }
        return results.toArray();
    }

    public static void assertSorted(int[] ints) {
        int[] sorted = Arrays.copyOf(ints, ints.length);
        Arrays.sort(sorted);
        int i = 0;
        while (i < sorted.length) {
            if (sorted[i] != ints[i]) {
                Assert.isTrue((boolean)false, (String)("Array is not sorted: " + Arrays.toString(ints)));
            }
            ++i;
        }
    }

    private static class Cursor<T> {
        private final Iterator<T> itr;
        private T current;
        private boolean done;

        public Cursor(Collection<T> collection) {
            this.itr = collection.iterator();
            this.done = !this.itr.hasNext();
        }

        public T current() {
            return this.current;
        }

        public T advance() {
            if (this.done) {
                return null;
            }
            if (this.itr.hasNext()) {
                this.current = this.itr.next();
            } else {
                this.current = null;
                this.done = true;
            }
            return this.current;
        }

        public boolean isDone() {
            return this.done;
        }
    }

    public class SetInfo<T> {
        List<T> onlyList1 = new ArrayList<T>();
        List<T> both = new ArrayList<T>();
        List<T> onlyList2 = new ArrayList<T>();
    }
}

