/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.Logger;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.management.IReferenceElement;

public abstract class InternalSearchRequestor<T extends IReferenceElement> {
    protected void acceptSearchMatch(int id) {
        this.acceptSearchMatch(this.getElement(id));
    }

    protected final T getElement(int id) {
        IReferenceElement element = ReferenceDatabase.getDefault().getReferenceElement(id);
        if (element == null) {
            this.logCleanupWarning(id);
        } else {
            try {
                return (T)element;
            }
            catch (ClassCastException e) {
                Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Warning: ClassCastException: " + e.getMessage() + " for artifact with id: " + id);
            }
        }
        return null;
    }

    public abstract void acceptSearchMatch(T var1);

    void logCleanupWarning(int id) {
        Logger.logWarning(Logger.Category.DEBUG, Logger.Mode.DEV_MANDATORY, "Warning: Artifact needs cleanup with id " + id);
    }
}

