/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.search.SearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class AndScope
extends SearchScope {
    private final SearchScope left;
    private final SearchScope right;

    public AndScope(SearchScope left, SearchScope right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean encloses(String resourcePath) {
        return this.left.encloses(resourcePath) && this.right.encloses(resourcePath);
    }

    @Override
    public IPath[] getEnclosingProjects() {
        ArrayList<IPath> leftPaths = new ArrayList<IPath>(Arrays.asList(this.left.getEnclosingProjects()));
        List<IPath> rightPaths = Arrays.asList(this.right.getEnclosingProjects());
        leftPaths.retainAll(rightPaths);
        return rightPaths.toArray(new IPath[rightPaths.size()]);
    }

    @Override
    public IPath[] getPaths() {
        ArrayList<IPath> leftPaths = new ArrayList<IPath>(Arrays.asList(this.left.getPaths()));
        List<IPath> rightPaths = Arrays.asList(this.right.getPaths());
        leftPaths.retainAll(rightPaths);
        return rightPaths.toArray(new IPath[rightPaths.size()]);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndScope other = (AndScope)obj;
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<IPath> iterator = Arrays.asList(this.getPaths()).iterator();
        while (iterator.hasNext()) {
            IPath path = iterator.next();
            builder.append(path.toString());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

