/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.search;

import com.ibm.etools.references.internal.bplustree.db.IntArray;
import com.ibm.etools.references.internal.search.ICompoundPattern;
import com.ibm.etools.references.internal.search.SortUtil;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AndPattern
extends ICompoundPattern {
    public AndPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(leftPattern, rightPattern);
    }

    @Override
    public String getSearchTypeValue() {
        String leftValue = this.leftPattern.getSearchTypeValue();
        String rightValue = this.rightPattern.getSearchTypeValue();
        if (leftValue != null && leftValue.equals(rightValue)) {
            return leftValue;
        }
        if (leftValue != null && rightValue == null) {
            return leftValue;
        }
        if (rightValue != null && leftValue == null) {
            return rightValue;
        }
        return null;
    }

    @Override
    public boolean isScopeAware(SearchScope scope) {
        return this.leftPattern.isScopeAware(scope) || this.rightPattern.isScopeAware(scope);
    }

    @Override
    public void findIndexMatches(SearchScope scope, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
            SearchPattern scopeAwarePattern = this.leftPattern.isScopeAware(scope) ? this.leftPattern : this.rightPattern;
            SearchPattern otherPattern = scopeAwarePattern == this.leftPattern ? this.rightPattern : this.leftPattern;
            IdCollector col1 = new IdCollector();
            scopeAwarePattern.findIndexMatches(scope, col1, (IProgressMonitor)sub.newChild(2));
            int[] ids1 = col1.getIds();
            if (scope.getPaths().length > 1) {
                Arrays.sort(ids1);
            }
            if (ids1.length > 0) {
                if (otherPattern.isScopeAware(scope)) {
                    int[] matches;
                    IdCollector col2 = new IdCollector();
                    otherPattern.findIndexMatches(scope, col2, (IProgressMonitor)sub.newChild(2));
                    int[] ids2 = col2.getIds();
                    int[] nArray = matches = SortUtil.intersection(ids1, ids2);
                    int n = matches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        requestor.acceptSearchMatch((IReferenceElement)id);
                        ++n2;
                    }
                } else {
                    otherPattern.findIndexMatches(ids1, requestor, (IProgressMonitor)sub.newChild(1));
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    @Override
    protected void findIndexMatches(int[] scopeIds, SearchRequestor<? extends IReferenceElement> requestor, IProgressMonitor progressMonitor) throws ReferenceException {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
            IdCollector collector = new IdCollector();
            this.leftPattern.findIndexMatches(scopeIds, collector, (IProgressMonitor)sub.newChild(1));
            int[] ids = collector.getIds();
            if (ids.length > 0) {
                this.rightPattern.findIndexMatches(ids, requestor, (IProgressMonitor)sub.newChild(1));
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    @Override
    protected <R extends IReferenceElement, SR extends SearchRequestor<R>> void findMatchesForParticipants(String searchTypeValue, SearchScope scope, SR requestor, IProgressMonitor progressMonitor) throws ReferenceException {
        if (this.getSearchTypeValue() != null) {
            try {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
                DefaultSearchRequestor collector = new DefaultSearchRequestor();
                this.leftPattern.findMatchesForParticipants(searchTypeValue, scope, collector, (IProgressMonitor)sub.newChild(1));
                if (!collector.getMatches().isEmpty()) {
                    if (this.rightPattern.getSearchTypeValue() == null) {
                        AndSearchRequestor ander = new AndSearchRequestor(collector, requestor);
                        this.rightPattern.findMatchesForParticipants(searchTypeValue, scope, ander, (IProgressMonitor)sub.newChild(1));
                    } else {
                        Set elements = collector.getMatches();
                        for (IReferenceElement referenceElement : elements) {
                            requestor.acceptSearchMatch((IReferenceElement)referenceElement);
                        }
                        sub.worked(1);
                    }
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    @Override
    public String toString(int indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.leftPattern.toString(indent + 1));
        builder.append("\r");
        builder.append((CharSequence)this.getIndent(indent));
        builder.append("AND\r");
        builder.append(this.rightPattern.toString(indent + 1));
        builder.append("\r");
        return builder.toString();
    }

    static class AndSearchRequestor<T extends IReferenceElement>
    extends SearchRequestor<T> {
        private final DefaultSearchRequestor<T> req;
        private final SearchRequestor<T> parent;

        <DSR extends DefaultSearchRequestor<T>, SR extends SearchRequestor<T>> AndSearchRequestor(DSR req, SR parent) {
            this.req = req;
            this.parent = parent;
        }

        @Override
        public void acceptSearchMatch(T match) {
            if (this.req.getMatches().contains(match)) {
                this.parent.acceptSearchMatch(match);
            }
        }
    }

    static class IdCollector<T extends IReferenceElement>
    extends SearchRequestor<T> {
        private final IntArray ids = new IntArray();

        @Override
        public void acceptSearchMatch(int id) {
            this.ids.add(id);
        }

        public int[] getIds() {
            return this.ids.toArray();
        }

        @Override
        public void acceptSearchMatch(IReferenceElement match) {
        }
    }
}

