/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.resource;

import com.ibm.etools.references.internal.Activator;
import com.ibm.etools.references.internal.management.IRunnableJob;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.resource.SaveParticipant;
import com.ibm.etools.references.internal.resource.SavedResourceChangeListener;
import com.ibm.etools.references.management.ReferenceManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class ReferenceManagerStartupJob
extends WorkspaceJob
implements IRunnableJob {
    private final AtomicBoolean runningNow = new AtomicBoolean(false);
    private final boolean fullAnalysis;
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile boolean userInitiated;
    private final Object SYNC = new Object();

    public ReferenceManagerStartupJob(boolean fullAnalysis) {
        super(Messages.errorMsg_startup_init);
        this.fullAnalysis = fullAnalysis;
        ISchedulingRule rule = MultiRule.combine((ISchedulingRule)this.getRunNowRule(), (ISchedulingRule)new StartupRule());
        this.setRule(rule);
        this.setPriority(10);
    }

    public ISchedulingRule getRunNowRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IStatus runNow(IProgressMonitor monitor) {
        if (this.runningNow.get()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            Job.getJobManager().beginRule(this.getRunNowRule(), (IProgressMonitor)mon.newChild(1));
            IStatus iStatus = this.execute((IProgressMonitor)mon.newChild(1));
            return iStatus;
        }
        finally {
            Job.getJobManager().endRule(this.getRunNowRule());
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        return this.execute(monitor);
    }

    public boolean belongsTo(Object family) {
        return family == ReferenceManager.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IProgressMonitor monitor) {
        boolean success = this.runningNow.compareAndSet(false, true);
        if (success) {
            this.started = true;
            this.finished = false;
            Object object = this.SYNC;
            synchronized (object) {
                this.SYNC.notifyAll();
            }
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.errorMsg_ReferenceManagerStartupJob_ProcessingLinksChangesWhileInactive, (int)1);
            ReferenceManager iRef = ReferenceManager.getReferenceManager();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            SaveParticipant saver = new SaveParticipant();
            try {
                try {
                    ISavedState ss = ws.addSaveParticipant((Plugin)Activator.getDefault(), (ISaveParticipant)saver);
                    if (this.fullAnalysis) {
                        ws.forgetSavedTree("com.ibm.etools.references");
                        if (!ReferenceManager.getReferenceManager().isSuspended()) {
                            iRef.requestRebuildIndex((IProgressMonitor)mon.newChild(1));
                        }
                    } else if (ss != null) {
                        ss.processResourceChangeEvents((IResourceChangeListener)new SavedResourceChangeListener((IProgressMonitor)mon.newChild(1)));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    this.started = false;
                    this.finished = true;
                    iRef.setInitialized();
                    if (monitor != null) {
                        monitor.done();
                    }
                    return iStatus;
                }
                catch (RuntimeException e) {
                    Status status;
                    Status status2 = status = new Status(4, "com.ibm.etools.references", Messages.errorMsg_errorsduringstartup, (Throwable)e);
                    this.started = false;
                    this.finished = true;
                    iRef.setInitialized();
                    if (monitor != null) {
                        monitor.done();
                    }
                    return status2;
                }
            }
            finally {
                this.started = false;
                this.finished = true;
                iRef.setInitialized();
                if (monitor != null) {
                    monitor.done();
                }
            }
            return Status.OK_STATUS;
        }
        Object object = this.SYNC;
        synchronized (object) {
            this.SYNC.notifyAll();
        }
        return Status.CANCEL_STATUS;
    }

    public void setUserInitiated(boolean userInitiated) {
        this.userInitiated = userInitiated;
    }

    public boolean isUserInitiated() {
        return this.userInitiated;
    }

    @Override
    public Object getSync() {
        return this.SYNC;
    }

    static class StartupRule
    implements ISchedulingRule {
        StartupRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

