/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.refactoring;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.refactoring.ResourceVisitor;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.services.providers.ProviderArguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ReferenceRenameRefactoringParticipant
extends RenameParticipant
implements ISharableParticipant {
    private final List<ObjectAndArgs> argsList = new ArrayList<ObjectAndArgs>();
    private RefactoringSupport refactoringSupport;

    public void addElement(Object element, RefactoringArguments arguments) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = (RenameArguments)arguments;
        args.element = element;
        this.argsList.add(args);
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        pm.beginTask("", 100000);
        SubProgressMonitor sub = new SubProgressMonitor(pm, 100000, 4);
        for (ObjectAndArgs info : this.argsList) {
            if (!info.args.getUpdateReferences()) continue;
            if (pm.isCanceled()) {
                return null;
            }
            try {
                IResource r = (IResource)info.element;
                if (r instanceof IFile) {
                    IFile file = (IFile)r;
                    IFile targetFile = r.getParent().getFile((IPath)new Path(info.args.getNewName()));
                    IContainer container = targetFile.getParent();
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)sub, (String)Messages.locatingLinks, (int)1);
                    this.renameFile((IProgressMonitor)mon, (IResource)file, container, file, targetFile);
                    continue;
                }
                if (!(r instanceof IFolder)) continue;
                IFolder anchorContainer = (IFolder)r;
                IPath anchorPath = anchorContainer.getFullPath();
                IFolder newContainer = anchorContainer.getParent().getFolder((IPath)new Path(info.args.getNewName()));
                IPath newContainerPath = newContainer.getFullPath();
                ResourceVisitor children = new ResourceVisitor();
                anchorContainer.accept((IResourceVisitor)children);
                Collection<IResource> allChildren = children.getChildren();
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)sub, (String)Messages.locatingLinks, (int)allChildren.size());
                for (IResource resource : allChildren) {
                    IPath targetPath = resource.getFullPath();
                    int strippedSegments = targetPath.matchingFirstSegments(anchorPath);
                    targetPath = targetPath.removeFirstSegments(strippedSegments);
                    targetPath = newContainerPath.append(targetPath);
                    IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
                    if (resource instanceof IFile) {
                        this.renameFile((IProgressMonitor)mon.newChild(1), (IResource)anchorContainer, (IContainer)newContainer, (IFile)resource, targetFile);
                    } else {
                        mon.worked(1);
                    }
                    if (!mon.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            catch (CoreException e) {
                RefactoringStatus status = RefactoringStatus.create((IStatus)e.getStatus());
                return status;
            }
            catch (OperationCanceledException operationCanceledException) {
                return RefactoringStatus.create((IStatus)Status.CANCEL_STATUS);
            }
        }
        if (pm.isCanceled()) {
            return null;
        }
        return this.refactoringSupport.getStatus();
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.refactoringSupport.createMergedChange(Messages.refactoring_keep_links_uptodate, (RefactoringParticipant)this, pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private void renameFile(IProgressMonitor monitor, IResource originalContainer, IContainer newContainer, IFile sourcefile, IFile targetFile) throws ReferenceException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        LinkNode<IFile> targetNode = ReferenceManager.getReferenceManager().getLinkNode(targetFile);
        LinkNode<IFile> linkNode = ReferenceManager.getReferenceManager().getLinkNode(sourcefile);
        Collection<ILink> links = linkNode.getLinks(null, SpecializedType.Depth.ZERO, (IProgressMonitor)mon.newChild(1));
        mon.setWorkRemaining(links.size());
        for (ILink link : links) {
            this.refactoringSupport.createEdits(originalContainer, newContainer, link, targetNode, true, EnumSet.of(ProviderArguments.LINKSTYLE_PRESERVE), (IProgressMonitor)mon.newChild(1));
            if (!mon.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    public String getName() {
        return Messages.refactoring_rename_links;
    }

    protected boolean initialize(Object element) {
        ObjectAndArgs args = new ObjectAndArgs();
        args.args = this.getArguments();
        args.element = element;
        this.argsList.add(args);
        this.refactoringSupport = new RefactoringSupport();
        return true;
    }

    private class ObjectAndArgs {
        public Object element;
        public RenameArguments args;

        private ObjectAndArgs() {
        }
    }
}

