/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.refactoring;

import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.resource.FileVisitor;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.refactoring.processor.RenameTextRangeProcessor;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.services.providers.ProviderArguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ConvertLinksRefactoring
extends RenameTextRangeProcessor {
    private final List<IResource> filesToConvert = new ArrayList<IResource>();
    private final String style;

    public ConvertLinksRefactoring(String style, Object o) {
        this.style = style;
        if (o instanceof IResource) {
            this.filesToConvert.add((IResource)o);
        }
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)3);
        RefactoringSupport support = new RefactoringSupport();
        SearchPattern allLinks = SearchPattern.createWildcardPattern();
        SearchScope scope = SearchEngine.createSearchScope(this.getResourcesAndChildren(this.filesToConvert));
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine(true).search(allLinks, scope, req, (IProgressMonitor)monitor.newChild(1, 7));
        Set links = req.getMatches();
        EnumSet<ProviderArguments> args = EnumSet.noneOf(ProviderArguments.class);
        args = "absolute".equals(this.style) ? EnumSet.of(ProviderArguments.LINKSTYLE_ABSOLUTE) : EnumSet.of(ProviderArguments.LINKSTYLE_RELATIVE);
        SubMonitor partB = monitor.newChild(1);
        partB.beginTask("", links.size());
        for (ILink target : links) {
            support.createEdits(target.getContainer().getResource(), target.getContainer().getResource().getParent(), target, target.getContainer(), true, args, false, (IProgressMonitor)partB.newChild(1));
            if (!partB.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return support.createMergedChange(Messages.ConvertLinksRefactoring_1, (RefactoringProcessor)this, (IProgressMonitor)monitor.newChild(1));
    }

    @Override
    public Object[] getElements() {
        return this.filesToConvert.toArray(new IFile[this.filesToConvert.size()]);
    }

    @Override
    public String getIdentifier() {
        return "com.ibm.etools.references.ConvertLinksProcessor";
    }

    @Override
    public String getProcessorName() {
        return Messages.ConvertLinksRefactoring_3;
    }

    @Override
    public boolean isApplicable() throws CoreException {
        return true;
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    private Collection<? extends IResource> getResourcesAndChildren(Collection<? extends IResource> resources) {
        HashSet<IFile> allResources = new HashSet<IFile>();
        FileVisitor visitor = new FileVisitor();
        for (IResource iResource : resources) {
            try {
                iResource.accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        allResources.addAll(visitor.getFiles());
        return allResources;
    }
}

