/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.Logger;
import com.ibm.etools.references.StringMatcher;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.CountUpDownLatch;
import com.ibm.etools.references.internal.InternalReferencesJob;
import com.ibm.etools.references.internal.ReferencesPreferencesAccess;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.AddToIndexJob;
import com.ibm.etools.references.internal.management.InternalReferenceManager;
import com.ibm.etools.references.internal.management.ItemToIndex;
import com.ibm.etools.references.internal.management.MonitorPolicy;
import com.ibm.etools.references.internal.management.ReferenceProcessor;
import com.ibm.etools.references.internal.management.SavedIndexQueue;
import com.ibm.etools.references.internal.management.ScheduleSorter;
import com.ibm.etools.references.internal.management.SchedulerCondition;
import com.ibm.etools.references.internal.management.SchedulerProjectInfo;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.services.LinkNodeModelService;
import com.ibm.etools.references.internal.services.ResourceApproverService;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.search.SearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

public class Scheduler {
    private final LinkedList<ItemToIndex> itemQueue;
    private final Map<IResource, ItemToIndex> resourceToItem;
    private final ReentrantLock lock = new ReentrantLock();
    private final ReferenceDatabase DATABASE = ReferenceDatabase.getDefault();
    private final LinkNodeModelService MODELSERVICE = LinkNodeModelService.getInstance();
    private static final ReferencesPreferencesAccess PREFS = ReferencesPreferencesAccess.INSTANCE;
    private final InternalReferenceManager MANAGER;
    private final ReferenceProcessor processor;
    private final LinkedHashSet<SchedulerCondition> conditionSet;
    private volatile int size = 0;
    private final AtomicInteger addingNodes;
    final CountUpDownLatch readinessLatch;
    private final Object ADD_NODES;
    private final AddToIndexJob addJob;
    private InternalReferencesJob timedSchedule;
    private final IJobManager manager = Job.getJobManager();
    private final List<SchedulerProjectInfo> projectsInScheduler = new ArrayList<SchedulerProjectInfo>();
    private List<String> lastSchedulerPriorityList = Collections.emptyList();
    private ItemToIndex currentItem;

    public Scheduler(ReferenceProcessor processor, InternalReferenceManager manager) {
        this.processor = processor;
        this.MANAGER = manager;
        this.conditionSet = new LinkedHashSet();
        this.itemQueue = new LinkedList();
        this.resourceToItem = new HashMap<IResource, ItemToIndex>();
        this.addJob = new AddToIndexJob(this, manager);
        this.readinessLatch = new CountUpDownLatch(0);
        this.ADD_NODES = new Object();
        this.addingNodes = new AtomicInteger();
        this.loadSavedState();
    }

    ReentrantLock getLock() {
        return this.lock;
    }

    InternalReferenceManager getManager() {
        return this.MANAGER;
    }

    private void loadSavedState() {
        boolean requestReset = false;
        try {
            SavedIndexQueue savedInfo = this.DATABASE.getSavedIndexQueue();
            if (savedInfo != null) {
                for (ItemToIndex itemToIndex : savedInfo.getSavedLinkNodes()) {
                    this.addItemUnsorted(itemToIndex);
                }
                Assert.isTrue((savedInfo.getSavedLinkNodes().size() == this.itemQueue.size() ? 1 : 0) != 0, (String)("Loaded size doesn't match actual size: " + savedInfo.getSavedLinkNodes().size() + " vs " + this.itemQueue.size()));
                savedInfo.getSavedLinkNodes().clear();
                if (Logger.SHOULD_TRACE_DEBUG) {
                    Logger.trace(Logger.Category.DEBUG, String.valueOf(this.size) + " persisted indexer items where found", new Throwable[]{null});
                }
                for (ItemToIndex info : this.itemQueue) {
                    if (info.change == null || info.change.getResource() == null) continue;
                    this.resourceToItem.put(info.change.getResource(), info);
                }
            } else {
                Status status = new Status(4, "com.ibm.etools.references", 0, "Errors reading index [queue]. Index will be regenerated.", null);
                Logger.log((IStatus)status);
                requestReset = true;
            }
        }
        catch (RuntimeException e) {
            Status status = new Status(4, "com.ibm.etools.references", 0, "Errors reading index [queue]. Index will be regenerated.", (Throwable)e);
            Logger.log((IStatus)status);
            requestReset = true;
        }
        if (requestReset) {
            this.itemQueue.clear();
            this.size = 0;
            InternalAPI.getRebuildJob().schedule();
        }
    }

    private ScheduleSorter getSorter() {
        ArrayList<IPath> pathPriorities = new ArrayList<IPath>();
        try {
            this.lock.lock();
            for (SchedulerCondition cond : this.conditionSet) {
                pathPriorities.addAll(cond.paths);
            }
        }
        finally {
            this.lock.unlock();
        }
        return new ScheduleSorter(pathPriorities);
    }

    public void requestChangeAnalysis(List<ResourceChange> changes, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        this.addJob.addChangeItem(changes);
        mon.worked(1);
        if (monitor != null) {
            monitor.done();
        }
    }

    public void processLinkDeltas(List<InternalAPI.LinkDelta> deltas) {
        this.addJob.addLinkDeltas(deltas);
    }

    FilteredIndexItems createFilteredIndexItems(AddToIndexJob.SchedulerItem item, IProgressMonitor monitor) {
        FilteredIndexItems items = new FilteredIndexItems();
        if (item.changes != null) {
            monitor.beginTask("", item.changes.size());
            for (ResourceChange change : item.changes) {
                IResource res = change.getResource();
                monitor.subTask(res.getFullPath().toString());
                if (res.getType() != 8) {
                    ItemToIndex indexItem = new ItemToIndex();
                    indexItem.change = change;
                    if (change.isRemove() && !this.MANAGER.hasFatalError()) {
                        items.add(indexItem);
                    } else if (!Scheduler.isTargettable(res) || Scheduler.hasStar(res) || this.MANAGER.hasFatalError()) {
                        if (Logger.SHOULD_TRACE_RESOURCE_DELTA) {
                            Logger.trace(Logger.Category.RESOURCE_DELTA, "Not targettable: " + indexItem.change, new Throwable[0]);
                        }
                        ++items.ignoredCompletely;
                    } else if (Scheduler.ignoreContainedLinks(res)) {
                        if (Logger.SHOULD_TRACE_RESOURCE_DELTA) {
                            Logger.trace(Logger.Category.RESOURCE_DELTA, "ignoreContainedLinks: " + indexItem.change, new Throwable[0]);
                        }
                        indexItem.ignoreContainedLinks = true;
                        ++items.ignoredContainsLinks;
                        items.add(indexItem);
                    } else {
                        if (Logger.SHOULD_TRACE_RESOURCE_DELTA) {
                            Logger.trace(Logger.Category.RESOURCE_DELTA, "Normal: " + indexItem.change, new Throwable[0]);
                        }
                        if (item.addedModelDeps) {
                            indexItem.modelIds = item.modelIds;
                            indexItem.addedModelDeps = item.addedModelDeps;
                        } else {
                            indexItem.modelIds = this.MODELSERVICE.getNodeModelIds(res);
                        }
                        ++items.added;
                        items.add(indexItem);
                    }
                }
                monitor.worked(1);
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addItemToIndex(AddToIndexJob.SchedulerItem item, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FilteredIndexItems items = this.createFilteredIndexItems(item, (IProgressMonitor)sub.newChild(25));
        boolean shouldSchedule = true;
        try {
            this.lock.lock();
            this.addingNodes.incrementAndGet();
            SubMonitor part1 = sub.newChild(50);
            if (item.condition != null) {
                ItemToIndex i = new ItemToIndex();
                i.condition = item.condition;
                i.addedModelDeps = item.addedModelDeps;
                i.modelIds = item.modelIds;
                shouldSchedule = !this.insertSingle(i);
            } else if (item.deltas != null) {
                int deltaSize = item.deltas.size();
                part1.beginTask("", deltaSize + 25);
                for (InternalAPI.LinkDelta delta : item.deltas) {
                    ItemToIndex info = new ItemToIndex();
                    info.affectedLink = delta.link;
                    info.modelinstanceref = delta.modelinstanceref;
                    if (delta.kind == 1) {
                        info.linkType = ReferenceEvent.Kind.ADD;
                    } else if (delta.kind == 2) {
                        info.linkType = ReferenceEvent.Kind.REMOVE;
                    } else {
                        throw new UnsupportedOperationException("Delta kind not supported");
                    }
                    if (deltaSize >= 100) {
                        this.addItemUnsorted(info);
                        ItemToIndex i = this.addToMap(info);
                        if (i != null) {
                            Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                        }
                    } else {
                        this.insertSingle(info);
                    }
                    part1.worked(1);
                    ++items.added;
                }
                if (deltaSize >= 100) {
                    this.createSchedule((IProgressMonitor)part1.newChild(25));
                } else {
                    part1.newChild(25);
                }
            } else {
                this.doReplacements(item, items.items, (IProgressMonitor)part1);
            }
        }
        catch (Throwable throwable) {
            sub.subTask("");
            if (this.addingNodes.decrementAndGet() == 0) {
                Object object = this.ADD_NODES;
                synchronized (object) {
                    this.ADD_NODES.notifyAll();
                }
            }
            this.lock.unlock();
            if (monitor != null) {
                monitor.done();
            }
            if (item.condition == null && Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
                Logger.trace(Logger.Category.REFERENCE_MANAGER, "Add to index finished, added: " + items.added + " Ignored containsLinks: " + items.ignoredContainsLinks + ", Ignored completely: " + items.ignoredCompletely, new Throwable[0]);
            }
            throw throwable;
        }
        sub.subTask("");
        if (this.addingNodes.decrementAndGet() == 0) {
            Object object = this.ADD_NODES;
            synchronized (object) {
                this.ADD_NODES.notifyAll();
            }
        }
        this.lock.unlock();
        if (monitor != null) {
            monitor.done();
        }
        if (item.condition == null && Logger.SHOULD_TRACE_REFERENCE_MANAGER) {
            Logger.trace(Logger.Category.REFERENCE_MANAGER, "Add to index finished, added: " + items.added + " Ignored containsLinks: " + items.ignoredContainsLinks + ", Ignored completely: " + items.ignoredCompletely, new Throwable[0]);
        }
        return shouldSchedule;
    }

    private void doReplacements(AddToIndexJob.SchedulerItem item, Collection<ItemToIndex> items, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SubMonitor part1 = sub.newChild(1);
        part1.beginTask("", items.size());
        boolean didReplacement = false;
        boolean noop = true;
        for (ItemToIndex indexItem : items) {
            ItemToIndex i;
            IResource res = indexItem.change.getResource();
            part1.subTask(res.getFullPath().toString());
            ItemToIndex oldIndexItem = this.resourceToItem.remove(res);
            if (oldIndexItem == null) {
                if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                    Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "No replacement: " + indexItem, new Throwable[0]);
                }
                if (!didReplacement && items.size() < 100) {
                    this.insertSingle(indexItem);
                } else {
                    this.addItemUnsorted(indexItem);
                    i = this.addToMap(indexItem);
                    if (i != null) {
                        Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                    }
                }
            } else {
                didReplacement = true;
                if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                    Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: Found old change (" + oldIndexItem + "), not adding new change (" + indexItem + ")", new Throwable[0]);
                }
                if (oldIndexItem.change.isAdd()) {
                    if (indexItem.change.isAdd()) {
                        i = this.addToMap(indexItem);
                        if (i != null) {
                            Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                        }
                        if (oldIndexItem.change.isTrigger() != indexItem.change.isTrigger()) {
                            if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                                Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: ADD followed by ADD, trigger updated to " + (oldIndexItem.change.isTrigger() || indexItem.change.isTrigger()), new Throwable[0]);
                            }
                            oldIndexItem.change.setTrigger(oldIndexItem.change.isTrigger() || indexItem.change.isTrigger());
                        }
                    } else if (indexItem.change.isRemove()) {
                        if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                            Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: ADD followed by REMOVE, remove old ADD", new Throwable[0]);
                        }
                        this.removeFromQueue(oldIndexItem);
                    } else if (indexItem.change.isChange()) {
                        i = this.addToMap(indexItem);
                        if (i != null) {
                            Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                        }
                        if (oldIndexItem.change.isTrigger() != indexItem.change.isTrigger()) {
                            if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                                Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: ADD followed by CHANGE, trigger updated to " + (oldIndexItem.change.isTrigger() || indexItem.change.isTrigger()), new Throwable[0]);
                            }
                            oldIndexItem.change.setTrigger(oldIndexItem.change.isTrigger() || indexItem.change.isTrigger());
                        }
                        if (oldIndexItem.addedModelDeps && oldIndexItem.addedModelDeps == indexItem.addedModelDeps) {
                            oldIndexItem.modelIds.addAll(indexItem.modelIds);
                        } else if (oldIndexItem.addedModelDeps != indexItem.addedModelDeps && indexItem.addedModelDeps) {
                            oldIndexItem.modelIds = indexItem.modelIds;
                            oldIndexItem.addedModelDeps = true;
                        }
                    }
                } else if (oldIndexItem.change.isRemove()) {
                    if (indexItem.change.isAdd()) {
                        if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                            Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: REMOVE followed by ADD, remove old REMOVE ", new Throwable[0]);
                        }
                        this.removeFromQueue(oldIndexItem);
                    } else if (indexItem.change.isRemove()) {
                        i = this.addToMap(indexItem);
                        if (i != null) {
                            Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                        }
                        if (oldIndexItem.change.isTrigger() != indexItem.change.isTrigger()) {
                            if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                                Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: REMOVE followed by REMOVE, update trigger to: " + (oldIndexItem.change.isTrigger() || indexItem.change.isTrigger()), new Throwable[0]);
                            }
                            oldIndexItem.change.setTrigger(oldIndexItem.change.isTrigger() || indexItem.change.isTrigger());
                        }
                    } else if (indexItem.change.isChange()) {
                        i = this.addToMap(indexItem);
                        if (i != null) {
                            Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                        }
                        if (oldIndexItem.change.isTrigger() != indexItem.change.isTrigger()) {
                            if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                                Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: REMOVE followed by CHANGE, update trigger to: " + (oldIndexItem.change.isTrigger() || indexItem.change.isTrigger()), new Throwable[0]);
                            }
                            oldIndexItem.change.setTrigger(oldIndexItem.change.isTrigger() || indexItem.change.isTrigger());
                        }
                    }
                } else if (oldIndexItem.change.isChange()) {
                    if (indexItem.change.isAdd()) {
                        if (oldIndexItem.change.isTrigger()) {
                            if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                                Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement: TRIGGERED CHANGED followed by ADD, convert old TRIGGERED CHANGE to new ADD", new Throwable[0]);
                            }
                            oldIndexItem.copyFrom(indexItem);
                            this.resourceToItem.put(oldIndexItem.change.getResource(), oldIndexItem);
                            noop = false;
                        } else if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                            Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "WARNING: (should be IMPOSSIBLE) Replacement:CHANGED followed by ADD", new Throwable[0]);
                        }
                    } else if (indexItem.change.isRemove()) {
                        if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                            Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement:  CHANGED followed by REMOVE, convert old CHANGE to new REMOVE", new Throwable[0]);
                        }
                        oldIndexItem.copyFrom(indexItem);
                        this.resourceToItem.put(oldIndexItem.change.getResource(), oldIndexItem);
                        noop = false;
                    } else if (indexItem.change.isChange()) {
                        i = this.addToMap(indexItem);
                        if (i != null) {
                            Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                        }
                        if (oldIndexItem.change.isTrigger() != indexItem.change.isTrigger()) {
                            if (Logger.SHOULD_TRACE_SCHEDULE_REPLACEMENT) {
                                Logger.trace(Logger.Category.SCHEDULE_REPLACEMENT, "Replacement:  CHANGED followed by CHANGE, trigger updated to: " + (oldIndexItem.change.isTrigger() || indexItem.change.isTrigger()), new Throwable[0]);
                            }
                            oldIndexItem.change.setTrigger(oldIndexItem.change.isTrigger() || indexItem.change.isTrigger());
                        }
                        if (oldIndexItem.addedModelDeps && oldIndexItem.addedModelDeps == indexItem.addedModelDeps) {
                            oldIndexItem.modelIds.addAll(indexItem.modelIds);
                        } else if (oldIndexItem.addedModelDeps != indexItem.addedModelDeps && indexItem.addedModelDeps) {
                            oldIndexItem.modelIds = indexItem.modelIds;
                            oldIndexItem.addedModelDeps = true;
                        }
                    }
                }
            }
            part1.worked(1);
        }
        if (didReplacement && !noop || item.changes.size() >= 100) {
            this.createSchedule((IProgressMonitor)sub.newChild(1));
        } else {
            sub.newChild(1);
        }
    }

    public static boolean hasStar(IResource res) {
        IProject project = res == null ? null : res.getProject();
        List<StringMatcher> matcher = PREFS.getEnabledIgnoredResources(project);
        for (StringMatcher stringMatcher : matcher) {
            if (!"*".equals(stringMatcher.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargettable(IResource resource) {
        if (PREFS.isIgnoredDerived(resource.getProject()) && resource.isDerived(512)) {
            return false;
        }
        return ResourceApproverService.getInstance().isTargettable(resource, PREFS.getEnabledResourceApprovers(resource.getProject()));
    }

    public static boolean ignoreContainedLinks(IResource resource) {
        IPath path = resource.getFullPath();
        boolean ignored = false;
        boolean proceed = true;
        if (path.segmentCount() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (proceed) {
                List<StringMatcher> matcher = PREFS.getEnabledIgnoredResources(project);
                String[] pathSegments = path.segments();
                String pathString = path.toString();
                block0: for (StringMatcher stringMatcher : matcher) {
                    if (ignored) break;
                    if (stringMatcher.containsSlash()) {
                        ignored = stringMatcher.match(pathString);
                        if (!ignored) continue;
                        break;
                    }
                    String[] stringArray = pathSegments;
                    int n = pathSegments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        ignored = stringMatcher.match(segment);
                        if (ignored) continue block0;
                        ++n2;
                    }
                }
            }
        }
        if (!ignored) {
            ignored = !ResourceApproverService.getInstance().containsLinks(resource, PREFS.getEnabledResourceApprovers(resource.getProject()));
        }
        return ignored;
    }

    private boolean hasSameSortOrder(ScheduleSorter sorter) {
        return sorter.getPriorityList().equals(this.lastSchedulerPriorityList);
    }

    public ItemToIndex removeHead() {
        ItemToIndex item = this.itemQueue.poll();
        if (item != null) {
            --this.size;
        }
        return item;
    }

    private boolean removeFromQueue(ItemToIndex item) {
        boolean b = this.itemQueue.remove(item);
        if (b) {
            --this.size;
            boolean last = this.updateInfoNeg(item);
            if (last) {
                this.processor.getMarkerJob().releasePendingMarkersForProject(item.change.getResource().getProject());
            }
        }
        return b;
    }

    private void addItemUnsorted(ItemToIndex item) {
        this.itemQueue.add(item);
        ++this.size;
        this.updateInfoPlus(item);
    }

    private void addItemAtIndex(int index, ItemToIndex item) {
        this.itemQueue.add(index, item);
        ++this.size;
        this.updateInfoPlus(item);
    }

    private void updateInfoPlus(ItemToIndex item) {
        IProject project = null;
        if (item.change != null) {
            project = item.change.getResource().getProject();
        } else if (item.affectedLink != null) {
            LinkNode<IResource> node = item.affectedLink.getContainer();
            if (node != null) {
                project = node.getResource().getProject();
            } else {
                IFile file;
                IPath path = item.affectedLink.getPath();
                if (path != null && path.segmentCount() >= 2 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
                    project = file.getProject();
                }
            }
        }
        if (project != null) {
            SchedulerProjectInfo info = new SchedulerProjectInfo(project);
            int result = Collections.binarySearch(this.projectsInScheduler, info);
            if (result < 0) {
                int insert = -result - 1;
                this.projectsInScheduler.add(insert, info);
            } else {
                this.projectsInScheduler.get(result).increment();
            }
        }
    }

    private boolean updateInfoNeg(ItemToIndex item) {
        int newCount;
        SchedulerProjectInfo info;
        int result;
        IProject project = null;
        if (item.change != null) {
            project = item.change.getResource().getProject();
        } else if (item.affectedLink != null) {
            LinkNode<IResource> node = item.affectedLink.getContainer();
            if (node != null) {
                project = node.getResource().getProject();
            } else {
                IFile file;
                IPath path = item.affectedLink.getPath();
                if (path != null && path.segmentCount() >= 2 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
                    project = file.getProject();
                }
            }
        }
        if (project != null && (result = Collections.binarySearch(this.projectsInScheduler, info = new SchedulerProjectInfo(project))) >= 0 && (newCount = this.projectsInScheduler.get(result).decrement()) == 0) {
            this.projectsInScheduler.remove(result);
            item.lastInProject = true;
            return true;
        }
        return false;
    }

    private boolean insertSingle(ItemToIndex info) {
        boolean wasReady = false;
        boolean shouldAdd = true;
        ScheduleSorter sorter = this.getSorter();
        if (this.hasSameSortOrder(sorter) || this.itemQueue.isEmpty()) {
            int insert;
            int index = Collections.binarySearch(this.itemQueue, info, sorter);
            if (index < 0) {
                insert = -index - 1;
                if (insert == 0 && info.condition != null) {
                    if (this.currentItem == null) {
                        info.condition.setReady();
                        wasReady = true;
                    } else if (sorter.compare(info, this.currentItem) < 0) {
                        info.condition.setReady();
                        wasReady = true;
                    }
                }
            } else {
                if (this.alreadyPresent(info)) {
                    shouldAdd = false;
                }
                insert = index;
            }
            if (!wasReady && shouldAdd) {
                this.addItemAtIndex(insert, info);
                ItemToIndex i = this.addToMap(info);
                if (i != null) {
                    Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
                }
            }
            this.lastSchedulerPriorityList = sorter.getPriorityList();
            this.printSchedule(false);
        } else if (!this.alreadyPresent(info)) {
            this.addItemUnsorted(info);
            ItemToIndex i = this.addToMap(info);
            if (i != null) {
                Logger.logWarning(Logger.Category.SCHEDULE_REPLACEMENT, Logger.Mode.DEV, "Found duplicate");
            }
            this.createSchedule(null);
            if (info == this.itemQueue.peek() && info.condition != null) {
                if (this.currentItem == null) {
                    this.removeHead();
                    info.condition.setReady();
                    wasReady = true;
                } else if (sorter.compare(info, this.currentItem) < 0) {
                    this.removeHead();
                    info.condition.setReady();
                    wasReady = true;
                }
            }
        }
        return wasReady;
    }

    private boolean alreadyPresent(ItemToIndex item) {
        return this.itemQueue.contains(item);
    }

    private ItemToIndex addToMap(ItemToIndex info) {
        if (info != null && info.change != null) {
            return this.resourceToItem.put(info.change.getResource(), info);
        }
        return null;
    }

    public ItemToIndex getNextItem() {
        ItemToIndex next = null;
        try {
            this.lock.lock();
            next = this.removeHead();
            if (next != null) {
                this.updateInfoNeg(next);
                if (next.change != null) {
                    this.resourceToItem.remove(next.change.getResource());
                }
                if (next.condition != null) {
                    this.conditionSet.remove(next.condition);
                }
            }
            this.currentItem = next;
        }
        finally {
            this.lock.unlock();
        }
        return next;
    }

    public void clearActive() {
        try {
            this.lock.lock();
            this.currentItem = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void saveLinkNodeInfo() throws FatalIOException {
        SavedIndexQueue savedInfo = this.DATABASE.getSavedIndexQueue();
        if (savedInfo != null) {
            savedInfo.setLinkNodeInfos(new ArrayList<ItemToIndex>(this.itemQueue));
            this.DATABASE.updateSavedIndexQueue(savedInfo);
            if (Logger.SHOULD_TRACE_DEBUG) {
                Logger.trace(Logger.Category.DEBUG, "At shutdown " + this.itemQueue.size() + " index items were saved, to be resumed during next workbench startup.", new Throwable[]{null});
            }
        } else {
            throw new RuntimeException(Messages.save_queue_info_not_found);
        }
    }

    public void reset() {
        try {
            this.lock.lock();
            this.itemQueue.clear();
            this.resourceToItem.clear();
            this.lastSchedulerPriorityList = Collections.emptyList();
            this.projectsInScheduler.clear();
            this.conditionSet.clear();
            this.size = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void persistSavedState() {
        try {
            try {
                this.lock.lock();
                this.saveLinkNodeInfo();
            }
            catch (RuntimeException e) {
                throw new RuntimeException(Messages.exception_during_save_of_queue, e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        try {
            this.lock.lock();
            boolean bl = this.itemQueue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SchedulerCondition getExistingCondition(Set<IPath> paths) {
        try {
            this.lock.lock();
            for (SchedulerCondition cond : this.conditionSet) {
                if (!paths.equals(cond.paths)) continue;
                SchedulerCondition schedulerCondition = cond;
                return schedulerCondition;
            }
            return null;
        }
        finally {
            this.lock.unlock();
        }
    }

    LinkedHashSet<IPath> getEnclosingRoots(List<IPath> paths) {
        LinkedHashSet<IPath> roots = new LinkedHashSet<IPath>();
        if (paths.size() == 1) {
            roots.add(paths.iterator().next());
            return roots;
        }
        ArrayList<IPath> list = new ArrayList<IPath>(paths);
        while (!list.isEmpty()) {
            IPath first = list.remove(0);
            Iterator<IPath> itr = list.iterator();
            while (itr.hasNext()) {
                IPath child = itr.next();
                if (first.isPrefixOf(child)) {
                    itr.remove();
                    continue;
                }
                if (!child.isPrefixOf(first)) continue;
                first = null;
                break;
            }
            if (first == null) continue;
            roots.add(first);
        }
        return roots;
    }

    public void waitForIndexing(IProgressMonitor monitor, SearchScope scope) {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
            sub.beginTask("", 3);
            this.MANAGER.internalWaitForInit(MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            this.MANAGER.getAnnotationModelDocumentProvider().flushChanges(MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            this.cancelAndRunNow();
            this.addJob.waitForScope(scope, MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public boolean isScopeReady(IProgressMonitor monitor, SearchScope scope) {
        try {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
            sub.beginTask("", 3);
            this.MANAGER.internalWaitForInit(MonitorPolicy.monitorFor(monitor, (IProgressMonitor)sub.newChild(1)));
            try {
                this.lock.lock();
                if (!this.itemQueue.isEmpty()) {
                    return false;
                }
            }
            finally {
                this.lock.unlock();
            }
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void createSchedule(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        sub.subTask(Messages.sorting_items_to_index);
        ScheduleSorter sorter = this.getSorter();
        this.lastSchedulerPriorityList = sorter.getPriorityList();
        int doit = 1;
        if (doit == 2) {
            LinkedList list = new LinkedList(this.itemQueue.subList(0, 5));
            list.size();
            this.itemQueue.clear();
            this.itemQueue.addAll(list);
        }
        this.clearItemCaches();
        Collections.sort(this.itemQueue, sorter);
        sub.worked(1);
        this.printSchedule(true);
    }

    private void clearItemCaches() {
        for (ItemToIndex item : this.itemQueue) {
            item.cachedDependencies = -1;
        }
    }

    public void printSchedule(boolean large) {
        if (large ? Logger.SHOULD_TRACE_SCHEDULE_LARGE : Logger.SHOULD_TRACE_SCHEDULE_SMALL) {
            Logger.Category c;
            Logger.Category category = c = large ? Logger.Category.SCHEDULE_LARGE : Logger.Category.SCHEDULE_SMALL;
            if (!this.itemQueue.isEmpty()) {
                Logger.trace(c, "Schedule [start]", new Throwable[0]);
                List<String> prorities = this.getSorter().getPriorityList();
                for (String s : prorities) {
                    Logger.trace(c, "Priority: " + s, new Throwable[0]);
                }
                for (ItemToIndex index : this.itemQueue) {
                    if (index.change != null) {
                        Logger.trace(c, index.change.toString(), new Throwable[0]);
                        continue;
                    }
                    if (index.condition != null) {
                        Logger.trace(c, "Condition " + index.condition.toString(), new Throwable[0]);
                        continue;
                    }
                    Logger.trace(c, "Other " + index.toString(), new Throwable[0]);
                }
                Logger.trace(c, "Schedule [end]", new Throwable[0]);
            }
        }
    }

    public void notifyAllConditions() {
        try {
            this.lock.lock();
            if (!this.conditionSet.isEmpty()) {
                Status status = new Status(4, "com.ibm.etools.references", "Something interupted the normal notification process for threads waiting for index to finish. Notifying now to prevent threads from waiting indefinately.");
                Logger.log(Logger.Category.DEBUG, Logger.Severity.WARNING, Logger.Mode.DEV_MANDATORY, (IStatus)status);
                LinkedHashSet<SchedulerCondition> copy = new LinkedHashSet<SchedulerCondition>(this.conditionSet);
                for (SchedulerCondition condition : copy) {
                    condition.setReady();
                }
                this.conditionSet.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getItemsBeforeConditionMarker(SchedulerCondition schedulerCondition) {
        int i = -1;
        try {
            this.lock.lock();
            for (ItemToIndex index : this.itemQueue) {
                if (schedulerCondition == index.condition) {
                    break;
                }
                ++i;
            }
        }
        finally {
            this.lock.unlock();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void cancelRequestIndexing(IProgressMonitor monitor) {
        interupted = false;
        this.addJob.wakeUp();
        while (true) {
            try {
                this.addJob.join();
                if (true) ** GOTO lbl23
            }
            catch (InterruptedException v0) {
                interupted = true;
                continue;
            }
            break;
        }
        do {
            var3_3 = this.ADD_NODES;
            synchronized (var3_3) {
                try {
                    this.ADD_NODES.wait(250L);
                }
                catch (InterruptedException v1) {
                    monitor.setCanceled(true);
                    interupted = true;
                }
            }
lbl23:
            // 3 sources

        } while (this.addingNodes.get() != 0);
        if (interupted) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isProcessorActive() {
        return this.processor.getActiveThread() != null;
    }

    public boolean isAddJobReady() {
        return this.addJob.isReady();
    }

    public SchedulerCondition getOrCreateCondition(SearchScope scope) {
        try {
            this.lock.lock();
            SchedulerCondition cond = this.getExistingCondition(new HashSet<IPath>(Arrays.asList(scope.getPaths())));
            if (cond == null) {
                cond = new SchedulerCondition(scope, this, this.processor);
                this.conditionSet.add(cond);
            }
            SchedulerCondition schedulerCondition = cond;
            return schedulerCondition;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setExternalReadiness(boolean ready) {
        if (Logger.SHOULD_TRACE_DEBUG_CONDITIONS) {
            Logger.trace(Logger.Category.DEBUG_CONDITIONS, "Set external ready: " + ready, new Throwable[0]);
        }
        if (ready) {
            this.readinessLatch.countDown();
        } else {
            this.readinessLatch.countUp();
        }
    }

    public void waitForReadiness() {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.readinessLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void removeCondition(SchedulerCondition cond) {
        try {
            this.lock.lock();
            if (cond.isReady()) {
                this.conditionSet.remove(cond);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasWaitingConditions(SchedulerCondition condition) {
        try {
            this.lock.lock();
            boolean bl = this.conditionSet.contains(condition);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int waitingClients() {
        int waitingThreads = 0;
        try {
            this.lock.lock();
            for (SchedulerCondition cond : this.conditionSet) {
                waitingThreads += cond.getWaitingThreads().size();
            }
        }
        finally {
            this.lock.unlock();
        }
        return waitingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleProcessor() {
        if (InternalAPI.Tweaks.SCHEDULER_MIN_SIZE_BEFORE_INDEX >= 0) {
            int localSize;
            if (InternalAPI.Tweaks.SHOULD_AVOID_SCHEDULE_DURING_BUILD) {
                Assert.isLegal((boolean)false, (String)"Cannot set both SCHEDULER_MIN_SIZE_BEFORE_INDEX >=0 and AVOID_SCHEDULE_DURING_BUILD");
            }
            try {
                this.lock.lock();
                localSize = this.size;
            }
            finally {
                this.lock.unlock();
            }
            if (localSize >= InternalAPI.Tweaks.SCHEDULER_MIN_SIZE_BEFORE_INDEX) {
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    if (this.timedSchedule != null) {
                        if (this.cancelAndWait()) {
                            this.processor.ensureUpToDate.set(true);
                            this.processor.doSchedule(false);
                        }
                    } else {
                        this.processor.ensureUpToDate.set(true);
                        this.processor.doSchedule(false);
                    }
                }
            } else {
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    this.cancelAndWait();
                    this.timedSchedule = new InternalReferencesJob(new Runnable(){

                        @Override
                        public void run() {
                            ((Scheduler)Scheduler.this).processor.ensureUpToDate.set(true);
                            Scheduler.this.processor.doSchedule(false);
                        }
                    });
                    this.timedSchedule.schedule(InternalAPI.Tweaks.SCHEDULER_MIN_SIZE_BEFORE_INDEX_MAX_WAIT, TimeUnit.MILLISECONDS);
                }
            }
        } else {
            this.processor.ensureUpToDate.set(true);
            this.processor.doSchedule(false);
        }
    }

    private List<Job> getRunningJobs(Object family) {
        QualifiedName infrastructureJob = new QualifiedName("org.eclipse.ui", "INFRASTRUCTURE_PROPERTY");
        Thread current = Thread.currentThread();
        ArrayList<Job> jobs = new ArrayList<Job>();
        jobs.addAll(Arrays.asList(this.manager.find(family)));
        Iterator iterator = jobs.iterator();
        while (iterator.hasNext()) {
            Job job = (Job)iterator.next();
            if (job.getState() == 4 && job.getThread() != current && !job.belongsTo(ReferenceManager.class) && job.getProperty(infrastructureJob) == null) continue;
            iterator.remove();
        }
        return jobs;
    }

    public void avoidOtherJobs(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        boolean interrupted = false;
        List<Job> jobs = this.getRunningJobs(null);
        boolean setMsg = false;
        while (!jobs.isEmpty() && this.waitingClients() == 0 && !sub.isCanceled()) {
            if (!setMsg) {
                Status status = new Status(1, "com.ibm.etools.references", Messages.pause_indexing0);
                sub.setBlocked((IStatus)status);
                setMsg = true;
            }
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                break;
            }
            jobs = this.getRunningJobs(null);
        }
        if (setMsg) {
            sub.clearBlocked();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAndRunNow() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.timedSchedule != null) {
                this.timedSchedule.cancelJoin();
                this.processor.ensureUpToDate.set(true);
                this.processor.doSchedule(false);
                this.timedSchedule = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelAndWait() {
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.timedSchedule != null) {
                this.timedSchedule.cancelJoin();
                this.processor.ensureUpToDate.set(true);
                this.processor.doSchedule(false);
                this.timedSchedule = null;
            }
        }
        return true;
    }

    public void boostPriority() {
        this.addJob.boostPriority();
    }

    public void shutdown() {
        this.cancelRequestIndexing(null);
        this.MANAGER.getAnnotationModelDocumentProvider().flushChanges(null);
        this.cancelAndRunNow();
    }

    public InternalAPI.LinkDelta getQueuedLinkDelta(ILink link) {
        this.lock.lock();
        try {
            for (ItemToIndex item : this.itemQueue) {
                if (item.affectedLink != link) continue;
                InternalAPI.LinkDelta delta = new InternalAPI.LinkDelta();
                if (item.linkType == ReferenceEvent.Kind.REMOVE) {
                    delta.kind = 2;
                } else if (item.linkType == ReferenceEvent.Kind.ADD) {
                    delta.kind = 1;
                } else {
                    throw new RuntimeException("Unknown kind");
                }
                delta.modelinstanceref = item.modelinstanceref;
                delta.link = link;
                InternalAPI.LinkDelta linkDelta = delta;
                return linkDelta;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    public class FilteredIndexItems {
        Collection<ItemToIndex> items = new ArrayList<ItemToIndex>();
        public int ignoredContainsLinks;
        public int ignoredCompletely;
        public int added;

        public void add(ItemToIndex indexItem) {
            this.items.add(indexItem);
        }
    }
}

