/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.internal.management.DependencyUtil;
import com.ibm.etools.references.internal.management.ItemToIndex;
import com.ibm.etools.references.internal.services.LinkTransformerService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class ScheduleSorter
implements Comparator<ItemToIndex> {
    private final List<IPath> priorityList;
    private final LinkTransformerService.TransformerCache transformerCache = LinkTransformerService.getInstance().newCache();

    public ScheduleSorter(List<IPath> priorityList) {
        this.priorityList = priorityList;
    }

    public List<String> getPriorityList() {
        ArrayList<String> list = new ArrayList<String>(this.priorityList.size());
        for (IPath path : this.priorityList) {
            list.add(path.toString());
        }
        return list;
    }

    @Override
    public int compare(ItemToIndex item1, ItemToIndex item2) {
        int val;
        IPath r2;
        if (item1.condition != null && item2.condition != null) {
            if (item1.condition.workspace && item1.condition.workspace == item2.condition.workspace) {
                return 0;
            }
        } else {
            if (item1.condition != null && item1.condition.workspace) {
                return 1;
            }
            if (item2.condition != null && item2.condition.workspace) {
                return -1;
            }
        }
        Set<IPath> c1paths = null;
        Set<IPath> c2paths = null;
        if (item1.condition != null) {
            c1paths = item1.condition.paths;
        }
        if (item2.condition != null) {
            c2paths = item2.condition.paths;
        }
        if (item1.affectedLink == null && item2.affectedLink != null) {
            return 1;
        }
        if (item1.affectedLink != null && item2.affectedLink == null) {
            return -1;
        }
        if (item1.affectedLink != null && item2.affectedLink != null) {
            return 0;
        }
        IPath r1 = c1paths == null ? item1.change.getResource().getFullPath() : null;
        IPath iPath = r2 = c2paths == null ? item2.change.getResource().getFullPath() : null;
        if (c1paths != null && c2paths != null) {
            int c1index = -1;
            for (IPath path : c1paths) {
                c1index = Math.max(c1index, this.indexOf(path));
            }
            int c2index = -1;
            for (IPath path : c2paths) {
                c2index = Math.max(c2index, this.indexOf(path));
            }
            return c1index == c2index ? 0 : (c1index < c2index ? -1 : 1);
        }
        if (c1paths != null || c2paths != null) {
            IPath r;
            Set<IPath> cPaths = c1paths == null ? c2paths : c1paths;
            IPath iPath2 = r = r1 == null ? r2 : r1;
            if (r != null) {
                int pathIndex = r1 == null ? this.indexOf(r2) : this.indexOf(r1);
                int condIndex = Integer.MAX_VALUE;
                for (IPath path : cPaths) {
                    condIndex = Math.min(condIndex, this.indexOf(path));
                }
                if (pathIndex == condIndex) {
                    boolean lower = true;
                    for (IPath iPath3 : cPaths) {
                        boolean bl = lower = r.toString().compareTo(iPath3.toString()) < 0;
                        if (!lower) break;
                    }
                    return lower ? (c1paths == null ? 1 : -1) : (c1paths == null ? -1 : 1);
                }
                if (pathIndex < condIndex) {
                    return c1paths == null ? -1 : 1;
                }
                boolean conditionMatchesResource = false;
                for (IPath iPath3 : cPaths) {
                    boolean bl = conditionMatchesResource = r.equals((Object)iPath3) || iPath3.isPrefixOf(r);
                    if (conditionMatchesResource) break;
                }
                if (conditionMatchesResource) {
                    return c1paths == null ? -1 : 1;
                }
                return c1paths == null ? 1 : -1;
            }
            Assert.isNotNull(c1paths, (String)"Invalid condition to condition comparison");
            Assert.isNotNull(c2paths, (String)"Invalid condition to condition comparison");
            int condIndex1 = Integer.MAX_VALUE;
            for (IPath path : c1paths) {
                condIndex1 = Math.min(condIndex1, this.indexOf(path));
            }
            int condIndex2 = Integer.MAX_VALUE;
            for (IPath path : c2paths) {
                condIndex2 = Math.min(condIndex2, this.indexOf(path));
            }
            if (condIndex1 == condIndex2) {
                return 0;
            }
            return condIndex1 < condIndex2 ? -1 : 1;
        }
        int i1 = this.indexOf(r1);
        int i2 = this.indexOf(r2);
        if (i1 == Integer.MAX_VALUE && i2 != Integer.MAX_VALUE) {
            return 1;
        }
        if (i1 != Integer.MAX_VALUE && i2 == Integer.MAX_VALUE) {
            return -1;
        }
        if (i1 == i2) {
            int dep2;
            int dep1;
            if (item1.cachedDependencies > -1) {
                dep1 = item1.cachedDependencies;
            } else {
                item1.cachedDependencies = dep1 = DependencyUtil.getDepedentLinks(item1, this.transformerCache);
            }
            if (item2.cachedDependencies > -1) {
                dep2 = item2.cachedDependencies;
            } else {
                item2.cachedDependencies = dep2 = DependencyUtil.getDepedentLinks(item2, this.transformerCache);
            }
            val = dep2 < dep1 ? -1 : (dep2 == dep1 ? 0 : 1);
        } else {
            int n = i1 < i2 ? -1 : (val = i1 == i2 ? 0 : 1);
        }
        if (val == 0) {
            val = r1.toString().compareTo(r2.toString());
        }
        return val;
    }

    private int indexOf(IPath resource) {
        IPath child = resource;
        int index = Integer.MAX_VALUE;
        while (child.segments().length > 0) {
            int i = this.priorityList.indexOf(child);
            if (i >= 0) {
                index = i;
            }
            child = child.removeLastSegments(1);
        }
        return index;
    }
}

