/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.internal.bplustree.db.DBRecord;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.management.CreateOrUpdateMarkersJob;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SavedMarkerQueue
extends DBRecord {
    private Collection<CreateOrUpdateMarkersJob.WorkItem> writeOutItems;
    private Collection<CreateOrUpdateMarkersJob.WorkItem> readInItems;

    public SavedMarkerQueue(int dataType) {
        super(dataType);
    }

    @Override
    public void readRecord(PooledByteBuffer bytes) {
        this.readInItems = new ArrayList<CreateOrUpdateMarkersJob.WorkItem>();
        int numRecords = ByteUtils.bytesToUnsignedShort(bytes.buffer);
        int i = 0;
        while (i < numRecords) {
            int resourceType;
            int type = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            CreateOrUpdateMarkersJob.WorkItem info = new CreateOrUpdateMarkersJob.WorkItem(type);
            info.checkProjects = ByteUtils.bytesToBoolean(bytes.buffer);
            if (ByteUtils.bytesToBoolean(bytes.buffer)) {
                info.brokenreference = new BrokenReference(null);
                info.brokenreference.readRecord(bytes);
            }
            String pathName = (resourceType = ByteUtils.bytesToUnsignedShort(bytes.buffer)) != 65535 ? ByteUtils.bytesToString(bytes.buffer) : null;
            IFile res = null;
            if (resourceType == 1) {
                res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathName));
            } else if (resourceType == 2) {
                res = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(pathName));
            } else if (resourceType == 4) {
                res = ResourcesPlugin.getWorkspace().getRoot().getProject(pathName);
            } else if (resourceType != 65535) {
                Assert.isLegal((boolean)false, (String)("Unknown resource type: " + resourceType));
            }
            info.resource = res;
            info.link = ReferenceDatabase.getDefault().getReferenceElement(ByteUtils.bytesToInt(bytes.buffer), ILink.class);
            this.readInItems.add(info);
            bytes.returnBuffer();
            ++i;
        }
    }

    @Override
    public PooledByteBuffer writeRecord() {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        if (this.writeOutItems == null) {
            this.writeOutItems = new LinkedList<CreateOrUpdateMarkersJob.WorkItem>();
        }
        int numLinkNodes = this.writeOutItems.size();
        buffers.add(ByteUtils.unsignedShortToBytes(numLinkNodes));
        for (CreateOrUpdateMarkersJob.WorkItem info : this.writeOutItems) {
            buffers.add(ByteUtils.unsignedShortToBytes(info.type));
            buffers.add(ByteUtils.booleanToBytes(info.checkProjects));
            if (info.brokenreference == null) {
                buffers.add(ByteUtils.booleanToBytes(false));
            } else {
                buffers.add(ByteUtils.booleanToBytes(true));
                buffers.add(info.brokenreference.writeRecord().buffer);
            }
            if (info.resource == null) {
                buffers.add(ByteUtils.unsignedShortToBytes(-1));
            } else {
                buffers.add(ByteUtils.unsignedShortToBytes(info.resource.getType()));
                buffers.add(ByteUtils.stringToBytes(info.resource.getFullPath().toString()));
            }
            if (info.link == null) {
                buffers.add(ByteUtils.intToBytes(-1));
                continue;
            }
            buffers.add(ByteUtils.intToBytes(info.link.getId()));
        }
        int size = 0;
        for (ByteBuffer byteBuffer : buffers) {
            size += byteBuffer.limit();
        }
        PooledByteBuffer result = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
        for (ByteBuffer byteBuffer : buffers) {
            result.buffer.put(byteBuffer);
        }
        result.buffer.rewind();
        return result;
    }

    public void setSavedMarkerQueue(Collection<CreateOrUpdateMarkersJob.WorkItem> writeOutItems) {
        this.writeOutItems = writeOutItems;
    }

    public Collection<CreateOrUpdateMarkersJob.WorkItem> getSavedMarkerQueue() {
        if (this.readInItems == null) {
            return Collections.emptyList();
        }
        return this.readInItems;
    }
}

