/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.internal.cache.ARCCache;
import com.ibm.etools.references.internal.cache.Cache;
import com.ibm.etools.references.internal.management.InternalReference;
import com.ibm.etools.references.internal.management.ResolvedReference;
import com.ibm.etools.references.management.ILink;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResolverCache {
    private final Cache<String, ResolvedReference> cache = new ARCCache<String, ResolvedReference>(InternalAPI.Tweaks.RESOLVER_CACHE_SIZE){
        private static final long serialVersionUID = 1L;

        @Override
        protected void removeFromCache(String key, ResolvedReference value) {
            ResolverCache.this.linkToKey.remove(key);
        }
    };
    private final Map<ILink, List<String>> linkToKey = new HashMap<ILink, List<String>>();

    void addReference(InternalReference reference, InternalReference previous, ResolvedReference rr) {
        if (rr != null && rr.getTarget() != null) {
            String key = this.getKey(reference, previous);
            this.cache.put(key, rr);
            List<String> c = this.linkToKey.get(rr.getTarget());
            if (c == null) {
                c = new ArrayList<String>();
                this.linkToKey.put(rr.getTarget(), c);
            }
            c.add(key);
        }
    }

    ResolvedReference getCachedResolvedReference(InternalReference reference, InternalReference previous) {
        String key = this.getKey(reference, previous);
        return this.cache.get(key);
    }

    private String getKey(InternalReference reference, InternalReference previous) {
        ILink source;
        String key = "";
        if (previous == null) {
            key = "null";
        } else {
            source = previous.getSource();
            if (source != null) {
                if (source.isCrossProjectAddressable()) {
                    key = String.valueOf(key) + "XPA";
                } else if (source.getContainer() != null) {
                    key = String.valueOf(key) + source.getContainer().getResource().getProject().getName();
                }
                key = String.valueOf(key) + previous.getCachingKey();
            }
        }
        source = reference.getSource();
        if (source != null) {
            if (source.isCrossProjectAddressable()) {
                key = String.valueOf(key) + "XPA";
            } else if (source.getContainer() != null) {
                key = String.valueOf(key) + source.getContainer().getResource().getProject().getName();
            }
            key = String.valueOf(key) + reference.getCachingKey();
        }
        return key;
    }

    void removeRRforLink(ILink link) {
        List<String> c = this.linkToKey.remove(link);
        if (c != null) {
            for (String key : c) {
                if (key == null) continue;
                this.cache.remove(key);
            }
        }
    }

    public void reset() {
        this.cache.clear();
        this.linkToKey.clear();
    }

    public void printCacheStats(PrintStream out) {
        out.println("Resolver Cache:");
        out.println("\tHit ratio: " + this.cache.getHitRatio());
    }

    public void resetCacheStats() {
        this.cache.resetStats();
    }
}

