/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.Link;
import com.ibm.etools.references.internal.nls.Messages;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenStatus;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.services.providers.IProvider;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public class ResolvedReference
extends InternalReferenceObject
implements IResolvedReference {
    TempResolved info;
    List<LinkKey> originalKeys = null;
    final Record record = new Record(this);
    int targetId = -1;
    int refId = -1;
    int prevId = -1;
    int nextId = -1;
    boolean nodeIdLink;
    int modelInstanceId = -1;
    int broken;
    private ResolvedReference snapshot;

    public ResolvedReference() {
        this.record.dirty = true;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.getAdapterFor(adapter);
    }

    private <T> T getAdapterFor(Class<T> adapter) {
        IProvider p;
        if (adapter.isAssignableFrom(this.getClass())) {
            return adapter.cast(this);
        }
        if (IProvider.class.isAssignableFrom(adapter) && (p = InternalAPI.getProviderById(this.getProviderId())) != null) {
            try {
                return adapter.cast(p);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return adapter.cast(Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName()));
    }

    private TempResolved getInfo() {
        if (this.info == null) {
            this.info = new TempResolved();
        }
        return this.info;
    }

    @Override
    public int getId() {
        return super.getId();
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.RESOLVED_REFERENCE;
    }

    @Override
    public BrokenStatus getBrokenStatus() {
        this.loadData();
        return BrokenStatus.values()[this.broken];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokenLinkInfo(String brokenLinkInfo) {
        boolean equal;
        this.loadData();
        String oldInfo = this.getModelInstanceIdReference();
        Object object = this.record;
        synchronized (object) {
            equal = Util.isEqualOrBothNull(oldInfo, brokenLinkInfo);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().modelInstanceId = brokenLinkInfo;
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReference(Reference reference) {
        boolean equal;
        this.loadData();
        Reference r = this.getReference();
        Object object = this.record;
        synchronized (object) {
            equal = Util.isEqualOrBothNull(r, reference);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                if (reference == null) {
                    this.refId = -1;
                } else if (reference.getId() >= 0) {
                    this.refId = reference.getId();
                } else {
                    this.getInfo().reference = reference;
                }
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeIdLinkTarget(boolean nodeIdLinkTarget) {
        boolean equal;
        this.loadData();
        Object object = this.record;
        synchronized (object) {
            equal = this.isNodeIdLinkTarget() == nodeIdLinkTarget;
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.nodeIdLink = nodeIdLinkTarget;
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNext(IResolvedReference next) {
        boolean equal;
        this.loadData();
        Object object = this.record;
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getNext(), next);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                if (next == null) {
                    this.nextId = -1;
                    this.getInfo().next = null;
                } else if (next.getId() >= 0) {
                    this.nextId = next.getId();
                } else {
                    this.getInfo().next = next;
                }
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokenStatus(BrokenStatus broken) {
        boolean equal;
        this.loadData();
        Object object = this.record;
        synchronized (object) {
            equal = this.getBrokenStatus() == broken;
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.broken = broken.ordinal();
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResolvedReference getNext() {
        this.loadData();
        Record record = this.record;
        synchronized (record) {
            if (this.info != null && this.info.next != null) {
                return this.info.next;
            }
        }
        if (this.nextId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.nextId, IResolvedReference.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrevious(IResolvedReference previous) {
        boolean equal;
        this.loadData();
        IResolvedReference p = this.getPrevious();
        Object object = this.record;
        synchronized (object) {
            equal = Util.isEqualOrBothNull(p, previous);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                if (previous == null) {
                    this.prevId = -1;
                    this.getInfo().previous = null;
                } else if (previous.getId() >= 0) {
                    this.prevId = previous.getId();
                } else {
                    this.getInfo().previous = previous;
                }
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
            if (previous != null) {
                ((ResolvedReference)previous).setNext(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResolvedReference getPrevious() {
        this.loadData();
        Record record = this.record;
        synchronized (record) {
            if (this.info != null && this.info.previous != null) {
                return this.info.previous;
            }
        }
        if (this.prevId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.prevId, IResolvedReference.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTarget(ILink target) {
        boolean equal;
        this.loadData();
        ILink t = this.getTarget();
        Object object = this.record;
        synchronized (object) {
            if (target != null) {
                Assert.isLegal((target.getId() >= 0 ? 1 : 0) != 0, (String)Messages.ResolvedReference_1);
            }
            equal = Util.isEqualOrBothNull(t, target);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.targetId = target == null ? -1 : target.getId();
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    @Override
    public ILink getTarget() {
        this.loadData();
        if (this.targetId != -1 && this.targetId != -99) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.targetId, ILink.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getReference() {
        this.loadData();
        Record record = this.record;
        synchronized (record) {
            if (this.info != null && this.info.reference != null) {
                Assert.isTrue((boolean)this.record.dirty, (String)Messages.ResolvedReference_2);
                return this.info.reference;
            }
        }
        if (this.refId >= 0) {
            return ReferenceDatabase.getDefault().getReferenceElement(this.refId, Reference.class);
        }
        return null;
    }

    @Override
    public int getReferenceId() {
        return this.refId;
    }

    @Override
    public TextRange getFragmentLocation() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getFragmentLocation();
    }

    @Override
    public TextRange getAbsoluteFragmentLocation() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getAbsoluteFragmentLocation();
    }

    @Override
    public String getFragmentText() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getFragmentText();
    }

    @Override
    public InternalReferenceRecord getRecord() {
        return this.record;
    }

    @Override
    public ILink getSource() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getSource();
    }

    @Override
    public String getReferenceType() {
        Reference r = this.getReference();
        if (r == null) {
            return null;
        }
        return r.getReferenceType();
    }

    @Override
    public String toString() {
        if (InternalAPI.LOAD_DATA_FOR_TO_STRING) {
            this.loadData();
        }
        if (this.isSnapshot()) {
            String toString = "Snap: ";
            toString = String.valueOf(toString) + this.getElementType().name();
            toString = String.valueOf(toString) + " ";
            toString = String.valueOf(toString) + super.toString();
            toString = String.valueOf(toString) + " REF: ";
            toString = String.valueOf(toString) + "[ " + this.getReferenceId() + "] ";
            toString = String.valueOf(toString) + " TARGET: [";
            toString = this.getTarget() == null ? String.valueOf(toString) + "null] " : String.valueOf(toString) + this.getTarget().getId() + "] ";
            toString = String.valueOf(toString) + " isBroken: ";
            toString = String.valueOf(toString) + "[ " + (Object)((Object)this.getBrokenStatus()) + "] ";
            toString = String.valueOf(toString) + " next: ";
            toString = this.getNext() == null ? String.valueOf(toString) + "[ null] " : String.valueOf(toString) + "[ " + this.getNext().getId() + "] ";
            toString = String.valueOf(toString) + " prev: ";
            toString = this.getPrevious() == null ? String.valueOf(toString) + "[ null] " : String.valueOf(toString) + "[ " + this.getPrevious().getId() + "] ";
            toString = String.valueOf(toString) + " nodeIdLink [" + this.isNodeIdLinkTarget() + "]";
            toString = String.valueOf(toString) + " modelInstanceId: ";
            toString = String.valueOf(toString) + "[ " + this.getModelInstanceIdReference() + "] ";
            if (this.providerId >= 0) {
                toString = String.valueOf(toString) + " Provided by: " + Service.getProviderType(this.providerId) + "(" + Service.getProviderClass(this.providerId) + ")";
            }
            return toString;
        }
        if (this.info != null) {
            String toString = "Unsaved: ";
            toString = String.valueOf(toString) + this.getElementType().name();
            toString = String.valueOf(toString) + " ";
            toString = String.valueOf(toString) + super.toString();
            toString = String.valueOf(toString) + " REF: ";
            toString = String.valueOf(toString) + "[ " + this.refId + "] ";
            toString = String.valueOf(toString) + " TARGET: [";
            toString = String.valueOf(toString) + "[ " + this.targetId + "] ";
            toString = String.valueOf(toString) + " isBroken: ";
            toString = String.valueOf(toString) + "[ " + (Object)((Object)this.info.broken) + "] ";
            toString = String.valueOf(toString) + " next: ";
            toString = String.valueOf(toString) + "[ " + this.info.next + "] ";
            toString = String.valueOf(toString) + " prev: ";
            toString = String.valueOf(toString) + "[ " + this.info.previous + "] ";
            toString = String.valueOf(toString) + " nodeIdLink [" + this.nodeIdLink + "]";
            toString = String.valueOf(toString) + " modelInstanceId: ";
            toString = String.valueOf(toString) + "[ " + this.info.modelInstanceId + "] ";
            if (this.providerId >= 0) {
                toString = String.valueOf(toString) + " Provided by: " + Service.getProviderType(this.providerId) + "(" + Service.getProviderClass(this.providerId) + ")";
            }
            return toString;
        }
        if (this.record.isFullyLoaded()) {
            String toString = "FullyLoaded: ";
            toString = String.valueOf(toString) + this.getElementType().name();
            toString = String.valueOf(toString) + " ";
            toString = String.valueOf(toString) + super.toString();
            toString = String.valueOf(toString) + " REF: ";
            toString = String.valueOf(toString) + "[ " + this.refId + "] ";
            toString = String.valueOf(toString) + " TARGET: [";
            toString = String.valueOf(toString) + this.targetId + "] ";
            toString = String.valueOf(toString) + " isBroken: ";
            toString = String.valueOf(toString) + "[ " + (Object)((Object)this.getBrokenStatus()) + "] ";
            toString = String.valueOf(toString) + " next: ";
            toString = String.valueOf(toString) + "[ " + this.nextId + "] ";
            toString = String.valueOf(toString) + " prev: ";
            toString = String.valueOf(toString) + "[ " + this.prevId + "] ";
            toString = String.valueOf(toString) + " nodeIdLink [" + this.nodeIdLink + "]";
            toString = String.valueOf(toString) + " modelInstanceId: ";
            toString = String.valueOf(toString) + "[ " + this.modelInstanceId + "] ";
            if (this.providerId >= 0) {
                toString = String.valueOf(toString) + " Provided by: " + Service.getProviderType(this.providerId) + "(" + Service.getProviderClass(this.providerId) + ")";
            }
            return toString;
        }
        String toString = "";
        toString = String.valueOf(toString) + this.getElementType().name();
        toString = String.valueOf(toString) + "Proxy object: ";
        toString = String.valueOf(toString) + super.toString();
        return toString;
    }

    public void copyFrom(ResolvedReference ref) {
        this.setBrokenStatus(ref.getBrokenStatus());
        this.setReference(ref.getReference());
        this.setTarget(ref.getTarget());
        this.setBrokenLinkInfo(ref.getModelInstanceIdReference());
    }

    @Override
    public String getModelInstanceIdReference() {
        this.loadData();
        if (this.info != null && this.info.modelInstanceId != null) {
            return this.info.modelInstanceId;
        }
        return ReferenceDatabase.getDefault().getString(this.modelInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOriginal() {
        if (this.getId() == -1) {
            return;
        }
        ResolvedReference resolvedReference = this;
        synchronized (resolvedReference) {
            this.loadData();
            if (this.frozen) {
                if (this.originalKeys == null) {
                    this.originalKeys = IndexManager.getKeys(this);
                }
                if (this.snapshot == null) {
                    this.snapshot = this.snapshot((Map)new HashMap(1, 1.0f));
                }
            }
        }
    }

    @Override
    public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
        IResolvedReference next;
        Reference reference;
        this.loadData();
        if (graph.contains(this)) {
            return;
        }
        if (objMarkers.containsKey(this)) {
            return;
        }
        objMarkers.put(this, this);
        ILink target = this.getTarget();
        if (target != null) {
            ((InternalReferenceObject)((Object)target)).getObjectGraph(graph, objMarkers);
            graph.add((InternalReferenceObject)((Object)target));
        }
        if ((reference = this.getReference()) != null) {
            ((InternalReferenceObject)reference).getObjectGraph(graph, objMarkers);
        }
        graph.add(reference);
        IResolvedReference previous = this.getPrevious();
        if (previous != null) {
            ((InternalReferenceObject)((Object)previous)).getObjectGraph(graph, objMarkers);
        }
        if ((next = this.getNext()) != null) {
            ((InternalReferenceObject)((Object)next)).getObjectGraph(graph, objMarkers);
        }
        graph.add(this);
    }

    @Override
    protected synchronized List<LinkKey> getOriginalKeys() {
        return this.originalKeys;
    }

    @Override
    protected ResolvedReference getOriginal() {
        return this.snapshot;
    }

    @Override
    protected synchronized void clearOriginalKeys() {
        this.originalKeys = null;
        this.snapshot = null;
    }

    public boolean isNodeIdLinkTarget() {
        this.loadData();
        return this.nodeIdLink;
    }

    @Override
    public boolean isSnapshot() {
        return false;
    }

    @Override
    public ResolvedReference snapshot(Map<IReferenceElement, IReferenceElement> snapMap) {
        ILink target;
        IResolvedReference next;
        IResolvedReference previous;
        if (!InternalAPI.Tweaks.SHOULD_USE_SNAPSHOT) {
            return this;
        }
        IReferenceElement snap = snapMap.get(this);
        if (snap != null) {
            return (ResolvedReference)snap;
        }
        snapMap.put(this, this);
        Reference ref = this.getReference();
        if (ref != null) {
            ref.snapshot((Map)snapMap);
        }
        if ((previous = this.getPrevious()) != null) {
            ((ResolvedReference)previous).snapshot((Map)snapMap);
        }
        if ((next = this.getNext()) != null) {
            ((ResolvedReference)next).snapshot((Map)snapMap);
        }
        if ((target = this.getTarget()) != null) {
            ((Link)target).snapshot((Map)snapMap);
        }
        BrokenStatus status = this.getBrokenStatus();
        String modelId = this.getModelInstanceIdReference();
        snap = new ResolvedReferenceSnapshot(this.getId(), (Reference)snapMap.get(ref), (ResolvedReference)snapMap.get(previous), (ResolvedReference)snapMap.get(next), (Link)snapMap.get(target), status, modelId, this.isNodeIdLinkTarget());
        snapMap.put(this, snap);
        return (ResolvedReference)snap;
    }

    static class Record
    extends InternalReferenceRecord {
        private final ResolvedReference resolved;
        boolean dirty;

        public Record(ResolvedReference resolved) {
            super(IReferenceElement.ElementType.RESOLVED_REFERENCE.ordinal());
            this.resolved = resolved;
        }

        @Override
        protected void clean() {
            this.dirty = false;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void doReadRecord(PooledByteBuffer bytes) {
            this.resolved.targetId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.refId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.broken = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.resolved.prevId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.nextId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.modelInstanceId = ByteUtils.bytesToInt(bytes.buffer);
            this.resolved.providerId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.resolved.nodeIdLink = ByteUtils.bytesToBoolean(bytes.buffer);
            bytes.returnBuffer();
            this.clean();
            this.resolved.freeze();
        }

        @Override
        protected int[] getStringIds() {
            return new int[]{this.resolved.modelInstanceId};
        }

        @Override
        protected void aboutToUpdate(ReferenceEvent.Kind kind) {
            if (this.resolved.info == null) {
                return;
            }
            if (this.resolved.info != null && this.resolved.info.reference != null) {
                this.resolved.refId = this.resolved.info.reference.getId();
            }
            if (this.resolved.info != null && this.resolved.info.previous != null) {
                this.resolved.prevId = this.resolved.info.previous.getId();
            }
            if (this.resolved.info != null && this.resolved.info.next != null) {
                this.resolved.nextId = this.resolved.info.next.getId();
            }
            if (this.resolved.info != null && this.resolved.info.modelInstanceId != null) {
                int id;
                this.resolved.modelInstanceId = id = ReferenceDatabase.getDefault().updateString(this.resolved.modelInstanceId, this.resolved.info.modelInstanceId);
            }
            this.resolved.info = null;
        }

        @Override
        public PooledByteBuffer doWriteRecord() {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            buffers.add(ByteUtils.intToBytes(this.resolved.targetId));
            buffers.add(ByteUtils.intToBytes(this.resolved.refId));
            buffers.add(ByteUtils.unsignedShortToBytes(this.resolved.broken));
            buffers.add(ByteUtils.intToBytes(this.resolved.prevId));
            buffers.add(ByteUtils.intToBytes(this.resolved.nextId));
            buffers.add(ByteUtils.intToBytes(this.resolved.modelInstanceId));
            buffers.add(ByteUtils.unsignedShortToBytes(this.resolved.providerId));
            buffers.add(ByteUtils.booleanToBytes(this.resolved.nodeIdLink));
            int size = 0;
            for (ByteBuffer byteBuffer : buffers) {
                size += byteBuffer.limit();
            }
            PooledByteBuffer buffer = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
            for (ByteBuffer byteBuffer : buffers) {
                buffer.buffer.put(byteBuffer);
            }
            buffer.buffer.rewind();
            return buffer;
        }

        @Override
        public int getSize() {
            int size = 25;
            return size;
        }

        @Override
        protected InternalReferenceObject getLinkArtifact() {
            return this.resolved;
        }

        @Override
        protected Collection<? extends IReferenceElement> getDeleteCascade() {
            IResolvedReference next = this.resolved.getNext();
            if (next == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(next);
        }
    }

    static class ResolvedReferenceSnapshot
    extends ResolvedReference {
        private final int id;
        private final Reference internalReference;
        private final ResolvedReference previous;
        private final ResolvedReference next;
        private final Link target;
        private final String modelId;

        public ResolvedReferenceSnapshot(int id, Reference reference, ResolvedReference previous, ResolvedReference next, Link target, BrokenStatus status, String modelId, boolean nodeIdLink) {
            this.id = id;
            this.internalReference = reference;
            this.previous = previous;
            this.next = next;
            this.target = target;
            this.modelId = modelId;
            this.broken = status.ordinal();
            this.nodeIdLink = nodeIdLink;
        }

        @Override
        protected synchronized void clearOriginalKeys() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public boolean isSnapshot() {
            return true;
        }

        @Override
        public void copyFrom(ResolvedReference ref) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getModelInstanceIdReference() {
            return this.modelId;
        }

        @Override
        public IResolvedReference getNext() {
            return this.next;
        }

        @Override
        public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public ResolvedReference snapshot(Map<IReferenceElement, IReferenceElement> snapMap) {
            return this;
        }

        @Override
        protected synchronized List<LinkKey> getOriginalKeys() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public IResolvedReference getPrevious() {
            return this.previous;
        }

        @Override
        public InternalReferenceRecord getRecord() {
            return null;
        }

        @Override
        public Reference getReference() {
            return this.internalReference;
        }

        @Override
        public int getReferenceId() {
            Reference r = this.getReference();
            return r == null ? -1 : r.getId();
        }

        @Override
        public String getReferenceType() {
            return super.getReferenceType();
        }

        @Override
        public ILink getSource() {
            return super.getSource();
        }

        @Override
        public ILink getTarget() {
            return this.target;
        }

        @Override
        public boolean isNodeIdLinkTarget() {
            return super.isNodeIdLinkTarget();
        }

        @Override
        public void setBrokenLinkInfo(String brokenLinkInfo) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setBrokenStatus(BrokenStatus broken) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        protected void setNext(IResolvedReference next) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setNodeIdLinkTarget(boolean nodeIdLinkTarget) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setPrevious(IResolvedReference previous) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setReference(Reference reference) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setTarget(ILink target) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public void freeze() {
        }

        @Override
        public void init(ExtentManager manager) {
        }

        @Override
        protected boolean isFrozen() {
            return true;
        }

        @Override
        public void loadData() {
        }

        @Override
        public void markLoaded() {
        }
    }

    static class TempResolved {
        IResolvedReference next;
        IResolvedReference previous;
        Reference reference;
        String modelInstanceId;
        BrokenStatus broken;
        public Object tempPrevious;

        TempResolved() {
        }

        public String toString() {
            return super.toString();
        }
    }
}

