/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.management.IReferenceStatus;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ReferenceStatus
extends Status
implements IReferenceStatus {
    protected IPath path;
    protected String string;
    protected static final IStatus[] NO_CHILDREN = new IStatus[0];
    protected IStatus[] children = NO_CHILDREN;

    public static IReferenceStatus newMultiStatus(IReferenceStatus[] children, int code) {
        ReferenceStatus jms = new ReferenceStatus(code);
        jms.children = children;
        return jms;
    }

    public static IReferenceStatus newMultiStatus(IReferenceStatus[] children, String string) {
        ReferenceStatus jms = new ReferenceStatus();
        jms.string = string;
        jms.children = children;
        return jms;
    }

    public ReferenceStatus() {
        super(4, "com.ibm.etools.references", 0, "ReferenceStatus", null);
    }

    public ReferenceStatus(int code) {
        super(4, "com.ibm.etools.references", code, "ReferenceStatus", null);
    }

    public ReferenceStatus(int code, String string) {
        this(4, code, string);
    }

    public ReferenceStatus(int severity, int code, String string) {
        super(severity, "com.ibm.etools.references", code, "ReferenceStatus", null);
        this.string = string;
    }

    public ReferenceStatus(int severity, int code, String string, Throwable throwable) {
        super(severity, "com.ibm.etools.references", code, "ReferenceStatus", throwable);
        this.string = string;
    }

    public boolean isMultiStatus() {
        return this.children != NO_CHILDREN;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public IStatus[] getChildren() {
        return this.children;
    }

    public int getSeverity() {
        if (this.children == NO_CHILDREN) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.children.length;
        while (i < max) {
            int childrenSeverity = this.children[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Reference  Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }

    public String getMessage() {
        switch (this.getCode()) {
            case 101: {
                return "The link for this reference could not be found";
            }
            case 100: {
                return "Link has cross project references";
            }
            case 102: {
                return "Error while putting key-value pair [" + this.string + "]";
            }
            case 103: {
                return "Error while removing key: " + this.string;
            }
            case 104: {
                return "Error while searching: " + this.string;
            }
            case 105: {
                return "Could not assign id to new record: " + this.string;
            }
            case 106: {
                return "Could not update record: " + this.string;
            }
            case 107: {
                return "Could not read record: " + this.string;
            }
            case 108: {
                return "Could not delete record: " + this.string;
            }
            case 109: {
                return "Error getting context range from document: " + this.string;
            }
            case 110: {
                return "Resource not accessible: " + this.string;
            }
            case 111: {
                return "Error while reseting database";
            }
            case 112: {
                return "Error while reloading database";
            }
            case 113: {
                return "Error while closing database";
            }
            case 114: {
                return "Error while resetting indexes";
            }
            case 115: {
                return "Error while syncing indexes";
            }
            case 116: {
                return "Error while closing indexes";
            }
            case 117: {
                return "Error while shutting down database";
            }
            case 118: {
                return "Error while shutting down indexing framework";
            }
            case 500: {
                return "Problem notifying error listener";
            }
            case 10000: {
                return this.string == null ? this.getException().toString() : String.valueOf(this.string) + this.getException().toString();
            }
        }
        if (this.string != null) {
            return this.string;
        }
        Throwable exception = this.getException();
        if (exception != null) {
            String message = exception.getMessage();
            if (message != null) {
                return message;
            }
            return exception.toString();
        }
        if (this.isMultiStatus()) {
            return "MultiReferenceStatus";
        }
        return "";
    }
}

