/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.references.internal.management;

import com.ibm.etools.references.InternalAPI;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.internal.bplustree.db.ExtentManager;
import com.ibm.etools.references.internal.bplustree.db.FatalIOException;
import com.ibm.etools.references.internal.bplustree.db.PooledByteBuffer;
import com.ibm.etools.references.internal.bplustree.tree.ByteUtils;
import com.ibm.etools.references.internal.index.IdentityLinkedSet;
import com.ibm.etools.references.internal.index.IndexConstants;
import com.ibm.etools.references.internal.index.IndexManager;
import com.ibm.etools.references.internal.index.InternalReferenceObject;
import com.ibm.etools.references.internal.index.InternalReferenceRecord;
import com.ibm.etools.references.internal.index.ReferenceDatabase;
import com.ibm.etools.references.internal.index.keys.LinkKey;
import com.ibm.etools.references.internal.management.ReferenceStatus;
import com.ibm.etools.references.internal.search.InternalSearchPattern;
import com.ibm.etools.references.internal.services.BrokenReferenceStrategyService;
import com.ibm.etools.references.internal.services.LinkTypeRegistry;
import com.ibm.etools.references.internal.services.ReferenceGeneratorService;
import com.ibm.etools.references.internal.services.Service;
import com.ibm.etools.references.internal.util.Util;
import com.ibm.etools.references.management.BrokenReference;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.Reference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.services.providers.IProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;

public class Link
extends InternalReferenceObject
implements ILink {
    TempLinkInfo info;
    public final Record record;
    int specializedType;
    int cOffset;
    int cLength;
    int cLine;
    int liOffset;
    int liLength;
    int liLine;
    int linktext = -1;
    int contextText = -1;
    int path = -1;
    int name = -1;
    boolean endpoint;
    int[][] parameters;
    int resourceType = -1;
    boolean crossProjectAddressable = false;
    private List<LinkKey> originalKeys;
    private Link snapshot;
    private char[] cachedRetrievedText;

    public Link() {
        this(true);
    }

    public Link(boolean createRecord) {
        if (createRecord) {
            this.record = new Record(this);
            this.record.dirty = true;
        } else {
            this.record = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String key, String value) {
        this.loadData();
        TempLinkInfo in = this.getInfo();
        Object object = this.getSync();
        synchronized (object) {
            if (in.tempParams == null) {
                in.tempParams = new String[1][];
                in.tempParams[0] = new String[]{key, value};
            } else {
                String[][] oldParams = in.tempParams;
                String[][] newParams = new String[oldParams.length + 1][];
                System.arraycopy(oldParams, 0, newParams, 0, oldParams.length);
                newParams[in.tempParams.length] = new String[]{key, value};
                in.tempParams = newParams;
            }
            Arrays.sort(in.tempParams, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (((String[])o1)[0] == null && ((String[])o2)[0] == null) {
                        return 0;
                    }
                    if (((String[])o1)[0] == null && ((String[])o2)[0] != null) {
                        return -1;
                    }
                    if (((String[])o1)[0] != null && ((String[])o2)[0] == null) {
                        return 1;
                    }
                    return ((String[])o1)[0].compareTo(((String[])o2)[0]);
                }
            });
            this.record.dirty = true;
        }
    }

    @Override
    protected synchronized void clearOriginalKeys() {
        this.originalKeys = null;
        this.snapshot = null;
    }

    @Override
    public Collection<BrokenReference> findBrokenReferences(IProgressMonitor monitor) throws ReferenceException {
        return this.findBrokenReferences(monitor, true);
    }

    @Override
    public Collection<BrokenReference> findBrokenReferences(IProgressMonitor monitor, boolean forceCrossProjectReferences) throws ReferenceException {
        Set<IResolvedReference> matches = this.getResolvedReferences(SearchEngine.createWorkspaceScope(), monitor, false);
        if (!forceCrossProjectReferences) {
            for (IResolvedReference rr : matches) {
                Reference r = rr.getReference();
                if (r == null || !r.isCrossProject()) continue;
                throw new ReferenceException(new ReferenceStatus(4, 100, null));
            }
        }
        Collection<BrokenReference> broken = BrokenReferenceStrategyService.getInstance().findBrokenReferences(this, matches);
        return broken;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.getAdapterFor(adapter);
    }

    public <T> T getAdapterFor(Class<T> adapter) {
        IProvider p;
        if (adapter.isAssignableFrom(this.getClass())) {
            return adapter.cast(this);
        }
        if (IProvider.class.isAssignableFrom(adapter) && (p = InternalAPI.getProviderById(this.getProviderId())) != null) {
            try {
                return adapter.cast(p);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return adapter.cast(Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName()));
    }

    public String getCachingKey() {
        this.loadData();
        StringBuilder b = new StringBuilder();
        b.append(this.getSpecializedType().getTypeid());
        b.append(this.getPath());
        b.append(this.getName());
        b.append("|");
        b.append(this.getLinkLocation().getLinenumber());
        b.append("|");
        b.append(this.getLinkLocation().getOffset());
        b.append("|");
        b.append(this.getLinkLocation().getLength());
        b.append("|");
        b.append(this.getContextLocation().getLinenumber());
        b.append("|");
        b.append(this.getContextLocation().getOffset());
        b.append("|");
        b.append(this.getContextLocation().getLength());
        b.append("|");
        b.append(this.getLinkText());
        b.append("|");
        b.append(this.getContextText());
        b.append("|");
        String[][] params = this.getParameters();
        if (params != null) {
            String[][] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String[] entry = stringArray[n2];
                b.append(entry[0]);
                b.append("|");
                b.append(entry[1]);
                b.append("|");
                ++n2;
            }
        }
        return b.toString();
    }

    @Override
    public LinkNode<IResource> getContainer() {
        this.loadData();
        TempLinkInfo in = this.info;
        LinkNode<IResource> node = this.getMyContainer();
        LinkNode<IResource> res = in == null ? node : (in.resolveContainer() == null ? node : in.resolveContainer());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LinkNode<IResource> getMyContainer() {
        IFile file = null;
        Object object = this.getSync();
        synchronized (object) {
            if (this.info != null && this.info.resourceType != -1) {
                return this.info.resolveContainer();
            }
            if (this.record != null && this.record.getId() == -1) {
                return null;
            }
        }
        String s = this.getPathString();
        if (this.resourceType == 1) {
            if (s != null) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(s));
            }
        } else if (this.resourceType == 2) {
            if (s != null) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(s));
            }
        } else if (this.resourceType == 4) {
            if (s != null) {
                file = ResourcesPlugin.getWorkspace().getRoot().getProject(s);
            }
        } else if (this.resourceType != 0) {
            throw new RuntimeException("Unexpected resource type: " + this.resourceType);
        }
        if (file == null) {
            return null;
        }
        return ReferenceManager.getReferenceManager().getLinkNode((IResource)file);
    }

    protected String getPathString() {
        return this.getString(this.path);
    }

    private final String getString(int id) {
        return ReferenceDatabase.getDefault().getString(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextRange getContextLocation() {
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            return this.info == null ? new TextRange(this.cOffset, this.cLength, this.cLine) : (this.info.contextLocation == null ? new TextRange(this.cOffset, this.cLength, this.cLine) : this.info.contextLocation);
        }
    }

    protected String getContextTextString() {
        return this.getString(this.contextText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContextText() {
        int _cLength;
        int _coffset;
        TempLinkInfo in;
        int res;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            res = this.resourceType;
            in = this.info;
            _coffset = this.cOffset;
            _cLength = this.cLength;
        }
        IPath p = this.getPath();
        if (p != null) {
            if (in != null && in.contextText != null) {
                return in.contextText;
            }
            if (in != null && in.contextLocation != null && in.resourceType == 1) {
                char[] copy = this.cachedRetrievedText;
                if (copy != null) {
                    return new String(copy);
                }
                this.cachedRetrievedText = this.retrieveTextFromDocument(in.contextLocation.getOffset(), in.contextLocation.getLength(), in.resolveContainer().getResource().getFullPath());
                return new String(this.cachedRetrievedText);
            }
            if (res == 0 || this.isSnapshot()) {
                return this.getContextTextString();
            }
            if (res != 1) {
                return null;
            }
            if (_cLength == 0) {
                return "";
            }
            char[] copy = this.cachedRetrievedText;
            if (copy != null) {
                return new String(copy);
            }
            this.cachedRetrievedText = this.retrieveTextFromDocument(_coffset, _cLength, p);
            return new String(this.cachedRetrievedText);
        }
        return null;
    }

    private String detectCharset(IFile file) {
        String charset;
        block21: {
            charset = null;
            if (file.getType() == 1 && file.isAccessible()) {
                IContentDescription d = null;
                try {
                    d = file.getContentDescription();
                    if (d != null) {
                        charset = d.getCharset();
                    }
                }
                catch (CoreException coreException) {}
                if (charset == null) {
                    InputStream contents = null;
                    try {
                        try {
                            contents = file.getContents();
                            IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(contents, file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
                            if (description != null) {
                                charset = description.getCharset();
                            }
                        }
                        catch (Exception exception) {
                            if (contents != null) {
                                try {
                                    contents.close();
                                }
                                catch (Exception exception2) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (contents != null) {
                            try {
                                contents.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (charset == null) {
            return ResourcesPlugin.getEncoding();
        }
        return charset;
    }

    private char[] retrieveTextFromDocument(final int offset, final int len, final IPath path) {
        if (len == 0) {
            return new char[0];
        }
        FutureTask<char[]> docContextRetriever = new FutureTask<char[]>(new Callable<char[]>(){

            @Override
            public char[] call() throws Exception {
                ITextFileBuffer buffer = (ITextFileBuffer)TextFileBufferManager.DEFAULT.getFileBuffer(path, LocationKind.IFILE);
                if (buffer == null) {
                    IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    if (f.isAccessible()) {
                        String charset = Link.this.detectCharset(f);
                        InputStream is = f.getContents();
                        try {
                            InputStreamReader reader = new InputStreamReader(is, charset);
                            reader.skip(offset);
                            char[] readBuffer = new char[len];
                            reader.read(readBuffer);
                            char[] cArray = readBuffer;
                            return cArray;
                        }
                        finally {
                            is.close();
                        }
                    }
                    throw new ReferenceException(new ReferenceStatus(110, path.toString()));
                }
                return buffer.getDocument().get(offset, len).toCharArray();
            }
        });
        docContextRetriever.run();
        return this.getString(docContextRetriever);
    }

    @Override
    public final IReferenceElement.ElementType getElementType() {
        return IReferenceElement.ElementType.LINK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempLinkInfo getInfo() {
        Object object = this.getSync();
        synchronized (object) {
            if (this.info == null) {
                this.info = new TempLinkInfo();
            }
        }
        this.info.init(this);
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextRange getLinkLocation() {
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            return this.info == null ? new TextRange(this.liOffset, this.liLength, this.liLine) : (this.info.linkTextlocation == null ? new TextRange(this.liOffset, this.liLength, this.liLine) : this.info.linkTextlocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLinkText() {
        TempLinkInfo in;
        int i;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            i = this.linktext;
            in = this.info;
        }
        return in == null ? this.getString(i) : (in.linktext == null ? this.getString(i) : in.linktext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        TempLinkInfo in;
        int i;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            i = this.name;
            in = this.info;
            if (in != null && this.record.getId() == -1) {
                return in.name;
            }
        }
        return in == null ? this.getString(i) : (in.name == null ? this.getString(i) : in.name);
    }

    @Override
    public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
        graph.add(this);
    }

    @Override
    protected synchronized List<LinkKey> getOriginalKeys() {
        return this.originalKeys;
    }

    @Override
    protected Link getOriginal() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParameter(String key) {
        int k;
        this.loadData();
        int id = -1;
        String t = null;
        Object object = this.getSync();
        synchronized (object) {
            t = this.getTempParam(key);
        }
        if (t == null && (k = ReferenceDatabase.getDefault().lookupKey(key)) != -1) {
            Object object2 = this.getSync();
            synchronized (object2) {
                id = this.getSavedParam(k);
            }
            if (id != -1) {
                t = ReferenceDatabase.getDefault().getString(id);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getParameters() {
        Object localCopy = null;
        String[][] params = null;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            int i;
            int size = (this.parameters == null ? 0 : this.parameters.length) + (this.info == null || this.info.tempParams == null ? 0 : this.info.tempParams.length);
            params = new String[size][];
            int count = -1;
            if (this.info != null && this.info.tempParams != null) {
                i = 0;
                while (i < this.info.tempParams.length) {
                    String[] string = this.info.tempParams[i];
                    params[++count] = string;
                    ++i;
                }
            }
            if (this.parameters != null) {
                localCopy = new int[this.parameters.length][];
                i = 0;
                while (i < this.parameters.length) {
                    int[] ints = this.parameters[i];
                    localCopy[i] = Arrays.copyOf(ints, 2);
                    ++i;
                }
            }
        }
        if (localCopy != null) {
            int count = -1;
            params = new String[((int[][])localCopy).length][];
            if (this.parameters != null) {
                int i = 0;
                while (i < this.parameters.length) {
                    int[] ints = this.parameters[i];
                    params[++count] = new String[]{ReferenceDatabase.getDefault().getString(ints[0]), ReferenceDatabase.getDefault().getString(ints[1])};
                    ++i;
                }
            }
        }
        Arrays.sort(params, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (((String[])o1)[0] == null && ((String[])o2)[0] == null) {
                    return 0;
                }
                if (((String[])o1)[0] == null && ((String[])o2)[0] != null) {
                    return -1;
                }
                if (((String[])o1)[0] != null && ((String[])o2)[0] == null) {
                    return 1;
                }
                return ((String[])o1)[0].compareTo(((String[])o2)[0]);
            }
        });
        return params;
    }

    @Override
    public IPath getPath() {
        return this.getPath(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IPath getPath(boolean noAssert) {
        LinkNode<IResource> container = this.getContainer();
        String p = this.getPathString();
        Object object = this.getSync();
        synchronized (object) {
            if (this.info == null) {
                if (container != null) {
                    return container.getResource().getFullPath();
                }
                if (p == null) {
                    if (noAssert || !this.frozen) {
                        return null;
                    }
                    Assert.isTrue((boolean)false, (String)("Violation: getPathString() was null, info was null, getContainer() was null. Record was: " + this.record.toString()));
                }
                return new Path(p);
            }
            if (container != null) {
                return container.getResource().getFullPath();
            }
            if (this.info.path != null) {
                return new Path(this.info.path);
            }
            if (p == null) {
                if (noAssert || !this.frozen) {
                    return null;
                }
                Assert.isTrue((boolean)false, (String)("Violation: getPathString() was null, info was not, info.path was null, container was not null. Record was: " + this.record.toString()));
            }
            return new Path(p);
        }
    }

    @Override
    public InternalReferenceRecord getRecord() {
        return this.record;
    }

    protected Object getSync() {
        return this.record;
    }

    @Override
    public List<String> getReferenceTypes() {
        return ReferenceGeneratorService.getInstance().getGenerableTypes(this);
    }

    private Set<IResolvedReference> getResolvedReferences(SearchScope scope, IProgressMonitor monitor, boolean incoming) throws ReferenceException {
        if (!incoming && this.isEndPoint()) {
            return Collections.emptySet();
        }
        IndexConstants constant = incoming ? IndexConstants.BY_TARGETLINKID : IndexConstants.BY_SOURCELINKID;
        SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.getId()), constant, IReferenceElement.ElementType.RESOLVED_REFERENCE, 0);
        DefaultSearchRequestor req = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, req, monitor);
        Set<IResolvedReference> matches = req.getMatches();
        return matches;
    }

    private int getSavedParam(int k) {
        if (this.parameters != null) {
            if (k == -1) {
                return -1;
            }
            int idx = Arrays.binarySearch(this.parameters, k, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((int[])o1)[0] - (Integer)o2;
                }
            });
            if (idx >= 0) {
                return this.parameters[idx][1];
            }
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecializedType getSpecializedType() {
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            return this.info == null ? LinkTypeRegistry.getInstance().getLinkByTypeId(this.specializedType) : (this.info.specializedType == null ? LinkTypeRegistry.getInstance().getLinkByTypeId(this.specializedType) : this.info.specializedType);
        }
    }

    private char[] getString(FutureTask<char[]> record) {
        boolean interrupted = false;
        while (true) {
            try {
                char[] cArray = record.get();
                return cArray;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof FatalIOException) {
                    throw (FatalIOException)e.getCause();
                }
                if (e.getCause() instanceof ReferenceException) {
                    throw (ReferenceException)e.getCause();
                }
                Throwable t = e.getCause() == null ? e : e.getCause();
                ReferenceStatus status = new ReferenceStatus(4, 109, "Path: " + this.getPath() + ", Range: " + this.getContextLocation(), t);
                throw new ReferenceException(status);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private String getTempParam(String key) {
        if (this.info != null && this.info.tempParams != null) {
            int idx = Arrays.binarySearch(this.info.tempParams, key, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((String[])o1)[0].compareTo((String)o2);
                }
            });
            if (idx >= 0) {
                return this.info.tempParams[idx][1];
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCrossProjectAddressable() {
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            return this.info == null ? this.crossProjectAddressable : (this.info.crossProjectAddressable == -1 ? this.crossProjectAddressable : this.info.crossProjectAddressable == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEndPoint() {
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            return this.info == null ? this.endpoint : (this.info.endpoint == -1 ? this.endpoint : this.info.endpoint == 1);
        }
    }

    public boolean isParseOnly() {
        return false;
    }

    @Override
    public Collection<IResolvedReference> resolveIncomingReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
        return this.resolveIncomingReference(referenceType, SearchEngine.createWorkspaceScope(), monitor);
    }

    @Override
    public Collection<IResolvedReference> resolveIncomingReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
        Set<IResolvedReference> matches = this.getResolvedReferences(scope, progressMonitor, true);
        if (referenceType == null) {
            return matches;
        }
        HashSet<IResolvedReference> references = new HashSet<IResolvedReference>();
        for (IResolvedReference rr : matches) {
            String refType = rr.getReferenceType();
            if (refType == null || !refType.equals(referenceType)) continue;
            references.add(rr);
        }
        return references;
    }

    @Override
    public Collection<IResolvedReference> resolveReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
        return this.resolveReference(referenceType, SearchEngine.createWorkspaceScope(), monitor);
    }

    @Override
    public Collection<IResolvedReference> resolveReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
        Set<IResolvedReference> matches = this.getResolvedReferences(scope, progressMonitor, false);
        if (referenceType == null) {
            return matches;
        }
        HashSet<IResolvedReference> references = new HashSet<IResolvedReference>();
        for (IResolvedReference rr : matches) {
            String refType = rr.getReferenceType();
            if (refType == null || !refType.equals(referenceType)) continue;
            references.add(rr);
        }
        return references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOriginal() {
        if (this.getId() == -1) {
            return;
        }
        Link link = this;
        synchronized (link) {
            this.loadData();
            if (this.frozen) {
                if (this.originalKeys == null) {
                    this.originalKeys = IndexManager.getKeys(this);
                }
                if (this.snapshot == null) {
                    this.snapshot = this.snapshot((Map)new HashMap(1, 1.0f));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(LinkNode<IResource> container) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getContainer(), container);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                TempLinkInfo i = this.getInfo();
                i.path = container.getResource().getFullPath().toString();
                i.resourceType = container.getResource().getType();
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setContextLocation(TextRange contextLocation) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getContextLocation(), contextLocation);
        }
        if (!equal) {
            this.cachedRetrievedText = null;
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().contextLocation = contextLocation;
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setContextText(String contextText) {
        boolean equal;
        boolean error;
        String text;
        this.loadData();
        String newText = contextText;
        try {
            text = this.getContextText();
            error = false;
        }
        catch (RuntimeException runtimeException) {
            error = true;
            text = null;
        }
        Object object = this.getSync();
        synchronized (object) {
            if (!error) {
                equal = Util.isEqualOrBothNull(text, contextText);
                if (this.getContainer() != null) {
                    if (this.isParseOnly()) {
                        equal = false;
                    } else {
                        newText = null;
                    }
                }
            } else {
                equal = false;
            }
        }
        if (!equal) {
            this.cachedRetrievedText = null;
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().contextText = newText;
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
        return !equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrossProjectAddressable(boolean crossProjectAddressable) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = this.isCrossProjectAddressable() == crossProjectAddressable;
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().crossProjectAddressable = (short)(crossProjectAddressable ? 1 : -1);
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(boolean endpoint) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = this.isEndPoint() == endpoint;
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().endpoint = (short)(endpoint ? 1 : -1);
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLocation(TextRange location) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getLinkLocation(), location);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().linkTextlocation = location;
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getName(), name);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().name = name;
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(IPath path) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getPath(), path);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                TempLinkInfo i = this.getInfo();
                i.resourceType = 0;
                i.path = path.toString();
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecializedType(SpecializedType specializedType) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getSpecializedType(), specializedType);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().specializedType = specializedType;
            }
            object = this.getSync();
            synchronized (object) {
                this.record.dirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setText(String text) {
        boolean equal;
        this.loadData();
        Object object = this.getSync();
        synchronized (object) {
            equal = Util.isEqualOrBothNull(this.getLinkText(), text);
        }
        if (!equal) {
            object = this;
            synchronized (object) {
                this.saveOriginal();
                this.getInfo().linktext = text;
            }
            object = this.record;
            synchronized (object) {
                this.record.dirty = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (InternalAPI.LOAD_DATA_FOR_TO_STRING) {
            this.loadData();
        }
        if (this.isSnapshot() || this.record.isFullyLoaded()) {
            String s = "";
            if (this.isSnapshot()) {
                s = String.valueOf(s) + "Snap: ";
            }
            s = String.valueOf(s) + (this.getElementType() == null ? "null" : String.valueOf(this.getElementType().name()) + " " + super.toString() + " Type: [" + (this.getSpecializedType() == null ? "null" : this.getSpecializedType().getId()) + "] LinkText: [" + this.getLinkText() + "] " + " Name: [" + this.getName() + "] Path: [" + (this.getPath(true) == null ? "null" : this.getPath(true).toString()) + "]");
            if (this.parameters != null) {
                s = String.valueOf(s) + " " + this.parameters.length + " Saved parameters: ";
                s = String.valueOf(s) + Arrays.deepToString((Object[])this.parameters);
            }
            if (this.info != null) {
                s = String.valueOf(s) + this.info.toString();
            }
            s = String.valueOf(s) + " isEndpoint: " + this.isEndPoint();
            s = String.valueOf(s) + " isCrossProjectAddressable: " + this.isCrossProjectAddressable();
            s = String.valueOf(s) + " isSnapshot: " + this.isSnapshot();
            s = String.valueOf(s) + " isValid: " + this.isValid();
            if (this.providerId >= 0) {
                s = String.valueOf(s) + " Provided by: " + Service.getProviderType(this.providerId) + "(" + Service.getProviderClass(this.providerId) + ")";
            }
            return s;
        }
        String s = this.getElementType() == null ? "null" : String.valueOf(this.getElementType().name()) + " " + "Proxy object: " + super.toString();
        s = String.valueOf(s) + " isValid: " + this.isValid();
        return s;
    }

    @Override
    public boolean isSnapshot() {
        return false;
    }

    @Override
    public Link snapshot(Map<IReferenceElement, IReferenceElement> snapMap) {
        if (!InternalAPI.Tweaks.SHOULD_USE_SNAPSHOT) {
            return this;
        }
        IReferenceElement snap = snapMap.get(this);
        if (snap != null) {
            return (Link)snap;
        }
        if (this.getContainer() != null) {
            String text;
            try {
                text = this.getContextText();
            }
            catch (ReferenceException e) {
                if (e.getStatus().getCode() == 110) {
                    text = "[deleted]";
                }
                throw e;
            }
            snap = new LinkSnapshot(this.getId(), this.getSpecializedType().getTypeid(), this.getName(), this.getLinkText(), this.getLinkLocation(), text, this.getContextLocation(), this.getContainer().getResource().getType(), this.getPath(), this.getParameters(), this.providerId);
        } else {
            snap = new LinkSnapshot(this.getId(), this.getSpecializedType().getTypeid(), this.getName(), this.getLinkText(), this.getLinkLocation(), null, this.getContextLocation(), this.resourceType, this.getPath(), this.getParameters(), this.providerId);
        }
        snapMap.put(this, snap);
        return (Link)snap;
    }

    static class LinkSnapshot
    extends Link {
        private final int id;
        private final IPath ipath;
        private final String _name;
        private final String _linktext;
        private final String _contextText;
        private final String[][] params;

        public LinkSnapshot(int id, int specializedType, String name, String linkText, TextRange linkRange, String contextText, TextRange contextRange, int resourceType, IPath path, String[][] params, int providerId) {
            super(false);
            this.id = id;
            this.specializedType = specializedType;
            this._name = name;
            this._linktext = linkText;
            this.liOffset = linkRange.getOffset();
            this.liLength = linkRange.getLength();
            this.liLine = linkRange.getLinenumber();
            this._contextText = contextText;
            this.cOffset = contextRange.getOffset();
            this.cLength = contextRange.getLength();
            this.cLine = contextRange.getLinenumber();
            this.resourceType = resourceType;
            this.ipath = path;
            this.params = params;
            this.providerId = providerId;
        }

        @Override
        public boolean isSnapshot() {
            return true;
        }

        @Override
        protected String getPathString() {
            return this.ipath.toString();
        }

        @Override
        public void addParameter(String key, String value) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        protected void clearOriginalKeys() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public Collection<BrokenReference> findBrokenReferences(IProgressMonitor monitor) throws ReferenceException {
            return super.findBrokenReferences(monitor);
        }

        @Override
        public String getCachingKey() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public LinkNode<IResource> getContainer() {
            return super.getContainer();
        }

        @Override
        public TextRange getContextLocation() {
            return super.getContextLocation();
        }

        @Override
        protected String getContextTextString() {
            return this._contextText;
        }

        @Override
        public String getContextText() {
            return super.getContextText();
        }

        @Override
        public TextRange getLinkLocation() {
            return super.getLinkLocation();
        }

        @Override
        public String getLinkText() {
            return this._linktext;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public void getObjectGraph(IdentityLinkedSet<InternalReferenceObject> graph, Map<Object, Object> objMarkers) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public Link snapshot(Map<IReferenceElement, IReferenceElement> snapMap) {
            return this;
        }

        @Override
        protected List<LinkKey> getOriginalKeys() {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public String getParameter(String key) {
            int idx = Arrays.binarySearch(this.params, key, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((String[])o1)[0].compareTo((String)o2);
                }
            });
            if (idx >= 0) {
                return this.params[idx][1];
            }
            return null;
        }

        @Override
        public String[][] getParameters() {
            throw new UnsupportedOperationException("not part of client api");
        }

        @Override
        public IPath getPath() {
            return this.ipath;
        }

        @Override
        public InternalReferenceRecord getRecord() {
            return null;
        }

        @Override
        protected Object getSync() {
            return this;
        }

        @Override
        public List<String> getReferenceTypes() {
            return super.getReferenceTypes();
        }

        @Override
        public SpecializedType getSpecializedType() {
            return super.getSpecializedType();
        }

        @Override
        public boolean isCrossProjectAddressable() {
            return super.isCrossProjectAddressable();
        }

        @Override
        public boolean isEndPoint() {
            return super.isEndPoint();
        }

        @Override
        public Collection<IResolvedReference> resolveIncomingReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
            throw new UnsupportedOperationException("Object is snapshot");
        }

        @Override
        public Collection<IResolvedReference> resolveIncomingReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
            throw new UnsupportedOperationException("Object is snapshot");
        }

        @Override
        public Collection<IResolvedReference> resolveReference(String referenceType, IProgressMonitor monitor) throws ReferenceException {
            throw new UnsupportedOperationException("Object is snapshot");
        }

        @Override
        public Collection<IResolvedReference> resolveReference(String referenceType, SearchScope scope, IProgressMonitor progressMonitor) throws ReferenceException {
            throw new UnsupportedOperationException("Object is snapshot");
        }

        @Override
        public void setContainer(LinkNode<IResource> container) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public boolean setContextLocation(TextRange contextLocation) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public boolean setContextText(String contextText) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setCrossProjectAddressable(boolean crossProjectAddressable) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setEndpoint(boolean endpoint) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public boolean setLocation(TextRange location) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setPath(IPath path) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public void setSpecializedType(SpecializedType specializedType) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public boolean setText(String text) {
            throw new UnsupportedOperationException("Object is read only");
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public void freeze() {
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void init(ExtentManager manager) {
        }

        @Override
        protected boolean isFrozen() {
            return true;
        }

        @Override
        public void loadData() {
        }

        @Override
        public void markLoaded() {
        }
    }

    public static class ParsedLink
    extends Link {
        @Override
        public boolean isParseOnly() {
            return true;
        }
    }

    static class Record
    extends InternalReferenceRecord {
        private final Link link;
        boolean dirty;

        public Record(Link link) {
            super(link.getElementType().ordinal());
            this.link = link;
        }

        @Override
        public void aboutToDelete() {
            this.link.getInfo();
        }

        @Override
        protected void aboutToUpdate(ReferenceEvent.Kind kind) {
            if (this.link.info == null) {
                return;
            }
            this.link.cachedRetrievedText = null;
            int size = this.link.info.tempParams == null ? 0 : this.link.info.tempParams.length;
            int[][] params = new int[size][];
            int c = -1;
            if (this.link.info != null && this.link.info.tempParams != null) {
                int i = 0;
                while (i < this.link.info.tempParams.length) {
                    String[] stringEntry = this.link.info.tempParams[i];
                    params[++c] = new int[]{ReferenceDatabase.getDefault().addString(stringEntry[0]), ReferenceDatabase.getDefault().addString(stringEntry[1])};
                    ++i;
                }
            }
            int len = this.link.parameters == null ? 0 : this.link.parameters.length;
            int[] list = new int[len * 2];
            int j = -1;
            int i = 0;
            while (i < len) {
                list[++j] = this.link.parameters[i][0];
                list[++j] = this.link.parameters[i][1];
                ++i;
            }
            ReferenceDatabase.getDefault().removeStrings(list);
            Arrays.sort(params, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((int[])o1)[0] - ((int[])o2)[0];
                }
            });
            this.link.parameters = (int[][])(params.length == 0 ? null : (int[][])params);
            if (this.link.info.resourceType != -1) {
                this.link.resourceType = this.link.info.resourceType;
                if (this.link.info.path != null) {
                    int pathId;
                    this.link.path = pathId = ReferenceDatabase.getDefault().updateString(this.link.path, this.link.info.path);
                }
            }
            if (this.link.info.name != null) {
                int nameId;
                this.link.name = nameId = ReferenceDatabase.getDefault().updateString(this.link.name, this.link.info.name);
            }
            if (this.link.info.linktext != null) {
                int linkTextId;
                this.link.linktext = linkTextId = ReferenceDatabase.getDefault().updateString(this.link.linktext, this.link.info.linktext);
            }
            if (this.link.info.contextText != null) {
                int cntextTextId;
                this.link.contextText = cntextTextId = ReferenceDatabase.getDefault().updateString(this.link.contextText, this.link.info.contextText);
            }
            if (this.link.info.linkTextlocation != null) {
                this.link.liOffset = this.link.info.linkTextlocation.getOffset();
                this.link.liLength = this.link.info.linkTextlocation.getLength();
                this.link.liLine = this.link.info.linkTextlocation.getLinenumber();
            }
            if (this.link.info.contextLocation != null) {
                this.link.cOffset = this.link.info.contextLocation.getOffset();
                this.link.cLength = this.link.info.contextLocation.getLength();
                this.link.cLine = this.link.info.contextLocation.getLinenumber();
            }
            if (this.link.info.crossProjectAddressable != -1) {
                boolean bl = this.link.crossProjectAddressable = this.link.info.crossProjectAddressable == 1;
            }
            if (this.link.info.endpoint != -1) {
                boolean bl = this.link.endpoint = this.link.info.endpoint == 1;
            }
            if (this.link.info.specializedType != null) {
                this.link.specializedType = this.link.info.specializedType.getTypeid();
            }
            this.link.info = null;
        }

        @Override
        protected void clean() {
            this.dirty = false;
        }

        @Override
        public void doReadRecord(PooledByteBuffer bytes) {
            this.link.endpoint = ByteUtils.bytesToBoolean(bytes.buffer);
            this.link.crossProjectAddressable = ByteUtils.bytesToBoolean(bytes.buffer);
            this.link.resourceType = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.link.path = ByteUtils.bytesToInt(bytes.buffer);
            TextRange c = new TextRange(0, 0, 0);
            c.readRecord(new PooledByteBuffer(bytes.buffer));
            this.link.cOffset = c.getOffset();
            this.link.cLength = c.getLength();
            this.link.cLine = c.getLinenumber();
            TextRange l = new TextRange(0, 0, 0);
            l.readRecord(new PooledByteBuffer(bytes.buffer));
            this.link.liOffset = l.getOffset();
            this.link.liLength = l.getLength();
            this.link.liLine = l.getLinenumber();
            this.link.specializedType = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            if (this.link.resourceType == 0) {
                this.link.linktext = ByteUtils.bytesToInt(bytes.buffer);
                this.link.contextText = ByteUtils.bytesToInt(bytes.buffer);
            } else {
                this.link.linktext = ByteUtils.bytesToInt(bytes.buffer);
            }
            this.link.name = ByteUtils.bytesToInt(bytes.buffer);
            int parameterSize = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            this.link.parameters = new int[parameterSize][];
            int i = 0;
            while (i < parameterSize) {
                int k = ByteUtils.bytesToInt(bytes.buffer);
                int v = ByteUtils.bytesToInt(bytes.buffer);
                this.link.parameters[i] = new int[]{k, v};
                ++i;
            }
            this.link.providerId = ByteUtils.bytesToUnsignedShort(bytes.buffer);
            bytes.returnBuffer();
            this.clean();
            this.link.freeze();
        }

        @Override
        public PooledByteBuffer doWriteRecord() {
            Object object;
            ArrayList<ByteBuffer> savedBuffers = new ArrayList<ByteBuffer>();
            ByteBuffer tmp = ByteUtils.booleanToBytes(this.link.endpoint);
            savedBuffers.add(tmp);
            tmp = ByteUtils.booleanToBytes(this.link.crossProjectAddressable);
            savedBuffers.add(tmp);
            tmp = ByteUtils.unsignedShortToBytes(this.link.resourceType);
            savedBuffers.add(tmp);
            tmp = ByteUtils.intToBytes(this.link.path);
            savedBuffers.add(tmp);
            TextRange c = new TextRange(this.link.cOffset, this.link.cLength, this.link.cLine);
            PooledByteBuffer buffer = c.writeRecord();
            savedBuffers.add(buffer.copy());
            buffer.returnBuffer();
            TextRange l = new TextRange(this.link.liOffset, this.link.liLength, this.link.liLine);
            buffer = l.writeRecord();
            savedBuffers.add(buffer.copy());
            buffer.returnBuffer();
            tmp = ByteUtils.unsignedShortToBytes(this.link.specializedType);
            savedBuffers.add(tmp);
            if (this.link.resourceType == 0) {
                tmp = ByteUtils.intToBytes(this.link.linktext);
                savedBuffers.add(tmp);
                tmp = ByteUtils.intToBytes(this.link.contextText);
                savedBuffers.add(tmp);
            } else {
                tmp = ByteUtils.intToBytes(this.link.linktext);
                savedBuffers.add(tmp);
            }
            tmp = ByteUtils.intToBytes(this.link.name);
            savedBuffers.add(tmp);
            if (this.link.parameters == null || this.link.parameters.length == 0) {
                savedBuffers.add(ByteUtils.unsignedShortToBytes(0));
            } else {
                savedBuffers.add(ByteUtils.unsignedShortToBytes(this.link.parameters.length));
                object = this.link.parameters;
                int n = this.link.parameters.length;
                int buffer2 = 0;
                while (buffer2 < n) {
                    int[] paramEntry = object[buffer2];
                    savedBuffers.add(ByteUtils.intToBytes(paramEntry[0]));
                    savedBuffers.add(ByteUtils.intToBytes(paramEntry[1]));
                    ++buffer2;
                }
            }
            tmp = ByteUtils.unsignedShortToBytes(this.link.providerId);
            savedBuffers.add(tmp);
            int size = 0;
            for (ByteBuffer byteBuffer : savedBuffers) {
                size += byteBuffer.limit();
            }
            PooledByteBuffer payload = PooledByteBuffer.INSTANCE.leaseByteBuffer(size);
            object = savedBuffers.iterator();
            while (object.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)object.next();
                payload.buffer.put(byteBuffer);
            }
            payload.buffer.rewind();
            return payload;
        }

        @Override
        protected Collection<? extends IReferenceElement> getDeleteCascade() {
            SearchPattern pattern = InternalSearchPattern.createPattern(Integer.toString(this.link.getId()), IndexConstants.BY_SOURCELINKID, IReferenceElement.ElementType.REFERENCE, 0);
            SearchScope scope = SearchEngine.createWorkspaceScope();
            DefaultSearchRequestor req = new DefaultSearchRequestor();
            new SearchEngine().search(pattern, scope, req, null);
            return req.getMatches();
        }

        @Override
        protected InternalReferenceObject getLinkArtifact() {
            return this.link;
        }

        @Override
        public int getSize() {
            int size = 18;
            if (this.link.resourceType == 0) {
                size += 6;
                size += 6;
            } else {
                size += 6;
            }
            if (this.link.parameters != null) {
                size += 8 * this.link.parameters.length;
            }
            return size;
        }

        @Override
        protected int[] getStringIds() {
            this.loadData();
            int len = this.link.parameters == null ? 0 : this.link.parameters.length;
            int[] list = new int[len * 2 + 4];
            int j = -1;
            int i = 0;
            while (i < len) {
                list[++j] = this.link.parameters[i][0];
                list[++j] = this.link.parameters[i][1];
                ++i;
            }
            list[++j] = this.link.name;
            list[++j] = this.link.path;
            list[++j] = this.link.contextText;
            list[++j] = this.link.linktext;
            return list;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }
    }

    static class TempLinkInfo {
        String name;
        String[][] tempParams;
        String path;
        int resourceType = -1;
        String linktext;
        TextRange linkTextlocation;
        TextRange contextLocation;
        public String contextText;
        public short crossProjectAddressable = (short)-1;
        public short endpoint = (short)-1;
        public SpecializedType specializedType;
        private boolean init;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void init(Link source) {
            TempLinkInfo tempLinkInfo = this;
            synchronized (tempLinkInfo) {
                if (!this.init) {
                    this.name = source.getName();
                    this.tempParams = source.getParameters();
                    IPath p = source.getPath(true);
                    if (p != null) {
                        this.path = p.toString();
                    }
                    this.resourceType = source.resourceType;
                    this.linktext = source.getLinkText();
                    this.linkTextlocation = source.getLinkLocation();
                    this.contextLocation = source.getContextLocation();
                    this.specializedType = source.getSpecializedType();
                    this.init = true;
                }
            }
        }

        public String toString() {
            return "TempLinkInfo [container=" + this.path + ", contextLocation=" + this.contextLocation + ", contextText=" + this.contextText + ", crossProjectAddressable=" + this.crossProjectAddressable + ", endpoint=" + this.endpoint + ", linkTextlocation=" + this.linkTextlocation + ", linktext=" + this.linktext + ", name=" + this.name + ", specializedType=" + this.specializedType + ", tempParams=" + Arrays.deepToString((Object[])this.tempParams) + "]";
        }

        public LinkNode<IResource> resolveContainer() {
            if (this.resourceType == 1) {
                if (this.path == null) {
                    return null;
                }
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.path));
                if (file != null) {
                    return ReferenceManager.getReferenceManager().getLinkNode((IResource)file);
                }
            } else if (this.resourceType == 2) {
                if (this.path == null) {
                    return null;
                }
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.path));
                if (folder != null) {
                    return ReferenceManager.getReferenceManager().getLinkNode((IResource)folder);
                }
            } else if (this.resourceType == 4) {
                if (this.path == null) {
                    return null;
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.path);
                if (project != null) {
                    return ReferenceManager.getReferenceManager().getLinkNode((IResource)project);
                }
            }
            return null;
        }
    }
}

